/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import com.datastax.driver.core.Row;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A  for  consumption.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraRowStream original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.cassandra.CassandraRowStream.class)
public class CassandraRowStream implements io.vertx.reactivex.core.streams.ReadStream<Row> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraRowStream that = (CassandraRowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<CassandraRowStream> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new CassandraRowStream((io.vertx.cassandra.CassandraRowStream) obj),
    CassandraRowStream::getDelegate
  );

  private final io.vertx.cassandra.CassandraRowStream delegate;
  
  public CassandraRowStream(io.vertx.cassandra.CassandraRowStream delegate) {
    this.delegate = delegate;
  }

  public CassandraRowStream(Object delegate) {
    this.delegate = (io.vertx.cassandra.CassandraRowStream)delegate;
  }

  public io.vertx.cassandra.CassandraRowStream getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<Row> observable;
  private io.reactivex.Flowable<Row> flowable;

  public synchronized io.reactivex.Observable<Row> toObservable() {
    if (observable == null) {
      observable = io.vertx.reactivex.ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<Row> toFlowable() {
    if (flowable == null) {
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<Row> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<Row> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<Row> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<Row> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<Row> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream endHandler(Handler<Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream fetch(long l) { 
    delegate.fetch(l);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream handler(Handler<Row> handler) { 
    delegate.handler(handler);
    return this;
  }

  public static CassandraRowStream newInstance(io.vertx.cassandra.CassandraRowStream arg) {
    return arg != null ? new CassandraRowStream(arg) : null;
  }

}
