/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * The composite future wraps a list of {@link io.vertx.reactivex.core.Future futures}, it is useful when several futures
 * needs to be coordinated.
 * The handlers set for the coordinated futures are overridden by the handler of the composite future.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.CompositeFuture original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.CompositeFuture.class)
public class CompositeFuture extends io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CompositeFuture that = (CompositeFuture) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<CompositeFuture> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new CompositeFuture((io.vertx.core.CompositeFuture) obj),
    CompositeFuture::getDelegate
  );

  private final io.vertx.core.CompositeFuture delegate;
  
  public CompositeFuture(io.vertx.core.CompositeFuture delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public CompositeFuture(Object delegate) {
    super((io.vertx.core.CompositeFuture)delegate);
    this.delegate = (io.vertx.core.CompositeFuture)delegate;
  }

  public io.vertx.core.CompositeFuture getDelegate() {
    return delegate;
  }

  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.CompositeFuture> TYPE_ARG_0 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.CompositeFuture>(o1 -> io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.CompositeFuture> TYPE_ARG_1 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.CompositeFuture>(o1 -> io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.CompositeFuture> TYPE_ARG_2 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.CompositeFuture>(o1 -> io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.CompositeFuture> TYPE_ARG_3 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.CompositeFuture>(o1 -> io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());

  /**
   * Set the result. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   */
  @Deprecated()
  public void complete(io.vertx.reactivex.core.CompositeFuture result) { 
    delegate.complete(result.getDelegate());
  }

  /**
   * Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   * @return false when the future is already completed
   */
  @Deprecated()
  public boolean tryComplete(io.vertx.reactivex.core.CompositeFuture result) { 
    boolean ret = delegate.tryComplete(result.getDelegate());
    return ret;
  }

  /**
   * The result of the operation. This will be null if the operation failed.
   * @return the result or null if the operation failed.
   */
  public io.vertx.reactivex.core.CompositeFuture result() { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)delegate.result());
    return ret;
  }

  /**
   * Alias for {@link io.vertx.reactivex.core.Future#compose}.
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.reactivex.core.Future<U> flatMap(Function<io.vertx.reactivex.core.CompositeFuture, io.vertx.reactivex.core.Future<U>> mapper) { 
    io.vertx.reactivex.core.Future<U> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.flatMap(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.reactivex.core.Future<U> ret = mapper.apply(io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)arg));
        return ret.getDelegate();
      }
    }), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Compose this future with a <code>mapper</code> function.<p>
   *
   * When this future (the one on which <code>compose</code> is called) succeeds, the <code>mapper</code> will be called with
   * the completed value and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the composed future
   */
  public <U> io.vertx.reactivex.core.Future<U> compose(Function<io.vertx.reactivex.core.CompositeFuture, io.vertx.reactivex.core.Future<U>> mapper) { 
    io.vertx.reactivex.core.Future<U> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.reactivex.core.Future<U> ret = mapper.apply(io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)arg));
        return ret.getDelegate();
      }
    }), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Compose this future with a <code>successMapper</code> and <code>failureMapper</code> functions.<p>
   *
   * When this future (the one on which <code>compose</code> is called) succeeds, the <code>successMapper</code> will be called with
   * the completed value and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   *
   * When this future (the one on which <code>compose</code> is called) fails, the <code>failureMapper</code> will be called with
   * the failure and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   *
   * If any mapper function throws an exception, the returned future will be failed with this exception.<p>
   * @param successMapper the function mapping the success
   * @param failureMapper the function mapping the failure
   * @return the composed future
   */
  public <U> io.vertx.reactivex.core.Future<U> compose(Function<io.vertx.reactivex.core.CompositeFuture, io.vertx.reactivex.core.Future<U>> successMapper, Function<Throwable, io.vertx.reactivex.core.Future<U>> failureMapper) { 
    io.vertx.reactivex.core.Future<U> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.reactivex.core.Future<U> ret = successMapper.apply(io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)arg));
        return ret.getDelegate();
      }
    }, new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(java.lang.Throwable arg) {
        io.vertx.reactivex.core.Future<U> ret = failureMapper.apply(arg);
        return ret.getDelegate();
      }
    }), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   *
   * When this future succeeds, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public <U> io.vertx.reactivex.core.Future<U> map(Function<io.vertx.reactivex.core.CompositeFuture, U> mapper) { 
    io.vertx.reactivex.core.Future<U> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.map(new java.util.function.Function<io.vertx.core.CompositeFuture,U>() {
      public U apply(io.vertx.core.CompositeFuture arg) {
        U ret = mapper.apply(io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)arg));
        return ret;
      }
    }), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return an handler completing this future
   */
  @Deprecated()
  public Handler<AsyncResult<io.vertx.reactivex.core.CompositeFuture>> completer() { 
    if (cached_0 != null) {
      return cached_0;
    }
    Handler<AsyncResult<io.vertx.reactivex.core.CompositeFuture>> ret = new Handler<AsyncResult<io.vertx.reactivex.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.reactivex.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          delegate.completer().handle(io.vertx.core.Future.succeededFuture(ar.result().getDelegate()));
        } else {
          delegate.completer().handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    cached_0 = ret;
    return ret;
  }

  /**
   * Handles a failure of this Future by returning the result of another Future.
   * If the mapper fails, then the returned future will be failed with this failure.
   * @param mapper A function which takes the exception of a failure and returns a new future.
   * @return A recovered future
   */
  public io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> recover(Function<Throwable, io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture>> mapper) { 
    io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.recover(new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<io.vertx.core.CompositeFuture>>() {
      public io.vertx.core.Future<io.vertx.core.CompositeFuture> apply(java.lang.Throwable arg) {
        io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), TYPE_ARG_0);
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   *
   * When this future fails, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> otherwise(Function<Throwable, io.vertx.reactivex.core.CompositeFuture> mapper) { 
    io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.otherwise(new java.util.function.Function<java.lang.Throwable,io.vertx.core.CompositeFuture>() {
      public io.vertx.core.CompositeFuture apply(java.lang.Throwable arg) {
        io.vertx.reactivex.core.CompositeFuture ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), TYPE_ARG_1);
    return ret;
  }

  /**
   * Map the failure of a future to a specific <code>value</code>.<p>
   *
   * When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future.
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> otherwise(io.vertx.reactivex.core.CompositeFuture value) { 
    io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.otherwise(value.getDelegate()), TYPE_ARG_2);
    return ret;
  }

  /**
   * Map the failure of a future to <code>null</code>.<p>
   *
   * This is a convenience for <code>future.otherwise((T) null)</code>.<p>
   *
   * When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future.
   * @return the mapped future
   */
  public io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> otherwiseEmpty() { 
    io.vertx.reactivex.core.Future<io.vertx.reactivex.core.CompositeFuture> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.otherwiseEmpty(), TYPE_ARG_3);
    return ret;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * <p/>
   * The returned future fails as soon as one of <code>f1</code> or <code>f2</code> fails.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.reactivex.core.CompositeFuture all(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#all} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.reactivex.core.CompositeFuture all(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#all} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.reactivex.core.CompositeFuture all(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#all} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.reactivex.core.CompositeFuture all(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4, io.vertx.reactivex.core.Future<T5> f5) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#all} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.reactivex.core.CompositeFuture all(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4, io.vertx.reactivex.core.Future<T5> f5, io.vertx.reactivex.core.Future<T6> f6) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#all} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.reactivex.core.CompositeFuture all(List<io.vertx.reactivex.core.Future> futures) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.all(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when any futures is succeeded, failed when all futures are failed.
   * <p/>
   * The returned future succeeds as soon as one of <code>f1</code> or <code>f2</code> succeeds.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.reactivex.core.CompositeFuture any(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#any} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.reactivex.core.CompositeFuture any(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#any} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.reactivex.core.CompositeFuture any(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#any} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.reactivex.core.CompositeFuture any(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4, io.vertx.reactivex.core.Future<T5> f5) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#any} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.reactivex.core.CompositeFuture any(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4, io.vertx.reactivex.core.Future<T5> f5, io.vertx.reactivex.core.Future<T6> f6) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#any} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.reactivex.core.CompositeFuture any(List<io.vertx.reactivex.core.Future> futures) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.any(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * <p/>
   * It always wait until all its futures are completed and will not fail as soon as one of <code>f1</code> or <code>f2</code> fails.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.reactivex.core.CompositeFuture join(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#join} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.reactivex.core.CompositeFuture join(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#join} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.reactivex.core.CompositeFuture join(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#join} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.reactivex.core.CompositeFuture join(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4, io.vertx.reactivex.core.Future<T5> f5) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#join} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.reactivex.core.CompositeFuture join(io.vertx.reactivex.core.Future<T1> f1, io.vertx.reactivex.core.Future<T2> f2, io.vertx.reactivex.core.Future<T3> f3, io.vertx.reactivex.core.Future<T4> f4, io.vertx.reactivex.core.Future<T5> f5, io.vertx.reactivex.core.Future<T6> f6) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.CompositeFuture#join} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.reactivex.core.CompositeFuture join(List<io.vertx.reactivex.core.Future> futures) { 
    io.vertx.reactivex.core.CompositeFuture ret = io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)io.vertx.core.CompositeFuture.join(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  @Deprecated()
  public io.vertx.reactivex.core.CompositeFuture setHandler(Handler<AsyncResult<io.vertx.reactivex.core.CompositeFuture>> handler) { 
    delegate.setHandler(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  @Deprecated()
  public Single<io.vertx.reactivex.core.CompositeFuture> rxSetHandler() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      setHandler(handler);
    });
  }

  public io.vertx.reactivex.core.CompositeFuture onComplete(Handler<AsyncResult<io.vertx.reactivex.core.CompositeFuture>> handler) { 
    delegate.onComplete(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.core.CompositeFuture> rxOnComplete() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      onComplete(handler);
    });
  }

  public io.vertx.reactivex.core.CompositeFuture onSuccess(Handler<io.vertx.reactivex.core.CompositeFuture> handler) { 
    delegate.onSuccess(new Handler<io.vertx.core.CompositeFuture>() {
      public void handle(io.vertx.core.CompositeFuture event) {
        handler.handle(io.vertx.reactivex.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.core.CompositeFuture onFailure(Handler<Throwable> handler) { 
    delegate.onFailure(handler);
    return this;
  }

  /**
   * Set this instance as result. Any handler will be called, if there is one, and the future will be marked as completed.
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * Try to set this instance as result. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
   * @return false when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * Returns a cause of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public Throwable cause(int index) { 
    Throwable ret = delegate.cause(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is succeeded
   * @param index the wrapped future index
   * @return 
   */
  public boolean succeeded(int index) { 
    boolean ret = delegate.succeeded(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is failed
   * @param index the wrapped future index
   * @return 
   */
  public boolean failed(int index) { 
    boolean ret = delegate.failed(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is completed
   * @param index the wrapped future index
   * @return 
   */
  public boolean isComplete(int index) { 
    boolean ret = delegate.isComplete(index);
    return ret;
  }

  /**
   * Returns the result of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public <T> T resultAt(int index) { 
    T ret = (T) delegate.resultAt(index);
    return ret;
  }

  /**
   * @return the number of wrapped future
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  private Handler<AsyncResult<io.vertx.reactivex.core.CompositeFuture>> cached_0;
  public static CompositeFuture newInstance(io.vertx.core.CompositeFuture arg) {
    return arg != null ? new CompositeFuture(arg) : null;
  }

}
