/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.datagram;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A datagram socket can be used to send {@link io.vertx.reactivex.core.datagram.DatagramPacket}'s to remote datagram servers
 * and receive {@link io.vertx.reactivex.core.datagram.DatagramPacket}s .
 * <p>
 * Usually you use a datagram socket to send UDP over the wire. UDP is connection-less which means you are not connected
 * to the remote peer in a persistent way. Because of this you have to supply the address and port of the remote peer
 * when sending data.
 * <p>
 * You can send data to ipv4 or ipv6 addresses, which also include multicast addresses.
 * <p>
 * Please consult the documentation for more information on datagram sockets.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramSocket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.datagram.DatagramPacket>, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramSocket that = (DatagramSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<DatagramSocket> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket) obj),
    DatagramSocket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramSocket delegate;
  
  public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
    this.delegate = delegate;
  }

  public DatagramSocket(Object delegate) {
    this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
  }

  public io.vertx.core.datagram.DatagramSocket getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.core.datagram.DatagramPacket> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.core.datagram.DatagramPacket> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.core.datagram.DatagramPacket> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.datagram.DatagramPacket, io.vertx.reactivex.core.datagram.DatagramPacket> conv = io.vertx.reactivex.core.datagram.DatagramPacket::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.core.datagram.DatagramPacket> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.core.datagram.DatagramPacket, io.vertx.reactivex.core.datagram.DatagramPacket> conv = io.vertx.reactivex.core.datagram.DatagramPacket::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.datagram.DatagramPacket> TYPE_ARG_0 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.datagram.DatagramPacket>(o1 -> io.vertx.reactivex.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_1 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.datagram.DatagramPacket> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.datagram.DatagramPacket> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.datagram.DatagramPacket> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.datagram.DatagramPacket> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.datagram.DatagramPacket> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  /**
   * Write the given {@link io.vertx.reactivex.core.buffer.Buffer} to the {@link io.vertx.reactivex.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.reactivex.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket send(io.vertx.reactivex.core.buffer.Buffer packet, int port, String host, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.send(packet.getDelegate(), port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link io.vertx.reactivex.core.buffer.Buffer} to the {@link io.vertx.reactivex.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.reactivex.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxSend(io.vertx.reactivex.core.buffer.Buffer packet, int port, String host) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      send(packet, port, host, handler);
    });
  }

  /**
   * Returns a <code>WriteStream<Buffer></code> able to send  to the
   * {@link io.vertx.reactivex.core.net.SocketAddress}.
   * @param port the port of the remote peer
   * @param host the host address of the remote peer
   * @return the write stream for sending packets
   */
  public io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> sender(int port, String host) { 
    io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.WriteStream.newInstance((io.vertx.core.streams.WriteStream)delegate.sender(port, host), TYPE_ARG_1);
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.reactivex.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket send(String str, int port, String host, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.send(str, port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.reactivex.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxSend(String str, int port, String host) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      send(str, port, host, handler);
    });
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.reactivex.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket send(String str, String enc, int port, String host, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.send(str, enc, port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.reactivex.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxSend(String str, String enc, int port, String host) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      send(str, enc, port, host, handler);
    });
  }

  /**
   * Closes the {@link io.vertx.reactivex.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @param handler the handler to notify once complete
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the {@link io.vertx.reactivex.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Closes the {@link io.vertx.reactivex.core.datagram.DatagramSocket}. The close itself is asynchronous.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Return the {@link io.vertx.reactivex.core.net.SocketAddress} to which
   * this {@link io.vertx.reactivex.core.datagram.DatagramSocket} is bound.
   * @return the socket address
   */
  public io.vertx.reactivex.core.net.SocketAddress localAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket listenMulticastGroup(String multicastAddress, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxListenMulticastGroup(String multicastAddress) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listenMulticastGroup(multicastAddress, handler);
    });
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, networkInterface, source, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxListenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listenMulticastGroup(multicastAddress, networkInterface, source, handler);
    });
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxUnlistenMulticastGroup(String multicastAddress) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      unlistenMulticastGroup(multicastAddress, handler);
    });
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxUnlistenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      unlistenMulticastGroup(multicastAddress, networkInterface, source, handler);
    });
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, sourceToBlock, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxBlockMulticastGroup(String multicastAddress, String sourceToBlock) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      blockMulticastGroup(multicastAddress, sourceToBlock, handler);
    });
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxBlockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler);
    });
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param handler the handler will be called when listening
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket listen(int port, String host, Handler<AsyncResult<io.vertx.reactivex.core.datagram.DatagramSocket>> handler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxListen(int port, String host) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(port, host, handler);
    });
  }

  public io.vertx.reactivex.core.datagram.DatagramSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.datagram.DatagramSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.datagram.DatagramSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.core.datagram.DatagramSocket endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.datagram.DatagramSocket handler(Handler<io.vertx.reactivex.core.datagram.DatagramPacket> handler) { 
    delegate.handler(new Handler<io.vertx.core.datagram.DatagramPacket>() {
      public void handle(io.vertx.core.datagram.DatagramPacket event) {
        handler.handle(io.vertx.reactivex.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.core.datagram.DatagramSocket exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  private io.vertx.reactivex.core.net.SocketAddress cached_0;
  public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
    return arg != null ? new DatagramSocket(arg) : null;
  }

}
