/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An HTTP and WebSockets server.
 * <p>
 * You receive HTTP requests by providing a {@link io.vertx.reactivex.core.http.HttpServer#requestHandler}. As requests arrive on the server the handler
 * will be called with the requests.
 * <p>
 * You receive WebSockets by providing a {@link io.vertx.reactivex.core.http.HttpServer#webSocketHandler}. As WebSocket connections arrive on the server, the
 * WebSocket is passed to the handler.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.http.HttpServer.class)
public class HttpServer implements io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServer that = (HttpServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<HttpServer> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new HttpServer((io.vertx.core.http.HttpServer) obj),
    HttpServer::getDelegate
  );

  private final io.vertx.core.http.HttpServer delegate;
  
  public HttpServer(io.vertx.core.http.HttpServer delegate) {
    this.delegate = delegate;
  }

  public HttpServer(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServer)delegate;
  }

  public io.vertx.core.http.HttpServer getDelegate() {
    return delegate;
  }

  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.http.HttpServerRequest> TYPE_ARG_0 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.http.HttpServerRequest>(o1 -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.http.ServerWebSocket> TYPE_ARG_1 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.http.ServerWebSocket>(o1 -> io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.http.ServerWebSocket> TYPE_ARG_2 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.core.http.ServerWebSocket>(o1 -> io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the request stream for the server. As HTTP requests are received by the server,
   * instances of {@link io.vertx.reactivex.core.http.HttpServerRequest} will be created and passed to the stream .
   * @return the request stream
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.HttpServerRequest> requestStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.HttpServerRequest> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.requestStream(), TYPE_ARG_0);
    cached_0 = ret;
    return ret;
  }

  /**
   * Set the request handler for the server to <code>requestHandler</code>. As HTTP requests are received by the server,
   * instances of {@link io.vertx.reactivex.core.http.HttpServerRequest} will be created and passed to this handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer requestHandler(Handler<io.vertx.reactivex.core.http.HttpServerRequest> handler) { 
    delegate.requestHandler(new Handler<io.vertx.core.http.HttpServerRequest>() {
      public void handle(io.vertx.core.http.HttpServerRequest event) {
        handler.handle(io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)event));
      }
    });
    return this;
  }

  /**
   * Set a connection handler for the server.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer connectionHandler(Handler<io.vertx.reactivex.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>() {
      public void handle(io.vertx.core.http.HttpConnection event) {
        handler.handle(io.vertx.reactivex.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)event));
      }
    });
    return this;
  }

  /**
   * Set an exception handler called for socket errors happening before the HTTP connection
   * is established, e.g during the TLS handshake.
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Return the WebSocket stream for the server. If a webSocket connect handshake is successful a
   * new {@link io.vertx.reactivex.core.http.ServerWebSocket} instance will be created and passed to the stream .
   * @return the WebSocket stream
   */
  @Deprecated()
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> websocketStream() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.websocketStream(), TYPE_ARG_1);
    cached_1 = ret;
    return ret;
  }

  /**
   * Return the WebSocket stream for the server. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.reactivex.core.http.ServerWebSocket} instance will be created and passed to the stream .
   * @return the WebSocket stream
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> webSocketStream() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.webSocketStream(), TYPE_ARG_2);
    cached_2 = ret;
    return ret;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.reactivex.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.reactivex.core.http.HttpServer websocketHandler(Handler<io.vertx.reactivex.core.http.ServerWebSocket> handler) { 
    delegate.websocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event));
      }
    });
    return this;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.reactivex.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer webSocketHandler(Handler<io.vertx.reactivex.core.http.ServerWebSocket> handler) { 
    delegate.webSocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event));
      }
    });
    return this;
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified in the
   * {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer listen() { 
    delegate.listen();
    return this;
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified here,
   * ignoring any value set in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer listen(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(int port, String host, Handler<AsyncResult<io.vertx.reactivex.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   */
  public Single<io.vertx.reactivex.core.http.HttpServer> rxListen(int port, String host) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(port, host, handler);
    });
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(io.vertx.reactivex.core.net.SocketAddress address, Handler<AsyncResult<io.vertx.reactivex.core.http.HttpServer>> listenHandler) { 
    delegate.listen(address.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   */
  public Single<io.vertx.reactivex.core.http.HttpServer> rxListen(io.vertx.reactivex.core.net.SocketAddress address) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(address, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but the server will listen on host "0.0.0.0" and port specified here ignoring
   * any value in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer listen(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(int port, Handler<AsyncResult<io.vertx.reactivex.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   */
  public Single<io.vertx.reactivex.core.http.HttpServer> rxListen(int port) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(port, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(Handler<AsyncResult<io.vertx.reactivex.core.http.HttpServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   */
  public Single<io.vertx.reactivex.core.http.HttpServer> rxListen() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(handler);
    });
  }

  /**
   * Close the server. Any open HTTP connections will be closed.
   * <p>
   * The close happens asynchronously and the server may not be closed until some time after the call has returned.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @param completionHandler the handler
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  private io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.HttpServerRequest> cached_0;
  private io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> cached_1;
  private io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> cached_2;
  public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
    return arg != null ? new HttpServer(arg) : null;
  }

}
