/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A TCP client.
 * <p>
 * Multiple connections to different servers can be made using the same instance.
 * <p>
 * This client supports a configurable number of connection attempts and a configurable
 * delay between attempts.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.net.NetClient.class)
public class NetClient implements io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetClient that = (NetClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<NetClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new NetClient((io.vertx.core.net.NetClient) obj),
    NetClient::getDelegate
  );

  private final io.vertx.core.net.NetClient delegate;
  
  public NetClient(io.vertx.core.net.NetClient delegate) {
    this.delegate = delegate;
  }

  public NetClient(Object delegate) {
    this.delegate = (io.vertx.core.net.NetClient)delegate;
  }

  public io.vertx.core.net.NetClient getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetClient connect(int port, String host, Handler<AsyncResult<io.vertx.reactivex.core.net.NetSocket>> connectHandler) { 
    delegate.connect(port, host, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(int port, String host) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(port, host, handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetClient connect(int port, String host, String serverName, Handler<AsyncResult<io.vertx.reactivex.core.net.NetSocket>> connectHandler) { 
    delegate.connect(port, host, serverName, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(int port, String host, String serverName) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(port, host, serverName, handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetClient connect(io.vertx.reactivex.core.net.SocketAddress remoteAddress, Handler<AsyncResult<io.vertx.reactivex.core.net.NetSocket>> connectHandler) { 
    delegate.connect(remoteAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(io.vertx.reactivex.core.net.SocketAddress remoteAddress) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(remoteAddress, handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetClient connect(io.vertx.reactivex.core.net.SocketAddress remoteAddress, String serverName, Handler<AsyncResult<io.vertx.reactivex.core.net.NetSocket>> connectHandler) { 
    delegate.connect(remoteAddress.getDelegate(), serverName, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(io.vertx.reactivex.core.net.SocketAddress remoteAddress, String serverName) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(remoteAddress, serverName, handler);
    });
  }

  /**
   * Close the client.
   * <p>
   * Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
   * complete until some time after the method has returned.
   */
  public void close() { 
    delegate.close();
  }

  public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
    return arg != null ? new NetClient(arg) : null;
  }

}
