/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.asyncsql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonArray;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents an asynchronous SQL client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.asyncsql.AsyncSQLClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.asyncsql.AsyncSQLClient.class)
public class AsyncSQLClient extends io.vertx.reactivex.ext.sql.SQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncSQLClient that = (AsyncSQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<AsyncSQLClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new AsyncSQLClient((io.vertx.ext.asyncsql.AsyncSQLClient) obj),
    AsyncSQLClient::getDelegate
  );

  private final io.vertx.ext.asyncsql.AsyncSQLClient delegate;
  
  public AsyncSQLClient(io.vertx.ext.asyncsql.AsyncSQLClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public AsyncSQLClient(Object delegate) {
    super((io.vertx.ext.asyncsql.AsyncSQLClient)delegate);
    this.delegate = (io.vertx.ext.asyncsql.AsyncSQLClient)delegate;
  }

  public io.vertx.ext.asyncsql.AsyncSQLClient getDelegate() {
    return delegate;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public Maybe<JsonArray> rxQuerySingle(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      querySingle(sql, handler);
    });
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public Maybe<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      querySingleWithParams(sql, arguments, handler);
    });
  }

  public static AsyncSQLClient newInstance(io.vertx.ext.asyncsql.AsyncSQLClient arg) {
    return arg != null ? new AsyncSQLClient(arg) : null;
  }

}
