/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Map;

/**
 * Hashing Strategy manager.
 *
 * This class will load system provided hashing strategies and algorithms.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.HashingStrategy original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.auth.HashingStrategy.class)
public class HashingStrategy {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HashingStrategy that = (HashingStrategy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<HashingStrategy> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new HashingStrategy((io.vertx.ext.auth.HashingStrategy) obj),
    HashingStrategy::getDelegate
  );

  private final io.vertx.ext.auth.HashingStrategy delegate;
  
  public HashingStrategy(io.vertx.ext.auth.HashingStrategy delegate) {
    this.delegate = delegate;
  }

  public HashingStrategy(Object delegate) {
    this.delegate = (io.vertx.ext.auth.HashingStrategy)delegate;
  }

  public io.vertx.ext.auth.HashingStrategy getDelegate() {
    return delegate;
  }

  /**
   * Factory method to load the algorithms from the system
   * @return a Hashing Strategy capable of hashing using the available algorithms
   */
  public static io.vertx.reactivex.ext.auth.HashingStrategy load() { 
    io.vertx.reactivex.ext.auth.HashingStrategy ret = io.vertx.reactivex.ext.auth.HashingStrategy.newInstance((io.vertx.ext.auth.HashingStrategy)io.vertx.ext.auth.HashingStrategy.load());
    return ret;
  }

  /**
   * Hashes a password.
   * @param id the algorithm id
   * @param params the algorithm specific paramters
   * @param salt the given salt
   * @param password the given password
   * @return the hashed string
   */
  public String hash(String id, Map<String, String> params, String salt, String password) { 
    String ret = delegate.hash(id, params, salt, password);
    return ret;
  }

  /**
   * Time constant password check. Regardless of the check, this algorithm executes the same number of
   * checks regardless of the correctly number of characters
   * @param hash the hash to verify
   * @param password the password to test against
   * @return boolean
   */
  public boolean verify(String hash, String password) { 
    boolean ret = delegate.verify(hash, password);
    return ret;
  }

  /**
   * Get an algorithm interface by its Id
   * @param id the algorithm id
   * @return the algorithm
   */
  public io.vertx.reactivex.ext.auth.HashingAlgorithm get(String id) { 
    io.vertx.reactivex.ext.auth.HashingAlgorithm ret = io.vertx.reactivex.ext.auth.HashingAlgorithm.newInstance((io.vertx.ext.auth.HashingAlgorithm)delegate.get(id));
    return ret;
  }

  /**
   * Put or replace an algorithm into the list of system loaded algorithms.
   * @param id the algorithm id
   * @param algorithm the implementation
   * @return self
   */
  public io.vertx.reactivex.ext.auth.HashingStrategy put(String id, io.vertx.reactivex.ext.auth.HashingAlgorithm algorithm) { 
    delegate.put(id, algorithm.getDelegate());
    return this;
  }

  public static HashingStrategy newInstance(io.vertx.ext.auth.HashingStrategy arg) {
    return arg != null ? new HashingStrategy(arg) : null;
  }

}
