/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.jwt;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.jwt.JWTOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.jwt.JWTAuthOptions;

/**
 * Factory interface for creating JWT based {@link io.vertx.reactivex.ext.auth.AuthProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jwt.JWTAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.auth.jwt.JWTAuth.class)
public class JWTAuth extends io.vertx.reactivex.ext.auth.AuthProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JWTAuth that = (JWTAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<JWTAuth> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new JWTAuth((io.vertx.ext.auth.jwt.JWTAuth) obj),
    JWTAuth::getDelegate
  );

  private final io.vertx.ext.auth.jwt.JWTAuth delegate;
  
  public JWTAuth(io.vertx.ext.auth.jwt.JWTAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JWTAuth(Object delegate) {
    super((io.vertx.ext.auth.jwt.JWTAuth)delegate);
    this.delegate = (io.vertx.ext.auth.jwt.JWTAuth)delegate;
  }

  public io.vertx.ext.auth.jwt.JWTAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a JWT auth provider
   * @param vertx the Vertx instance
   * @param config the config
   * @return the auth provider
   */
  public static io.vertx.reactivex.ext.auth.jwt.JWTAuth create(io.vertx.reactivex.core.Vertx vertx, JWTAuthOptions config) { 
    io.vertx.reactivex.ext.auth.jwt.JWTAuth ret = io.vertx.reactivex.ext.auth.jwt.JWTAuth.newInstance((io.vertx.ext.auth.jwt.JWTAuth)io.vertx.ext.auth.jwt.JWTAuth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Generate a new JWT token.
   * @param claims Json with user defined claims for a list of official claims
   * @param options extra options for the generation
   * @return JWT encoded token
   */
  public String generateToken(JsonObject claims, JWTOptions options) { 
    String ret = delegate.generateToken(claims, options);
    return ret;
  }

  /**
   * Generate a new JWT token.
   * @param claims Json with user defined claims for a list of official claims
   * @return JWT encoded token
   */
  public String generateToken(JsonObject claims) { 
    String ret = delegate.generateToken(claims);
    return ret;
  }

  public static JWTAuth newInstance(io.vertx.ext.auth.jwt.JWTAuth arg) {
    return arg != null ? new JWTAuth(arg) : null;
  }

}
