/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.bridge;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.core.json.JsonObject;

/**
 * Represents an event that occurs on the event bus bridge.
 * <p>
 * Please consult the documentation for a full explanation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.bridge.BaseBridgeEvent original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.bridge.BaseBridgeEvent.class)
public class BaseBridgeEvent extends io.vertx.reactivex.core.Promise<Boolean> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BaseBridgeEvent that = (BaseBridgeEvent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<BaseBridgeEvent> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new BaseBridgeEvent((io.vertx.ext.bridge.BaseBridgeEvent) obj),
    BaseBridgeEvent::getDelegate
  );

  private final io.vertx.ext.bridge.BaseBridgeEvent delegate;
  
  public BaseBridgeEvent(io.vertx.ext.bridge.BaseBridgeEvent delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public BaseBridgeEvent(Object delegate) {
    super((io.vertx.ext.bridge.BaseBridgeEvent)delegate);
    this.delegate = (io.vertx.ext.bridge.BaseBridgeEvent)delegate;
  }

  public io.vertx.ext.bridge.BaseBridgeEvent getDelegate() {
    return delegate;
  }


  /**
   * Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
   * <p/>
   * Any handler set on the associated promise will be called.
   * @param result the result
   */
  public void complete(Boolean result) { 
    delegate.complete(result);
  }

  /**
   * Like {@link io.vertx.reactivex.core.Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
   * an {@link java.lang.IllegalStateException}, it returns <code>true</code> otherwise.
   * @param result the result
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete(Boolean result) { 
    boolean ret = delegate.tryComplete(result);
    return ret;
  }

  /**
   * @return the  associated with this promise, it can be used to be aware of the promise completion
   */
  public io.vertx.reactivex.core.Future<Boolean> future() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.Future<Boolean> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.future(), io.vertx.lang.rx.TypeArg.unknown());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the type of the event
   */
  public BridgeEventType type() { 
    if (cached_1 != null) {
      return cached_1;
    }
    BridgeEventType ret = delegate.type();
    cached_1 = ret;
    return ret;
  }

  /**
   * Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
   * no message involved. If the returned message is modified, {@link io.vertx.reactivex.ext.bridge.BaseBridgeEvent#setRawMessage} should be called with the
   * new message.
   * @return the raw JSON message for the event
   */
  public JsonObject getRawMessage() { 
    JsonObject ret = delegate.getRawMessage();
    return ret;
  }

  /**
   * Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
   * no message involved.
   * @param message the raw message
   * @return this reference, so it can be used fluently
   */
  public io.vertx.reactivex.ext.bridge.BaseBridgeEvent setRawMessage(JsonObject message) { 
    delegate.setRawMessage(message);
    return this;
  }

  private io.vertx.reactivex.core.Future<Boolean> cached_0;
  private BridgeEventType cached_1;
  public static BaseBridgeEvent newInstance(io.vertx.ext.bridge.BaseBridgeEvent arg) {
    return arg != null ? new BaseBridgeEvent(arg) : null;
  }

}
