/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mail;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailService original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.mail.MailService.class)
public class MailService extends io.vertx.reactivex.ext.mail.MailClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailService that = (MailService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MailService> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MailService((io.vertx.ext.mail.MailService) obj),
    MailService::getDelegate
  );

  private final io.vertx.ext.mail.MailService delegate;
  
  public MailService(io.vertx.ext.mail.MailService delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MailService(Object delegate) {
    super((io.vertx.ext.mail.MailService)delegate);
    this.delegate = (io.vertx.ext.mail.MailService)delegate;
  }

  public io.vertx.ext.mail.MailService getDelegate() {
    return delegate;
  }

  /**
   * create a proxy of  MailService that delegates to the mail service running somewhere else via the event bus
   * @param vertx the Vertx instance the proxy will be run in
   * @param address the eb address of the mail service running somewhere, default is "vertx.mail"
   * @return MailService instance that can then be used to send multiple mails
   */
  public static io.vertx.reactivex.ext.mail.MailService createEventBusProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.vertx.reactivex.ext.mail.MailService ret = io.vertx.reactivex.ext.mail.MailService.newInstance((io.vertx.ext.mail.MailService)io.vertx.ext.mail.MailService.createEventBusProxy(vertx.getDelegate(), address));
    return ret;
  }

  public io.vertx.reactivex.ext.mail.MailService sendMail(MailMessage email, Handler<AsyncResult<MailResult>> resultHandler) { 
    delegate.sendMail(email, resultHandler);
    return this;
  }

  public Single<MailResult> rxSendMail(MailMessage email) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendMail(email, handler);
    });
  }

  public void close() { 
    delegate.close();
  }

  /**
   * The name of the default pool
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.mail.MailService.DEFAULT_POOL_NAME;
  public static MailService newInstance(io.vertx.ext.mail.MailService arg) {
    return arg != null ? new MailService(arg) : null;
  }

}
