/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.shell.ShellServiceOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * The shell service, provides a remotely accessible shell available via Telnet or SSH according to the
 * {@link io.vertx.ext.shell.ShellServiceOptions} configuration.<p/>
 *
 * The shell service will expose commands using {@link io.vertx.reactivex.ext.shell.command.CommandResolver} on the classpath and
 * the shared command registry for the Vert.x instance.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.ShellService original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.shell.ShellService.class)
public class ShellService {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShellService that = (ShellService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ShellService> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ShellService((io.vertx.ext.shell.ShellService) obj),
    ShellService::getDelegate
  );

  private final io.vertx.ext.shell.ShellService delegate;
  
  public ShellService(io.vertx.ext.shell.ShellService delegate) {
    this.delegate = delegate;
  }

  public ShellService(Object delegate) {
    this.delegate = (io.vertx.ext.shell.ShellService)delegate;
  }

  public io.vertx.ext.shell.ShellService getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.shell.ShellService#create}, with default options.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.ext.shell.ShellService create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.shell.ShellService ret = io.vertx.reactivex.ext.shell.ShellService.newInstance((io.vertx.ext.shell.ShellService)io.vertx.ext.shell.ShellService.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new shell service.
   * @param vertx the Vert.x instance
   * @param options the service config options
   * @return the shell service
   */
  public static io.vertx.reactivex.ext.shell.ShellService create(io.vertx.reactivex.core.Vertx vertx, ShellServiceOptions options) { 
    io.vertx.reactivex.ext.shell.ShellService ret = io.vertx.reactivex.ext.shell.ShellService.newInstance((io.vertx.ext.shell.ShellService)io.vertx.ext.shell.ShellService.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Start the shell service, this is an asynchronous start.
   */
  public void start() { 
    delegate.start();
  }

  /**
   * Start the shell service, this is an asynchronous start.
   * @param startHandler handler for getting notified when service is started
   */
  public void start(Handler<AsyncResult<Void>> startHandler) { 
    delegate.start(startHandler);
  }

  /**
   * Start the shell service, this is an asynchronous start.
   * @return 
   */
  public Completable rxStart() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      start(handler);
    });
  }

  /**
   * @return the shell server
   */
  public io.vertx.reactivex.ext.shell.ShellServer server() { 
    io.vertx.reactivex.ext.shell.ShellServer ret = io.vertx.reactivex.ext.shell.ShellServer.newInstance((io.vertx.ext.shell.ShellServer)delegate.server());
    return ret;
  }

  /**
   * Stop the shell service, this is an asynchronous stop.
   */
  public void stop() { 
    delegate.stop();
  }

  /**
   * Stop the shell service, this is an asynchronous start.
   * @param stopHandler handler for getting notified when service is stopped
   */
  public void stop(Handler<AsyncResult<Void>> stopHandler) { 
    delegate.stop(stopHandler);
  }

  /**
   * Stop the shell service, this is an asynchronous start.
   * @return 
   */
  public Completable rxStop() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      stop(handler);
    });
  }

  public static ShellService newInstance(io.vertx.ext.shell.ShellService arg) {
    return arg != null ? new ShellService(arg) : null;
  }

}
