/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.command;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;

/**
 * A Vert.x Shell command, it can be created from any language using the {@link io.vertx.reactivex.ext.shell.command.CommandBuilder#command} or from a
 * Java class using {@link io.vertx.reactivex.ext.shell.command.Command#create}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.Command original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.shell.command.Command.class)
public class Command {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Command that = (Command) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Command> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Command((io.vertx.ext.shell.command.Command) obj),
    Command::getDelegate
  );

  private final io.vertx.ext.shell.command.Command delegate;
  
  public Command(io.vertx.ext.shell.command.Command delegate) {
    this.delegate = delegate;
  }

  public Command(Object delegate) {
    this.delegate = (io.vertx.ext.shell.command.Command)delegate;
  }

  public io.vertx.ext.shell.command.Command getDelegate() {
    return delegate;
  }

  /**
   * @return the command name
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return the command line interface, can be null
   */
  public io.vertx.reactivex.core.cli.CLI cli() { 
    io.vertx.reactivex.core.cli.CLI ret = io.vertx.reactivex.core.cli.CLI.newInstance((io.vertx.core.cli.CLI)delegate.cli());
    return ret;
  }

  /**
   * Create a new process with empty arguments.
   * @return the process
   */
  public io.vertx.reactivex.ext.shell.system.Process createProcess() { 
    io.vertx.reactivex.ext.shell.system.Process ret = io.vertx.reactivex.ext.shell.system.Process.newInstance((io.vertx.ext.shell.system.Process)delegate.createProcess());
    return ret;
  }

  /**
   * Create a new process with the passed arguments.
   * @param args the process arguments
   * @return the process
   */
  public io.vertx.reactivex.ext.shell.system.Process createProcess(List<io.vertx.reactivex.ext.shell.cli.CliToken> args) { 
    io.vertx.reactivex.ext.shell.system.Process ret = io.vertx.reactivex.ext.shell.system.Process.newInstance((io.vertx.ext.shell.system.Process)delegate.createProcess(args.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Perform command completion, when the command is done completing it should call 
   * or  )} method to signal completion is done.
   * @param completion the completion object
   */
  public void complete(io.vertx.reactivex.ext.shell.cli.Completion completion) { 
    delegate.complete(completion.getDelegate());
  }

  public static Command newInstance(io.vertx.ext.shell.command.Command arg) {
    return arg != null ? new Command(arg) : null;
  }

}
