/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.command;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A registry that contains the commands known by a shell.<p/>
 *
 * It is a mutable command resolver.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandRegistry original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.shell.command.CommandRegistry.class)
public class CommandRegistry extends io.vertx.reactivex.ext.shell.command.CommandResolver {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandRegistry that = (CommandRegistry) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<CommandRegistry> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new CommandRegistry((io.vertx.ext.shell.command.CommandRegistry) obj),
    CommandRegistry::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandRegistry delegate;
  
  public CommandRegistry(io.vertx.ext.shell.command.CommandRegistry delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public CommandRegistry(Object delegate) {
    super((io.vertx.ext.shell.command.CommandRegistry)delegate);
    this.delegate = (io.vertx.ext.shell.command.CommandRegistry)delegate;
  }

  public io.vertx.ext.shell.command.CommandRegistry getDelegate() {
    return delegate;
  }

  /**
   * Get the shared registry for the Vert.x instance.
   * @param vertx the vertx instance
   * @return the shared registry
   */
  public static io.vertx.reactivex.ext.shell.command.CommandRegistry getShared(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.shell.command.CommandRegistry ret = io.vertx.reactivex.ext.shell.command.CommandRegistry.newInstance((io.vertx.ext.shell.command.CommandRegistry)io.vertx.ext.shell.command.CommandRegistry.getShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new registry.
   * @param vertx the vertx instance
   * @return the created registry
   */
  public static io.vertx.reactivex.ext.shell.command.CommandRegistry create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.shell.command.CommandRegistry ret = io.vertx.reactivex.ext.shell.command.CommandRegistry.newInstance((io.vertx.ext.shell.command.CommandRegistry)io.vertx.ext.shell.command.CommandRegistry.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.shell.command.CommandRegistry#registerCommand}, without a completion handler.
   * @param command 
   * @return 
   */
  public io.vertx.reactivex.ext.shell.command.CommandRegistry registerCommand(io.vertx.reactivex.ext.shell.command.Command command) { 
    delegate.registerCommand(command.getDelegate());
    return this;
  }

  /**
   * Register a command
   * @param command the command to register
   * @param completionHandler notified when the command is registered
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.shell.command.CommandRegistry registerCommand(io.vertx.reactivex.ext.shell.command.Command command, Handler<AsyncResult<io.vertx.reactivex.ext.shell.command.Command>> completionHandler) { 
    delegate.registerCommand(command.getDelegate(), new Handler<AsyncResult<io.vertx.ext.shell.command.Command>>() {
      public void handle(AsyncResult<io.vertx.ext.shell.command.Command> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Register a command
   * @param command the command to register
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.ext.shell.command.Command> rxRegisterCommand(io.vertx.reactivex.ext.shell.command.Command command) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      registerCommand(command, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.shell.command.CommandRegistry#registerCommands}, without a completion handler.
   * @param commands 
   * @return 
   */
  public io.vertx.reactivex.ext.shell.command.CommandRegistry registerCommands(List<io.vertx.reactivex.ext.shell.command.Command> commands) { 
    delegate.registerCommands(commands.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()));
    return this;
  }

  /**
   * Register a list of commands.
   * @param commands the commands to register
   * @param completionHandler notified when the command is registered
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.shell.command.CommandRegistry registerCommands(List<io.vertx.reactivex.ext.shell.command.Command> commands, Handler<AsyncResult<List<io.vertx.reactivex.ext.shell.command.Command>>> completionHandler) { 
    delegate.registerCommands(commands.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<java.util.List<io.vertx.ext.shell.command.Command>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.ext.shell.command.Command>> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Register a list of commands.
   * @param commands the commands to register
   * @return a reference to this, so the API can be used fluently
   */
  public Single<List<io.vertx.reactivex.ext.shell.command.Command>> rxRegisterCommands(List<io.vertx.reactivex.ext.shell.command.Command> commands) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      registerCommands(commands, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.shell.command.CommandRegistry#unregisterCommand}, without a completion handler.
   * @param commandName 
   * @return 
   */
  public io.vertx.reactivex.ext.shell.command.CommandRegistry unregisterCommand(String commandName) { 
    delegate.unregisterCommand(commandName);
    return this;
  }

  /**
   * Unregister a command.
   * @param commandName the command name
   * @param completionHandler notified when the command is unregistered
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.shell.command.CommandRegistry unregisterCommand(String commandName, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.unregisterCommand(commandName, completionHandler);
    return this;
  }

  /**
   * Unregister a command.
   * @param commandName the command name
   * @return a reference to this, so the API can be used fluently
   */
  public Completable rxUnregisterCommand(String commandName) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      unregisterCommand(commandName, handler);
    });
  }

  public static CommandRegistry newInstance(io.vertx.ext.shell.command.CommandRegistry arg) {
    return arg != null ? new CommandRegistry(arg) : null;
  }

}
