/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.stomp;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.stomp.Frame;
import java.util.Map;

/**
 * Utility methods to build common {@link io.vertx.ext.stomp.Frame}s. It defines a non-STOMP frame (<code>PING</code>) that is used for
 * heartbeats. When such frame is written on the wire it is just the <code>0</code> byte.
 * <p/>
 * This class is thread-safe.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.Frames original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.stomp.Frames.class)
public class Frames {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Frames that = (Frames) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Frames> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Frames((io.vertx.ext.stomp.Frames) obj),
    Frames::getDelegate
  );

  private final io.vertx.ext.stomp.Frames delegate;
  
  public Frames(io.vertx.ext.stomp.Frames delegate) {
    this.delegate = delegate;
  }

  public Frames(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.Frames)delegate;
  }

  public io.vertx.ext.stomp.Frames getDelegate() {
    return delegate;
  }

  public static Frame createErrorFrame(String message, Map<String, String> headers, String body) { 
    Frame ret = io.vertx.ext.stomp.Frames.createErrorFrame(message, headers, body);
    return ret;
  }

  public static Frame createReceiptFrame(String receiptId, Map<String, String> headers) { 
    Frame ret = io.vertx.ext.stomp.Frames.createReceiptFrame(receiptId, headers);
    return ret;
  }

  public static void handleReceipt(Frame frame, io.vertx.reactivex.ext.stomp.StompServerConnection connection) { 
    io.vertx.ext.stomp.Frames.handleReceipt(frame, connection.getDelegate());
  }

  public static Frame ping() { 
    Frame ret = io.vertx.ext.stomp.Frames.ping();
    return ret;
  }

  public static final Frame PING = io.vertx.ext.stomp.Frames.PING;
  public static Frames newInstance(io.vertx.ext.stomp.Frames arg) {
    return arg != null ? new Frames(arg) : null;
  }

}
