/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.unit.collect;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;
import io.vertx.ext.unit.report.ReportingOptions;

/**
 * The event bus collector listen to events on the Vert.x event bus and translate them
 * into reports.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.collect.EventBusCollector original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.unit.collect.EventBusCollector.class)
public class EventBusCollector {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBusCollector that = (EventBusCollector) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<EventBusCollector> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new EventBusCollector((io.vertx.ext.unit.collect.EventBusCollector) obj),
    EventBusCollector::getDelegate
  );

  private final io.vertx.ext.unit.collect.EventBusCollector delegate;
  
  public EventBusCollector(io.vertx.ext.unit.collect.EventBusCollector delegate) {
    this.delegate = delegate;
  }

  public EventBusCollector(Object delegate) {
    this.delegate = (io.vertx.ext.unit.collect.EventBusCollector)delegate;
  }

  public io.vertx.ext.unit.collect.EventBusCollector getDelegate() {
    return delegate;
  }

  /**
   * Create a message handler reporting with the specified options. The returned
   * message handler can be registered to an event bus.
   * @param vertx 
   * @param options the reporting options
   * @return the message handler
   */
  public static io.vertx.reactivex.ext.unit.collect.EventBusCollector create(io.vertx.reactivex.core.Vertx vertx, ReportingOptions options) { 
    io.vertx.reactivex.ext.unit.collect.EventBusCollector ret = io.vertx.reactivex.ext.unit.collect.EventBusCollector.newInstance((io.vertx.ext.unit.collect.EventBusCollector)io.vertx.ext.unit.collect.EventBusCollector.create(vertx.getDelegate(), options));
    return ret;
  }

  public static io.vertx.reactivex.ext.unit.collect.EventBusCollector create(io.vertx.reactivex.core.Vertx vertx, Handler<io.vertx.reactivex.ext.unit.report.TestSuiteReport> reporter) { 
    io.vertx.reactivex.ext.unit.collect.EventBusCollector ret = io.vertx.reactivex.ext.unit.collect.EventBusCollector.newInstance((io.vertx.ext.unit.collect.EventBusCollector)io.vertx.ext.unit.collect.EventBusCollector.create(vertx.getDelegate(), new Handler<io.vertx.ext.unit.report.TestSuiteReport>() {
      public void handle(io.vertx.ext.unit.report.TestSuiteReport event) {
        reporter.handle(io.vertx.reactivex.ext.unit.report.TestSuiteReport.newInstance((io.vertx.ext.unit.report.TestSuiteReport)event));
      }
    }));
    return ret;
  }

  /**
   * Register the collector as a consumer of the event bus with the specified address.
   * @param address the registration address
   * @return the subscribed message consumer
   */
  public io.vertx.reactivex.core.eventbus.MessageConsumer register(String address) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.register(address));
    return ret;
  }

  /**
   * Json <code>type</code> field value that signals a test suite begins, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_SUITE_BEGIN = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_SUITE_BEGIN;
  /**
   * Json <code>type</code> field value that signals a test suite ends, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_SUITE_END = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_SUITE_END;
  /**
   * Json <code>type</code> field value that reports a test suite error, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_SUITE_ERROR = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_SUITE_ERROR;
  /**
   * Json <code>type</code> field value that signals a test case begins, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_CASE_BEGIN = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_CASE_BEGIN;
  /**
   * Json <code>type</code> field value that signals a test case ends, used as part of the test reporting
   * protocol for the event bus.
   */
  public static final String EVENT_TEST_CASE_END = io.vertx.ext.unit.collect.EventBusCollector.EVENT_TEST_CASE_END;
  public static EventBusCollector newInstance(io.vertx.ext.unit.collect.EventBusCollector arg) {
    return arg != null ? new EventBusCollector(arg) : null;
  }

}
