/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.json.JsonObject;

/**
 * Container for request parameters
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.RequestParameters original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.api.RequestParameters.class)
public class RequestParameters {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestParameters that = (RequestParameters) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<RequestParameters> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new RequestParameters((io.vertx.ext.web.api.RequestParameters) obj),
    RequestParameters::getDelegate
  );

  private final io.vertx.ext.web.api.RequestParameters delegate;
  
  public RequestParameters(io.vertx.ext.web.api.RequestParameters delegate) {
    this.delegate = delegate;
  }

  public RequestParameters(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.RequestParameters)delegate;
  }

  public io.vertx.ext.web.api.RequestParameters getDelegate() {
    return delegate;
  }


  /**
   * Get list of all parameter names inside path
   * @return 
   */
  public List<String> pathParametersNames() { 
    List<String> ret = delegate.pathParametersNames();
    return ret;
  }

  /**
   * Get path parameter by name
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.RequestParameter pathParameter(String name) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.pathParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside query
   * @return 
   */
  public List<String> queryParametersNames() { 
    List<String> ret = delegate.queryParametersNames();
    return ret;
  }

  /**
   * Get query parameter by name
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.RequestParameter queryParameter(String name) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.queryParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside header
   * @return 
   */
  public List<String> headerParametersNames() { 
    List<String> ret = delegate.headerParametersNames();
    return ret;
  }

  /**
   * Get header parameter by name
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.RequestParameter headerParameter(String name) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.headerParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside cookie
   * @return 
   */
  public List<String> cookieParametersNames() { 
    List<String> ret = delegate.cookieParametersNames();
    return ret;
  }

  /**
   * Get cookie parameter by name
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.RequestParameter cookieParameter(String name) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.cookieParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside body form
   * @return 
   */
  public List<String> formParametersNames() { 
    List<String> ret = delegate.formParametersNames();
    return ret;
  }

  /**
   * Get form parameter by name
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.RequestParameter formParameter(String name) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.formParameter(name));
    return ret;
  }

  /**
   * Return request body
   * @return 
   */
  public io.vertx.reactivex.ext.web.api.RequestParameter body() { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.body());
    return ret;
  }

  /**
   * This method converts RequestParameters in an unique JsonObject with 6 fields: cookie, path, query, header, form, body<br/>
   *
   * cookie, path, query, header, form are JsonObject where keys are param names and values are param values, while body depends on body's shape and may not exist
   * @return 
   */
  public JsonObject toJson() { 
    if (cached_0 != null) {
      return cached_0;
    }
    JsonObject ret = delegate.toJson();
    cached_0 = ret;
    return ret;
  }

  private JsonObject cached_0;
  public static RequestParameters newInstance(io.vertx.ext.web.api.RequestParameters arg) {
    return arg != null ? new RequestParameters(arg) : null;
  }

}
