/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api.validation;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * This interface is used to add custom <b>synchronous</b> functions inside validation process. You can add it in
 * {@link io.vertx.reactivex.ext.web.api.validation.HTTPRequestValidationHandler}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.validation.CustomValidator original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.api.validation.CustomValidator.class)
public class CustomValidator {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomValidator that = (CustomValidator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<CustomValidator> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new CustomValidator((io.vertx.ext.web.api.validation.CustomValidator) obj),
    CustomValidator::getDelegate
  );

  private final io.vertx.ext.web.api.validation.CustomValidator delegate;
  
  public CustomValidator(io.vertx.ext.web.api.validation.CustomValidator delegate) {
    this.delegate = delegate;
  }

  public CustomValidator(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.validation.CustomValidator)delegate;
  }

  public io.vertx.ext.web.api.validation.CustomValidator getDelegate() {
    return delegate;
  }

  /**
   * This function have to be <b>synchronous</b>. It doesn't return nothing if validation succedes, otherwise it
   * throws ValidationException.
   * <br/>
   * <b>Don't call routingContext.next() or routingContext.fail() from this function</b>
   * @param routingContext the actual routing context
   */
  public void validate(io.vertx.reactivex.ext.web.RoutingContext routingContext) { 
    delegate.validate(routingContext.getDelegate());
  }

  public static CustomValidator newInstance(io.vertx.ext.web.api.validation.CustomValidator arg) {
    return arg != null ? new CustomValidator(arg) : null;
  }

}
