/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 * A handler which gathers the entire request body and sets it on the .
 * <p>
 * It also handles HTTP file uploads and can be used to limit body sizes.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.BodyHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.BodyHandler.class)
public class BodyHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BodyHandler that = (BodyHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<BodyHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new BodyHandler((io.vertx.ext.web.handler.BodyHandler) obj),
    BodyHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.BodyHandler delegate;
  
  public BodyHandler(io.vertx.ext.web.handler.BodyHandler delegate) {
    this.delegate = delegate;
  }

  public BodyHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.BodyHandler)delegate;
  }

  public io.vertx.ext.web.handler.BodyHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a body handler with defaults
   * @return the body handler
   */
  public static io.vertx.reactivex.ext.web.handler.BodyHandler create() { 
    io.vertx.reactivex.ext.web.handler.BodyHandler ret = io.vertx.reactivex.ext.web.handler.BodyHandler.newInstance((io.vertx.ext.web.handler.BodyHandler)io.vertx.ext.web.handler.BodyHandler.create());
    return ret;
  }

  /**
   * Create a body handler setting if it should handle file uploads
   * @param handleFileUploads true if files upload should be handled
   * @return the body handler
   */
  public static io.vertx.reactivex.ext.web.handler.BodyHandler create(boolean handleFileUploads) { 
    io.vertx.reactivex.ext.web.handler.BodyHandler ret = io.vertx.reactivex.ext.web.handler.BodyHandler.newInstance((io.vertx.ext.web.handler.BodyHandler)io.vertx.ext.web.handler.BodyHandler.create(handleFileUploads));
    return ret;
  }

  /**
   * Create a body handler and use the given upload directory.
   * @param uploadDirectory the uploads directory
   * @return the body handler
   */
  public static io.vertx.reactivex.ext.web.handler.BodyHandler create(String uploadDirectory) { 
    io.vertx.reactivex.ext.web.handler.BodyHandler ret = io.vertx.reactivex.ext.web.handler.BodyHandler.newInstance((io.vertx.ext.web.handler.BodyHandler)io.vertx.ext.web.handler.BodyHandler.create(uploadDirectory));
    return ret;
  }

  /**
   * Set whether file uploads will be handled
   * @param handleFileUploads true if they should be handled
   * @return reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.BodyHandler setHandleFileUploads(boolean handleFileUploads) { 
    delegate.setHandleFileUploads(handleFileUploads);
    return this;
  }

  /**
   * Set the maximum body size -1 means unlimited
   * @param bodyLimit the max size
   * @return reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.BodyHandler setBodyLimit(long bodyLimit) { 
    delegate.setBodyLimit(bodyLimit);
    return this;
  }

  /**
   * Set the uploads directory to use
   * @param uploadsDirectory the uploads directory
   * @return reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.BodyHandler setUploadsDirectory(String uploadsDirectory) { 
    delegate.setUploadsDirectory(uploadsDirectory);
    return this;
  }

  /**
   * Set whether form attributes will be added to the request parameters
   * @param mergeFormAttributes true if they should be merged
   * @return reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) { 
    delegate.setMergeFormAttributes(mergeFormAttributes);
    return this;
  }

  /**
   * Set whether uploaded files should be removed after handling the request
   * @param deleteUploadedFilesOnEnd true if uploaded files should be removed after handling the request
   * @return reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) { 
    delegate.setDeleteUploadedFilesOnEnd(deleteUploadedFilesOnEnd);
    return this;
  }

  /**
   * Pre-allocate the body buffer according to the value parsed from content-length header.
   * The buffer is capped at 64KB
   * @param isPreallocateBodyBuffer <code>true</code> if body buffer is pre-allocated according to the size read from content-length Header. {code false} if body buffer is pre-allocated to 1KB, and is resized dynamically
   * @return reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.BodyHandler setPreallocateBodyBuffer(boolean isPreallocateBodyBuffer) { 
    delegate.setPreallocateBodyBuffer(isPreallocateBodyBuffer);
    return this;
  }

  /**
   * Default max size for a request body. -1 means unlimited
   */
  public static final long DEFAULT_BODY_LIMIT = io.vertx.ext.web.handler.BodyHandler.DEFAULT_BODY_LIMIT;
  /**
   * Default uploads directory on server for file uploads
   */
  public static final String DEFAULT_UPLOADS_DIRECTORY = io.vertx.ext.web.handler.BodyHandler.DEFAULT_UPLOADS_DIRECTORY;
  /**
   * Default value of whether form attributes should be merged into request params
   */
  public static final boolean DEFAULT_MERGE_FORM_ATTRIBUTES = io.vertx.ext.web.handler.BodyHandler.DEFAULT_MERGE_FORM_ATTRIBUTES;
  /**
   * Default value of whether uploaded files should be removed after handling the request
   */
  public static final boolean DEFAULT_DELETE_UPLOADED_FILES_ON_END = io.vertx.ext.web.handler.BodyHandler.DEFAULT_DELETE_UPLOADED_FILES_ON_END;
  /**
   * Default value of whether to pre-allocate the body buffer size according to the content-length HTTP request header
   */
  public static final boolean DEFAULT_PREALLOCATE_BODY_BUFFER = io.vertx.ext.web.handler.BodyHandler.DEFAULT_PREALLOCATE_BODY_BUFFER;
  public static BodyHandler newInstance(io.vertx.ext.web.handler.BodyHandler arg) {
    return arg != null ? new BodyHandler(arg) : null;
  }

}
