/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import java.util.Set;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An auth handler that provides JWT Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.JWTAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.JWTAuthHandler.class)
public class JWTAuthHandler implements io.vertx.reactivex.ext.web.handler.AuthHandler, io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JWTAuthHandler that = (JWTAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<JWTAuthHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new JWTAuthHandler((io.vertx.ext.web.handler.JWTAuthHandler) obj),
    JWTAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.JWTAuthHandler delegate;
  
  public JWTAuthHandler(io.vertx.ext.web.handler.JWTAuthHandler delegate) {
    this.delegate = delegate;
  }

  public JWTAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.JWTAuthHandler)delegate;
  }

  public io.vertx.ext.web.handler.JWTAuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Add a required authority for this auth handler
   * @param authority the authority
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.AuthHandler addAuthority(String authority) { 
    delegate.addAuthority(authority);
    return this;
  }

  /**
   * Add a set of required authorities for this auth handler
   * @param authorities the set of authorities
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.AuthHandler addAuthorities(Set<String> authorities) { 
    delegate.addAuthorities(authorities);
    return this;
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @param handler the handler to be called once the information is available.
   */
  public void parseCredentials(io.vertx.reactivex.ext.web.RoutingContext context, Handler<AsyncResult<JsonObject>> handler) { 
    delegate.parseCredentials(context.getDelegate(), handler);
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @return 
   */
  public Single<JsonObject> rxParseCredentials(io.vertx.reactivex.ext.web.RoutingContext context) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      parseCredentials(context, handler);
    });
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @param handler the handler for the result.
   */
  public void authorize(io.vertx.reactivex.ext.auth.User user, Handler<AsyncResult<Void>> handler) { 
    delegate.authorize(user.getDelegate(), handler);
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @return 
   */
  public Completable rxAuthorize(io.vertx.reactivex.ext.auth.User user) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      authorize(user, handler);
    });
  }

  /**
   * Create a JWT auth handler
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.reactivex.ext.web.handler.JWTAuthHandler create(io.vertx.reactivex.ext.auth.jwt.JWTAuth authProvider) { 
    io.vertx.reactivex.ext.web.handler.JWTAuthHandler ret = io.vertx.reactivex.ext.web.handler.JWTAuthHandler.newInstance((io.vertx.ext.web.handler.JWTAuthHandler)io.vertx.ext.web.handler.JWTAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * Create a JWT auth handler
   * @param authProvider the auth provider to use.
   * @param skip 
   * @return the auth handler
   */
  public static io.vertx.reactivex.ext.web.handler.JWTAuthHandler create(io.vertx.reactivex.ext.auth.jwt.JWTAuth authProvider, String skip) { 
    io.vertx.reactivex.ext.web.handler.JWTAuthHandler ret = io.vertx.reactivex.ext.web.handler.JWTAuthHandler.newInstance((io.vertx.ext.web.handler.JWTAuthHandler)io.vertx.ext.web.handler.JWTAuthHandler.create(authProvider.getDelegate(), skip));
    return ret;
  }

  /**
   * Set the audience list
   * @param audience the audience list
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.JWTAuthHandler setAudience(List<String> audience) { 
    delegate.setAudience(audience);
    return this;
  }

  /**
   * Set the issuer
   * @param issuer the issuer
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.JWTAuthHandler setIssuer(String issuer) { 
    delegate.setIssuer(issuer);
    return this;
  }

  /**
   * Set whether expiration is ignored
   * @param ignoreExpiration whether expiration is ignored
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.handler.JWTAuthHandler setIgnoreExpiration(boolean ignoreExpiration) { 
    delegate.setIgnoreExpiration(ignoreExpiration);
    return this;
  }

  public static JWTAuthHandler newInstance(io.vertx.ext.web.handler.JWTAuthHandler arg) {
    return arg != null ? new JWTAuthHandler(arg) : null;
  }

}
