/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 *
 * A handler which renders responses using a template engine and where the template name is selected from the URI
 * path.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.TemplateHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.TemplateHandler.class)
public class TemplateHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TemplateHandler that = (TemplateHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<TemplateHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new TemplateHandler((io.vertx.ext.web.handler.TemplateHandler) obj),
    TemplateHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.TemplateHandler delegate;
  
  public TemplateHandler(io.vertx.ext.web.handler.TemplateHandler delegate) {
    this.delegate = delegate;
  }

  public TemplateHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.TemplateHandler)delegate;
  }

  public io.vertx.ext.web.handler.TemplateHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Set the index template
   * @param indexTemplate the index template
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.TemplateHandler setIndexTemplate(String indexTemplate) { 
    delegate.setIndexTemplate(indexTemplate);
    return this;
  }

  /**
   * Create a handler
   * @param engine the template engine
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.TemplateHandler create(io.vertx.reactivex.ext.web.common.template.TemplateEngine engine) { 
    io.vertx.reactivex.ext.web.handler.TemplateHandler ret = io.vertx.reactivex.ext.web.handler.TemplateHandler.newInstance((io.vertx.ext.web.handler.TemplateHandler)io.vertx.ext.web.handler.TemplateHandler.create(engine.getDelegate()));
    return ret;
  }

  /**
   * Create a handler
   * @param engine the template engine
   * @param templateDirectory the template directory where templates will be looked for
   * @param contentType the content type header to be used in the response
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.TemplateHandler create(io.vertx.reactivex.ext.web.common.template.TemplateEngine engine, String templateDirectory, String contentType) { 
    io.vertx.reactivex.ext.web.handler.TemplateHandler ret = io.vertx.reactivex.ext.web.handler.TemplateHandler.newInstance((io.vertx.ext.web.handler.TemplateHandler)io.vertx.ext.web.handler.TemplateHandler.create(engine.getDelegate(), templateDirectory, contentType));
    return ret;
  }

  /**
   * The default directory where templates will be looked for
   */
  public static final String DEFAULT_TEMPLATE_DIRECTORY = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_TEMPLATE_DIRECTORY;
  /**
   * The default content type header to be used in the response
   */
  public static final String DEFAULT_CONTENT_TYPE = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_CONTENT_TYPE;
  /**
   * The default index page
   */
  public static final String DEFAULT_INDEX_TEMPLATE = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_INDEX_TEMPLATE;
  public static TemplateHandler newInstance(io.vertx.ext.web.handler.TemplateHandler arg) {
    return arg != null ? new TemplateHandler(arg) : null;
  }

}
