/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 * Handler that will filter requests based on the request Host name.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.VirtualHostHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.VirtualHostHandler.class)
public class VirtualHostHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VirtualHostHandler that = (VirtualHostHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<VirtualHostHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new VirtualHostHandler((io.vertx.ext.web.handler.VirtualHostHandler) obj),
    VirtualHostHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.VirtualHostHandler delegate;
  
  public VirtualHostHandler(io.vertx.ext.web.handler.VirtualHostHandler delegate) {
    this.delegate = delegate;
  }

  public VirtualHostHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.VirtualHostHandler)delegate;
  }

  public io.vertx.ext.web.handler.VirtualHostHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler
   * @param hostname 
   * @param handler 
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.VirtualHostHandler create(String hostname, Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    io.vertx.reactivex.ext.web.handler.VirtualHostHandler ret = io.vertx.reactivex.ext.web.handler.VirtualHostHandler.newInstance((io.vertx.ext.web.handler.VirtualHostHandler)io.vertx.ext.web.handler.VirtualHostHandler.create(hostname, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    }));
    return ret;
  }

  public static VirtualHostHandler newInstance(io.vertx.ext.web.handler.VirtualHostHandler arg) {
    return arg != null ? new VirtualHostHandler(arg) : null;
  }

}
