/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.multipart;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * A multipart form.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.multipart.MultipartForm original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.multipart.MultipartForm.class)
public class MultipartForm implements java.lang.Iterable<io.vertx.reactivex.ext.web.multipart.FormDataPart> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultipartForm that = (MultipartForm) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Override
  public java.util.Iterator<io.vertx.reactivex.ext.web.multipart.FormDataPart> iterator() {
    java.util.function.Function<io.vertx.ext.web.multipart.FormDataPart, io.vertx.reactivex.ext.web.multipart.FormDataPart> conv = io.vertx.reactivex.ext.web.multipart.FormDataPart::newInstance;
    return new io.vertx.lang.rx.MappingIterator<>(delegate.iterator(), conv);
  }

  public static final io.vertx.lang.rx.TypeArg<MultipartForm> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MultipartForm((io.vertx.ext.web.multipart.MultipartForm) obj),
    MultipartForm::getDelegate
  );

  private final io.vertx.ext.web.multipart.MultipartForm delegate;
  
  public MultipartForm(io.vertx.ext.web.multipart.MultipartForm delegate) {
    this.delegate = delegate;
  }

  public MultipartForm(Object delegate) {
    this.delegate = (io.vertx.ext.web.multipart.MultipartForm)delegate;
  }

  public io.vertx.ext.web.multipart.MultipartForm getDelegate() {
    return delegate;
  }

  /**
   * @return a multipart form instance
   */
  public static io.vertx.reactivex.ext.web.multipart.MultipartForm create() { 
    io.vertx.reactivex.ext.web.multipart.MultipartForm ret = io.vertx.reactivex.ext.web.multipart.MultipartForm.newInstance((io.vertx.ext.web.multipart.MultipartForm)io.vertx.ext.web.multipart.MultipartForm.create());
    return ret;
  }

  /**
   * Add an attribute form data part.
   * @param name the name of the attribute
   * @param value the value of the attribute
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.multipart.MultipartForm attribute(String name, String value) { 
    delegate.attribute(name, value);
    return this;
  }

  /**
   * Add a text file upload form data part.
   * @param name name of the parameter
   * @param filename filename of the file
   * @param pathname the pathname of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.multipart.MultipartForm textFileUpload(String name, String filename, String pathname, String mediaType) { 
    delegate.textFileUpload(name, filename, pathname, mediaType);
    return this;
  }

  /**
   * Add a binary file upload form data part.
   * @param name name of the parameter
   * @param filename filename of the file
   * @param pathname the pathname of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.multipart.MultipartForm binaryFileUpload(String name, String filename, String pathname, String mediaType) { 
    delegate.binaryFileUpload(name, filename, pathname, mediaType);
    return this;
  }

  public static MultipartForm newInstance(io.vertx.ext.web.multipart.MultipartForm arg) {
    return arg != null ? new MultipartForm(arg) : null;
  }

}
