/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.kafka.client.consumer;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * Vert.x Kafka consumer records
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.consumer.KafkaConsumerRecords original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.kafka.client.consumer.KafkaConsumerRecords.class)
public class KafkaConsumerRecords<K,V> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaConsumerRecords that = (KafkaConsumerRecords) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<KafkaConsumerRecords> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new KafkaConsumerRecords((io.vertx.kafka.client.consumer.KafkaConsumerRecords) obj),
    KafkaConsumerRecords::getDelegate
  );

  private final io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V> delegate;
  public final io.vertx.lang.rx.TypeArg<K> __typeArg_0;
  public final io.vertx.lang.rx.TypeArg<V> __typeArg_1;
  
  public KafkaConsumerRecords(io.vertx.kafka.client.consumer.KafkaConsumerRecords delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rx.TypeArg.unknown();    this.__typeArg_1 = io.vertx.lang.rx.TypeArg.unknown();  }

  public KafkaConsumerRecords(Object delegate, io.vertx.lang.rx.TypeArg<K> typeArg_0, io.vertx.lang.rx.TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.consumer.KafkaConsumerRecords)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.consumer.KafkaConsumerRecords getDelegate() {
    return delegate;
  }


  /**
   * @return the total number of records in this batch
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  /**
   * @return whether this batch contains any records
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * Get the record at the given index
   * @param index the index of the record to get
   * @return 
   */
  public io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K, V> recordAt(int index) { 
    io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord<K, V> ret = io.vertx.reactivex.kafka.client.consumer.KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)delegate.recordAt(index), __typeArg_0, __typeArg_1);
    return ret;
  }

  public static <K,V> KafkaConsumerRecords<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumerRecords arg) {
    return arg != null ? new KafkaConsumerRecords<K,V>(arg) : null;
  }

  public static <K,V> KafkaConsumerRecords<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumerRecords arg, io.vertx.lang.rx.TypeArg<K> __typeArg_K, io.vertx.lang.rx.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaConsumerRecords<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
