/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An MQTT server
 * <p>
 *    You can accept incoming MQTT connection requests providing a {@link io.vertx.reactivex.mqtt.MqttServer#endpointHandler}. As the
 *    requests arrive, the handler will be called with an instance of {@link io.vertx.reactivex.mqtt.MqttEndpoint} in order to manage the
 *    communication with the remote MQTT client.
 * </p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttServer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mqtt.MqttServer.class)
public class MqttServer {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttServer that = (MqttServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MqttServer> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MqttServer((io.vertx.mqtt.MqttServer) obj),
    MqttServer::getDelegate
  );

  private final io.vertx.mqtt.MqttServer delegate;
  
  public MqttServer(io.vertx.mqtt.MqttServer delegate) {
    this.delegate = delegate;
  }

  public MqttServer(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttServer)delegate;
  }

  public io.vertx.mqtt.MqttServer getDelegate() {
    return delegate;
  }

  /**
   * Return an MQTT server instance
   * @param vertx Vert.x instance
   * @param options MQTT server options
   * @return MQTT server instance
   */
  public static io.vertx.reactivex.mqtt.MqttServer create(io.vertx.reactivex.core.Vertx vertx, MqttServerOptions options) { 
    io.vertx.reactivex.mqtt.MqttServer ret = io.vertx.reactivex.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)io.vertx.mqtt.MqttServer.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Return an MQTT server instance using default options
   * @param vertx Vert.x instance
   * @return MQTT server instance
   */
  public static io.vertx.reactivex.mqtt.MqttServer create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.mqtt.MqttServer ret = io.vertx.reactivex.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)io.vertx.mqtt.MqttServer.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Start the server listening for incoming connections using the specified options
   * through the constructor
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttServer listen() { 
    delegate.listen();
    return this;
  }

  /**
   * Start the server listening for incoming connections on the port and host specified
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttServer listen(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Start the server listening for incoming connections on the port and host specified
   * It ignores any options specified through the constructor
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler handler called when the asynchronous listen call ends
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttServer listen(int port, String host, Handler<AsyncResult<io.vertx.reactivex.mqtt.MqttServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>() {
      public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Start the server listening for incoming connections on the port and host specified
   * It ignores any options specified through the constructor
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.mqtt.MqttServer> rxListen(int port, String host) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(port, host, handler);
    });
  }

  /**
   * Start the server listening for incoming connections on the port specified but on
   * "0.0.0.0" as host. It ignores any options specified through the constructor
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttServer listen(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Start the server listening for incoming connections on the port specified but on
   * "0.0.0.0" as host. It ignores any options specified through the constructor
   * @param port the port to listen on
   * @param listenHandler handler called when the asynchronous listen call ends
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttServer listen(int port, Handler<AsyncResult<io.vertx.reactivex.mqtt.MqttServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>() {
      public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Start the server listening for incoming connections on the port specified but on
   * "0.0.0.0" as host. It ignores any options specified through the constructor
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.mqtt.MqttServer> rxListen(int port) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(port, handler);
    });
  }

  /**
   * Start the server listening for incoming connections using the specified options
   * through the constructor
   * @param listenHandler handler called when the asynchronous listen call ends
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttServer listen(Handler<AsyncResult<io.vertx.reactivex.mqtt.MqttServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.mqtt.MqttServer>>() {
      public void handle(AsyncResult<io.vertx.mqtt.MqttServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Start the server listening for incoming connections using the specified options
   * through the constructor
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.mqtt.MqttServer> rxListen() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(handler);
    });
  }

  /**
   * Set the endpoint handler for the server. If an MQTT client connect to the server a
   * new MqttEndpoint instance will be created and passed to the handler
   * @param handler the endpoint handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttServer endpointHandler(Handler<io.vertx.reactivex.mqtt.MqttEndpoint> handler) { 
    delegate.endpointHandler(new Handler<io.vertx.mqtt.MqttEndpoint>() {
      public void handle(io.vertx.mqtt.MqttEndpoint event) {
        handler.handle(io.vertx.reactivex.mqtt.MqttEndpoint.newInstance((io.vertx.mqtt.MqttEndpoint)event));
      }
    });
    return this;
  }

  /**
   * Set an exception handler for the server, that will be called when an error happens independantly of an
   * accepted {@link io.vertx.reactivex.mqtt.MqttEndpoint}, like a rejected connection
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttServer exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Close the server.
   * <p>
   * The close happens asynchronously and the server may not be closed until some time after the call has returned.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close the server supplying an handler that will be called when the server is actually closed (or has failed).
   * @param completionHandler the handler called on completion
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the server supplying an handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  public static MqttServer newInstance(io.vertx.mqtt.MqttServer arg) {
    return arg != null ? new MqttServer(arg) : null;
  }

}
