/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.netty.handler.codec.mqtt.MqttQoS;

/**
 * Represents a subscription to a topic
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttTopicSubscription original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mqtt.MqttTopicSubscription.class)
public class MqttTopicSubscription {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttTopicSubscription that = (MqttTopicSubscription) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MqttTopicSubscription> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MqttTopicSubscription((io.vertx.mqtt.MqttTopicSubscription) obj),
    MqttTopicSubscription::getDelegate
  );

  private final io.vertx.mqtt.MqttTopicSubscription delegate;
  
  public MqttTopicSubscription(io.vertx.mqtt.MqttTopicSubscription delegate) {
    this.delegate = delegate;
  }

  public MqttTopicSubscription(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttTopicSubscription)delegate;
  }

  public io.vertx.mqtt.MqttTopicSubscription getDelegate() {
    return delegate;
  }

  /**
   * @return Subscription topic name
   */
  public String topicName() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.topicName();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return Quality of Service level for the subscription
   */
  public MqttQoS qualityOfService() { 
    if (cached_1 != null) {
      return cached_1;
    }
    MqttQoS ret = delegate.qualityOfService();
    cached_1 = ret;
    return ret;
  }

  private String cached_0;
  private MqttQoS cached_1;
  public static MqttTopicSubscription newInstance(io.vertx.mqtt.MqttTopicSubscription arg) {
    return arg != null ? new MqttTopicSubscription(arg) : null;
  }

}
