/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt.messages;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;

/**
 * Represents an MQTT SUBACK message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttSubAckMessage original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mqtt.messages.MqttSubAckMessage.class)
public class MqttSubAckMessage implements io.vertx.reactivex.mqtt.messages.MqttMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttSubAckMessage that = (MqttSubAckMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MqttSubAckMessage> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MqttSubAckMessage((io.vertx.mqtt.messages.MqttSubAckMessage) obj),
    MqttSubAckMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttSubAckMessage delegate;
  
  public MqttSubAckMessage(io.vertx.mqtt.messages.MqttSubAckMessage delegate) {
    this.delegate = delegate;
  }

  public MqttSubAckMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttSubAckMessage)delegate;
  }

  public io.vertx.mqtt.messages.MqttSubAckMessage getDelegate() {
    return delegate;
  }


  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return list of granted QoS levels
   */
  public List<Integer> grantedQoSLevels() { 
    if (cached_1 != null) {
      return cached_1;
    }
    List<Integer> ret = delegate.grantedQoSLevels();
    cached_1 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private List<Integer> cached_1;
  public static MqttSubAckMessage newInstance(io.vertx.mqtt.messages.MqttSubAckMessage arg) {
    return arg != null ? new MqttSubAckMessage(arg) : null;
  }

}
