/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt.messages;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;

/**
 * Represents an MQTT UNSUBSCRIBE message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttUnsubscribeMessage original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mqtt.messages.MqttUnsubscribeMessage.class)
public class MqttUnsubscribeMessage implements io.vertx.reactivex.mqtt.messages.MqttMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttUnsubscribeMessage that = (MqttUnsubscribeMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MqttUnsubscribeMessage> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MqttUnsubscribeMessage((io.vertx.mqtt.messages.MqttUnsubscribeMessage) obj),
    MqttUnsubscribeMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttUnsubscribeMessage delegate;
  
  public MqttUnsubscribeMessage(io.vertx.mqtt.messages.MqttUnsubscribeMessage delegate) {
    this.delegate = delegate;
  }

  public MqttUnsubscribeMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttUnsubscribeMessage)delegate;
  }

  public io.vertx.mqtt.messages.MqttUnsubscribeMessage getDelegate() {
    return delegate;
  }


  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return List of topics to unsubscribe
   */
  public List<String> topics() { 
    if (cached_1 != null) {
      return cached_1;
    }
    List<String> ret = delegate.topics();
    cached_1 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private List<String> cached_1;
  public static MqttUnsubscribeMessage newInstance(io.vertx.mqtt.messages.MqttUnsubscribeMessage arg) {
    return arg != null ? new MqttUnsubscribeMessage(arg) : null;
  }

}
