/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mysqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.sqlclient.PoolOptions;

/**
 * A pool of MySQL connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLPool original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mysqlclient.MySQLPool.class)
public class MySQLPool extends io.vertx.reactivex.sqlclient.Pool {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLPool that = (MySQLPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MySQLPool> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MySQLPool((io.vertx.mysqlclient.MySQLPool) obj),
    MySQLPool::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLPool delegate;
  
  public MySQLPool(io.vertx.mysqlclient.MySQLPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MySQLPool(Object delegate) {
    super((io.vertx.mysqlclient.MySQLPool)delegate);
    this.delegate = (io.vertx.mysqlclient.MySQLPool)delegate;
  }

  public io.vertx.mysqlclient.MySQLPool getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with a default <code>poolOptions</code>.
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(String connectionUri) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(String connectionUri, PoolOptions poolOptions) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(connectionUri, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with a default <code>poolOptions</code>..
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(io.vertx.reactivex.core.Vertx vertx, String connectionUri) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(io.vertx.reactivex.core.Vertx vertx, String connectionUri, PoolOptions poolOptions) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  /**
   * Create a connection pool to the MySQL server configured with the given <code>connectOptions</code> and <code>poolOptions</code>.
   * @param connectOptions the options for the connection
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(MySQLConnectOptions connectOptions, PoolOptions poolOptions) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(connectOptions, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with a specific  instance.
   * @param vertx 
   * @param connectOptions 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(io.vertx.reactivex.core.Vertx vertx, MySQLConnectOptions connectOptions, PoolOptions poolOptions) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  public static MySQLPool newInstance(io.vertx.mysqlclient.MySQLPool arg) {
    return arg != null ? new MySQLPool(arg) : null;
  }

}
