/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.ClientReplyOptions;
import java.util.Map;
import io.vertx.redis.op.GeoUnit;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SortOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.BitFieldOptions;
import io.vertx.redis.op.ScriptDebugOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.BitFieldOverflowOptions;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.LimitOptions;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.core.Handler;

/**
 * This factory is deprecated use {@link io.vertx.reactivex.redis.client.Redis} instead,
 * or for a typed API {@link io.vertx.reactivex.redis.client.RedisAPI}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.RedisClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.redis.RedisClient.class)
public class RedisClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisClient that = (RedisClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<RedisClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new RedisClient((io.vertx.redis.RedisClient) obj),
    RedisClient::getDelegate
  );

  private final io.vertx.redis.RedisClient delegate;
  
  public RedisClient(io.vertx.redis.RedisClient delegate) {
    this.delegate = delegate;
  }

  public RedisClient(Object delegate) {
    this.delegate = (io.vertx.redis.RedisClient)delegate;
  }

  public io.vertx.redis.RedisClient getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.redis.RedisClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.redis.RedisClient ret = io.vertx.reactivex.redis.RedisClient.newInstance((io.vertx.redis.RedisClient)io.vertx.redis.RedisClient.create(vertx.getDelegate()));
    return ret;
  }

  public static io.vertx.reactivex.redis.RedisClient create(io.vertx.reactivex.core.Vertx vertx, JsonObject config) { 
    io.vertx.reactivex.redis.RedisClient ret = io.vertx.reactivex.redis.RedisClient.newInstance((io.vertx.redis.RedisClient)io.vertx.redis.RedisClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Close the client - when it is fully closed the handler will be called.
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the client - when it is fully closed the handler will be called.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Append a value to a key
   * @param key Key string
   * @param value Value to append
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient append(String key, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.append(key, value, handler);
    return this;
  }

  /**
   * Append a value to a key
   * @param key Key string
   * @param value Value to append
   * @return 
   */
  public Single<Long> rxAppend(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      append(key, value, handler);
    });
  }

  /**
   * Authenticate to the server
   * @param password Password for authentication
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient auth(String password, Handler<AsyncResult<String>> handler) { 
    delegate.auth(password, handler);
    return this;
  }

  /**
   * Authenticate to the server
   * @param password Password for authentication
   * @return 
   */
  public Single<String> rxAuth(String password) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      auth(password, handler);
    });
  }

  /**
   * Asynchronously rewrite the append-only file
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bgrewriteaof(Handler<AsyncResult<String>> handler) { 
    delegate.bgrewriteaof(handler);
    return this;
  }

  /**
   * Asynchronously rewrite the append-only file
   * @return 
   */
  public Single<String> rxBgrewriteaof() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bgrewriteaof(handler);
    });
  }

  /**
   * Asynchronously save the dataset to disk
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bgsave(Handler<AsyncResult<String>> handler) { 
    delegate.bgsave(handler);
    return this;
  }

  /**
   * Asynchronously save the dataset to disk
   * @return 
   */
  public Single<String> rxBgsave() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bgsave(handler);
    });
  }

  /**
   * Count set bits in a string
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bitcount(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.bitcount(key, handler);
    return this;
  }

  /**
   * Count set bits in a string
   * @param key Key string
   * @return 
   */
  public Single<Long> rxBitcount(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bitcount(key, handler);
    });
  }

  /**
   * Count set bits in a string
   * @param key Key string
   * @param start Start index
   * @param end End index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bitcountRange(String key, long start, long end, Handler<AsyncResult<Long>> handler) { 
    delegate.bitcountRange(key, start, end, handler);
    return this;
  }

  /**
   * Count set bits in a string
   * @param key Key string
   * @param start Start index
   * @param end End index
   * @return 
   */
  public Single<Long> rxBitcountRange(String key, long start, long end) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bitcountRange(key, start, end, handler);
    });
  }

  /**
   * Perform bitwise operations between strings
   * @param operation Bitwise operation to perform
   * @param destkey Destination key where result is stored
   * @param keys List of keys on which to perform the operation
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) { 
    delegate.bitop(operation, destkey, keys, handler);
    return this;
  }

  /**
   * Perform bitwise operations between strings
   * @param operation Bitwise operation to perform
   * @param destkey Destination key where result is stored
   * @param keys List of keys on which to perform the operation
   * @return 
   */
  public Single<Long> rxBitop(BitOperation operation, String destkey, List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bitop(operation, destkey, keys, handler);
    });
  }

  /**
   * Find first bit set or clear in a string
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bitpos(String key, int bit, Handler<AsyncResult<Long>> handler) { 
    delegate.bitpos(key, bit, handler);
    return this;
  }

  /**
   * Find first bit set or clear in a string
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @return 
   */
  public Single<Long> rxBitpos(String key, int bit) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bitpos(key, bit, handler);
    });
  }

  /**
   * Find first bit set or clear in a string
   *
   * See also bitposRange() method, which takes start, and stop offset.
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param start Start offset
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bitposFrom(String key, int bit, int start, Handler<AsyncResult<Long>> handler) { 
    delegate.bitposFrom(key, bit, start, handler);
    return this;
  }

  /**
   * Find first bit set or clear in a string
   *
   * See also bitposRange() method, which takes start, and stop offset.
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param start Start offset
   * @return 
   */
  public Single<Long> rxBitposFrom(String key, int bit, int start) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bitposFrom(key, bit, start, handler);
    });
  }

  /**
   * Find first bit set or clear in a string
   *
   * Note: when both start, and stop offsets are specified,
   * behaviour is slightly different than if only start is specified
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param start Start offset
   * @param stop End offset - inclusive
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<Long>> handler) { 
    delegate.bitposRange(key, bit, start, stop, handler);
    return this;
  }

  /**
   * Find first bit set or clear in a string
   *
   * Note: when both start, and stop offsets are specified,
   * behaviour is slightly different than if only start is specified
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param start Start offset
   * @param stop End offset - inclusive
   * @return 
   */
  public Single<Long> rxBitposRange(String key, int bit, int start, int stop) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bitposRange(key, bit, start, stop, handler);
    });
  }

  /**
   * Remove and get the first element in a list, or block until one is available
   * @param key Key string identifying a list to watch
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient blpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.blpop(key, seconds, handler);
    return this;
  }

  /**
   * Remove and get the first element in a list, or block until one is available
   * @param key Key string identifying a list to watch
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<JsonArray> rxBlpop(String key, int seconds) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      blpop(key, seconds, handler);
    });
  }

  /**
   * Remove and get the first element in any of the lists, or block until one is available
   * @param keys List of key strings identifying lists to watch
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient blpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.blpopMany(keys, seconds, handler);
    return this;
  }

  /**
   * Remove and get the first element in any of the lists, or block until one is available
   * @param keys List of key strings identifying lists to watch
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<JsonArray> rxBlpopMany(List<String> keys, int seconds) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      blpopMany(keys, seconds, handler);
    });
  }

  /**
   * Remove and get the last element in a list, or block until one is available
   * @param key Key string identifying a list to watch
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient brpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.brpop(key, seconds, handler);
    return this;
  }

  /**
   * Remove and get the last element in a list, or block until one is available
   * @param key Key string identifying a list to watch
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<JsonArray> rxBrpop(String key, int seconds) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      brpop(key, seconds, handler);
    });
  }

  /**
   * Remove and get the last element in any of the lists, or block until one is available
   * @param keys List of key strings identifying lists to watch
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient brpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.brpopMany(keys, seconds, handler);
    return this;
  }

  /**
   * Remove and get the last element in any of the lists, or block until one is available
   * @param keys List of key strings identifying lists to watch
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<JsonArray> rxBrpopMany(List<String> keys, int seconds) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      brpopMany(keys, seconds, handler);
    });
  }

  /**
   * Pop a value from a list, push it to another list and return it; or block until one is available
   * @param key Key string identifying the source list
   * @param destkey Key string identifying the destination list
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) { 
    delegate.brpoplpush(key, destkey, seconds, handler);
    return this;
  }

  /**
   * Pop a value from a list, push it to another list and return it; or block until one is available
   * @param key Key string identifying the source list
   * @param destkey Key string identifying the destination list
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<String> rxBrpoplpush(String key, String destkey, int seconds) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      brpoplpush(key, destkey, seconds, handler);
    });
  }

  /**
   * Kill the connection of a client
   * @param filter Filter options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clientKill(KillFilter filter, Handler<AsyncResult<Long>> handler) { 
    delegate.clientKill(filter, handler);
    return this;
  }

  /**
   * Kill the connection of a client
   * @param filter Filter options
   * @return 
   */
  public Single<Long> rxClientKill(KillFilter filter) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clientKill(filter, handler);
    });
  }

  /**
   * Get the list of client connections
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clientList(Handler<AsyncResult<String>> handler) { 
    delegate.clientList(handler);
    return this;
  }

  /**
   * Get the list of client connections
   * @return 
   */
  public Single<String> rxClientList() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clientList(handler);
    });
  }

  /**
   * Get the current connection name
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clientGetname(Handler<AsyncResult<String>> handler) { 
    delegate.clientGetname(handler);
    return this;
  }

  /**
   * Get the current connection name
   * @return 
   */
  public Single<String> rxClientGetname() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clientGetname(handler);
    });
  }

  /**
   * Stop processing commands from clients for some time
   * @param millis Pause time in milliseconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clientPause(long millis, Handler<AsyncResult<String>> handler) { 
    delegate.clientPause(millis, handler);
    return this;
  }

  /**
   * Stop processing commands from clients for some time
   * @param millis Pause time in milliseconds
   * @return 
   */
  public Single<String> rxClientPause(long millis) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clientPause(millis, handler);
    });
  }

  /**
   * Set the current connection name
   * @param name New name for current connection
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clientSetname(String name, Handler<AsyncResult<String>> handler) { 
    delegate.clientSetname(name, handler);
    return this;
  }

  /**
   * Set the current connection name
   * @param name New name for current connection
   * @return 
   */
  public Single<String> rxClientSetname(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clientSetname(name, handler);
    });
  }

  /**
   * Assign new hash slots to receiving node.
   * @param slots 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterAddslots(List<Long> slots, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterAddslots(slots, handler);
    return this;
  }

  /**
   * Assign new hash slots to receiving node.
   * @param slots 
   * @return 
   */
  public Completable rxClusterAddslots(List<Long> slots) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterAddslots(slots, handler);
    });
  }

  /**
   * Return the number of failure reports active for a given node.
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterCountFailureReports(String nodeId, Handler<AsyncResult<Long>> handler) { 
    delegate.clusterCountFailureReports(nodeId, handler);
    return this;
  }

  /**
   * Return the number of failure reports active for a given node.
   * @param nodeId 
   * @return 
   */
  public Single<Long> rxClusterCountFailureReports(String nodeId) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clusterCountFailureReports(nodeId, handler);
    });
  }

  /**
   * Return the number of local keys in the specified hash slot.
   * @param slot 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterCountkeysinslot(long slot, Handler<AsyncResult<Long>> handler) { 
    delegate.clusterCountkeysinslot(slot, handler);
    return this;
  }

  /**
   * Return the number of local keys in the specified hash slot.
   * @param slot 
   * @return 
   */
  public Single<Long> rxClusterCountkeysinslot(long slot) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clusterCountkeysinslot(slot, handler);
    });
  }

  /**
   * Set hash slots as unbound in receiving node.
   * @param slot 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterDelslots(long slot, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterDelslots(slot, handler);
    return this;
  }

  /**
   * Set hash slots as unbound in receiving node.
   * @param slot 
   * @return 
   */
  public Completable rxClusterDelslots(long slot) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterDelslots(slot, handler);
    });
  }

  /**
   * Set hash slots as unbound in receiving node.
   * @param slots 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterDelslotsMany(List<Long> slots, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterDelslotsMany(slots, handler);
    return this;
  }

  /**
   * Set hash slots as unbound in receiving node.
   * @param slots 
   * @return 
   */
  public Completable rxClusterDelslotsMany(List<Long> slots) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterDelslotsMany(slots, handler);
    });
  }

  /**
   * Forces a slave to perform a manual failover of its master.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterFailover(Handler<AsyncResult<Void>> handler) { 
    delegate.clusterFailover(handler);
    return this;
  }

  /**
   * Forces a slave to perform a manual failover of its master.
   * @return 
   */
  public Completable rxClusterFailover() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterFailover(handler);
    });
  }

  /**
   * Forces a slave to perform a manual failover of its master.
   * @param options 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterFailOverWithOptions(options, handler);
    return this;
  }

  /**
   * Forces a slave to perform a manual failover of its master.
   * @param options 
   * @return 
   */
  public Completable rxClusterFailOverWithOptions(FailoverOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterFailOverWithOptions(options, handler);
    });
  }

  /**
   * Remove a node from the nodes table.
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterForget(String nodeId, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterForget(nodeId, handler);
    return this;
  }

  /**
   * Remove a node from the nodes table.
   * @param nodeId 
   * @return 
   */
  public Completable rxClusterForget(String nodeId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterForget(nodeId, handler);
    });
  }

  /**
   * Return local key names in the specified hash slot.
   * @param slot 
   * @param count 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.clusterGetkeysinslot(slot, count, handler);
    return this;
  }

  /**
   * Return local key names in the specified hash slot.
   * @param slot 
   * @param count 
   * @return 
   */
  public Single<JsonArray> rxClusterGetkeysinslot(long slot, long count) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clusterGetkeysinslot(slot, count, handler);
    });
  }

  /**
   * Provides info about Redis Cluster node state.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterInfo(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.clusterInfo(handler);
    return this;
  }

  /**
   * Provides info about Redis Cluster node state.
   * @return 
   */
  public Single<JsonArray> rxClusterInfo() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clusterInfo(handler);
    });
  }

  /**
   * Returns the hash slot of the specified key.
   * @param key 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterKeyslot(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.clusterKeyslot(key, handler);
    return this;
  }

  /**
   * Returns the hash slot of the specified key.
   * @param key 
   * @return 
   */
  public Single<Long> rxClusterKeyslot(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clusterKeyslot(key, handler);
    });
  }

  /**
   * Force a node cluster to handshake with another node.
   * @param ip 
   * @param port 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterMeet(String ip, long port, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterMeet(ip, port, handler);
    return this;
  }

  /**
   * Force a node cluster to handshake with another node.
   * @param ip 
   * @param port 
   * @return 
   */
  public Completable rxClusterMeet(String ip, long port) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterMeet(ip, port, handler);
    });
  }

  /**
   * Get Cluster config for the node.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterNodes(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.clusterNodes(handler);
    return this;
  }

  /**
   * Get Cluster config for the node.
   * @return 
   */
  public Single<JsonArray> rxClusterNodes() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clusterNodes(handler);
    });
  }

  /**
   * Reconfigure a node as a slave of the specified master node.
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterReplicate(String nodeId, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterReplicate(nodeId, handler);
    return this;
  }

  /**
   * Reconfigure a node as a slave of the specified master node.
   * @param nodeId 
   * @return 
   */
  public Completable rxClusterReplicate(String nodeId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterReplicate(nodeId, handler);
    });
  }

  /**
   * Reset a Redis Cluster node.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterReset(Handler<AsyncResult<Void>> handler) { 
    delegate.clusterReset(handler);
    return this;
  }

  /**
   * Reset a Redis Cluster node.
   * @return 
   */
  public Completable rxClusterReset() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterReset(handler);
    });
  }

  /**
   * Reset a Redis Cluster node.
   * @param options 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterResetWithOptions(options, handler);
    return this;
  }

  /**
   * Reset a Redis Cluster node.
   * @param options 
   * @return 
   */
  public Completable rxClusterResetWithOptions(ResetOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterResetWithOptions(options, handler);
    });
  }

  /**
   * Forces the node to save cluster state on disk.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterSaveconfig(Handler<AsyncResult<Void>> handler) { 
    delegate.clusterSaveconfig(handler);
    return this;
  }

  /**
   * Forces the node to save cluster state on disk.
   * @return 
   */
  public Completable rxClusterSaveconfig() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterSaveconfig(handler);
    });
  }

  /**
   * Set the configuration epoch in a new node.
   * @param epoch 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterSetConfigEpoch(long epoch, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterSetConfigEpoch(epoch, handler);
    return this;
  }

  /**
   * Set the configuration epoch in a new node.
   * @param epoch 
   * @return 
   */
  public Completable rxClusterSetConfigEpoch(long epoch) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterSetConfigEpoch(epoch, handler);
    });
  }

  /**
   * Bind an hash slot to a specific node.
   * @param slot 
   * @param subcommand 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterSetslot(slot, subcommand, handler);
    return this;
  }

  /**
   * Bind an hash slot to a specific node.
   * @param slot 
   * @param subcommand 
   * @return 
   */
  public Completable rxClusterSetslot(long slot, SlotCmd subcommand) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterSetslot(slot, subcommand, handler);
    });
  }

  /**
   * Bind an hash slot to a specific node.
   * @param slot 
   * @param subcommand 
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<Void>> handler) { 
    delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
    return this;
  }

  /**
   * Bind an hash slot to a specific node.
   * @param slot 
   * @param subcommand 
   * @param nodeId 
   * @return 
   */
  public Completable rxClusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      clusterSetslotWithNode(slot, subcommand, nodeId, handler);
    });
  }

  /**
   * List slave nodes of the specified master node.
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterSlaves(String nodeId, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.clusterSlaves(nodeId, handler);
    return this;
  }

  /**
   * List slave nodes of the specified master node.
   * @param nodeId 
   * @return 
   */
  public Single<JsonArray> rxClusterSlaves(String nodeId) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clusterSlaves(nodeId, handler);
    });
  }

  /**
   * Get array of Cluster slot to node mappings
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clusterSlots(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.clusterSlots(handler);
    return this;
  }

  /**
   * Get array of Cluster slot to node mappings
   * @return 
   */
  public Single<JsonArray> rxClusterSlots() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clusterSlots(handler);
    });
  }

  /**
   * Get array of Redis command details
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient command(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.command(handler);
    return this;
  }

  /**
   * Get array of Redis command details
   * @return 
   */
  public Single<JsonArray> rxCommand() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      command(handler);
    });
  }

  /**
   * Get total number of Redis commands
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient commandCount(Handler<AsyncResult<Long>> handler) { 
    delegate.commandCount(handler);
    return this;
  }

  /**
   * Get total number of Redis commands
   * @return 
   */
  public Single<Long> rxCommandCount() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      commandCount(handler);
    });
  }

  /**
   * Extract keys given a full Redis command
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient commandGetkeys(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.commandGetkeys(handler);
    return this;
  }

  /**
   * Extract keys given a full Redis command
   * @return 
   */
  public Single<JsonArray> rxCommandGetkeys() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      commandGetkeys(handler);
    });
  }

  /**
   * Get array of specific Redis command details
   * @param commands List of commands to get info for
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient commandInfo(List<String> commands, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.commandInfo(commands, handler);
    return this;
  }

  /**
   * Get array of specific Redis command details
   * @param commands List of commands to get info for
   * @return 
   */
  public Single<JsonArray> rxCommandInfo(List<String> commands) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      commandInfo(commands, handler);
    });
  }

  /**
   * Get the value of a configuration parameter
   * @param parameter Configuration parameter
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient configGet(String parameter, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.configGet(parameter, handler);
    return this;
  }

  /**
   * Get the value of a configuration parameter
   * @param parameter Configuration parameter
   * @return 
   */
  public Single<JsonArray> rxConfigGet(String parameter) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      configGet(parameter, handler);
    });
  }

  /**
   * Rewrite the configuration file with the in memory configuration
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient configRewrite(Handler<AsyncResult<String>> handler) { 
    delegate.configRewrite(handler);
    return this;
  }

  /**
   * Rewrite the configuration file with the in memory configuration
   * @return 
   */
  public Single<String> rxConfigRewrite() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      configRewrite(handler);
    });
  }

  /**
   * Set a configuration parameter to the given value
   * @param parameter Configuration parameter
   * @param value New value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient configSet(String parameter, String value, Handler<AsyncResult<String>> handler) { 
    delegate.configSet(parameter, value, handler);
    return this;
  }

  /**
   * Set a configuration parameter to the given value
   * @param parameter Configuration parameter
   * @param value New value
   * @return 
   */
  public Single<String> rxConfigSet(String parameter, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      configSet(parameter, value, handler);
    });
  }

  /**
   * Reset the stats returned by INFO
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient configResetstat(Handler<AsyncResult<String>> handler) { 
    delegate.configResetstat(handler);
    return this;
  }

  /**
   * Reset the stats returned by INFO
   * @return 
   */
  public Single<String> rxConfigResetstat() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      configResetstat(handler);
    });
  }

  /**
   * Return the number of keys in the selected database
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient dbsize(Handler<AsyncResult<Long>> handler) { 
    delegate.dbsize(handler);
    return this;
  }

  /**
   * Return the number of keys in the selected database
   * @return 
   */
  public Single<Long> rxDbsize() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      dbsize(handler);
    });
  }

  /**
   * Get debugging information about a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient debugObject(String key, Handler<AsyncResult<String>> handler) { 
    delegate.debugObject(key, handler);
    return this;
  }

  /**
   * Get debugging information about a key
   * @param key Key string
   * @return 
   */
  public Single<String> rxDebugObject(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      debugObject(key, handler);
    });
  }

  /**
   * Make the server crash
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient debugSegfault(Handler<AsyncResult<String>> handler) { 
    delegate.debugSegfault(handler);
    return this;
  }

  /**
   * Make the server crash
   * @return 
   */
  public Single<String> rxDebugSegfault() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      debugSegfault(handler);
    });
  }

  /**
   * Decrement the integer value of a key by one
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient decr(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.decr(key, handler);
    return this;
  }

  /**
   * Decrement the integer value of a key by one
   * @param key Key string
   * @return 
   */
  public Single<Long> rxDecr(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      decr(key, handler);
    });
  }

  /**
   * Decrement the integer value of a key by the given number
   * @param key Key string
   * @param decrement Value by which to decrement
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient decrby(String key, long decrement, Handler<AsyncResult<Long>> handler) { 
    delegate.decrby(key, decrement, handler);
    return this;
  }

  /**
   * Decrement the integer value of a key by the given number
   * @param key Key string
   * @param decrement Value by which to decrement
   * @return 
   */
  public Single<Long> rxDecrby(String key, long decrement) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      decrby(key, decrement, handler);
    });
  }

  /**
   * Delete a key
   * @param key Keys to delete
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient del(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.del(key, handler);
    return this;
  }

  /**
   * Delete a key
   * @param key Keys to delete
   * @return 
   */
  public Single<Long> rxDel(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      del(key, handler);
    });
  }

  /**
   * Delete many keys
   * @param keys List of keys to delete
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient delMany(List<String> keys, Handler<AsyncResult<Long>> handler) { 
    delegate.delMany(keys, handler);
    return this;
  }

  /**
   * Delete many keys
   * @param keys List of keys to delete
   * @return 
   */
  public Single<Long> rxDelMany(List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      delMany(keys, handler);
    });
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient dump(String key, Handler<AsyncResult<String>> handler) { 
    delegate.dump(key, handler);
    return this;
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * @param key Key string
   * @return 
   */
  public Single<String> rxDump(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      dump(key, handler);
    });
  }

  /**
   * Echo the given string
   * @param message String to echo
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient echo(String message, Handler<AsyncResult<String>> handler) { 
    delegate.echo(message, handler);
    return this;
  }

  /**
   * Echo the given string
   * @param message String to echo
   * @return 
   */
  public Single<String> rxEcho(String message) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      echo(message, handler);
    });
  }

  /**
   * Execute a Lua script server side. Due to the dynamic nature of this command any response type could be returned
   * for This reason and to ensure type safety the reply is always guaranteed to be a JsonArray.
   *
   * When a reply if for example a String the handler will be called with a JsonArray with a single element containing
   * the String.
   * @param script Lua script to evaluate
   * @param keys List of keys
   * @param args List of argument values
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.eval(script, keys, args, handler);
    return this;
  }

  /**
   * Execute a Lua script server side. Due to the dynamic nature of this command any response type could be returned
   * for This reason and to ensure type safety the reply is always guaranteed to be a JsonArray.
   *
   * When a reply if for example a String the handler will be called with a JsonArray with a single element containing
   * the String.
   * @param script Lua script to evaluate
   * @param keys List of keys
   * @param args List of argument values
   * @return 
   */
  public Single<JsonArray> rxEval(String script, List<String> keys, List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      eval(script, keys, args, handler);
    });
  }

  /**
   * Execute a Lua script server side. Due to the dynamic nature of this command any response type could be returned
   * for This reason and to ensure type safety the reply is always guaranteed to be a JsonArray.
   *
   * When a reply if for example a String the handler will be called with a JsonArray with a single element containing
   * the String.
   * @param sha1 SHA1 digest of the script cached on the server
   * @param keys List of keys
   * @param values List of values
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.evalsha(sha1, keys, values, handler);
    return this;
  }

  /**
   * Execute a Lua script server side. Due to the dynamic nature of this command any response type could be returned
   * for This reason and to ensure type safety the reply is always guaranteed to be a JsonArray.
   *
   * When a reply if for example a String the handler will be called with a JsonArray with a single element containing
   * the String.
   * @param sha1 SHA1 digest of the script cached on the server
   * @param keys List of keys
   * @param values List of values
   * @return 
   */
  public Single<JsonArray> rxEvalsha(String sha1, List<String> keys, List<String> values) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      evalsha(sha1, keys, values, handler);
    });
  }

  /**
   * Execute a Lua script server side. This method is a high level wrapper around EVAL and EVALSHA
   * using the latter if possible, falling back to EVAL if the script is not cached by the server yet.
   * According to Redis documentation, executed scripts are guaranteed to be in the script cache of a
   * given execution of a Redis instance forever, which means typically the overhead incurred by
   * optimistically sending EVALSHA is minimal, while improving performance and saving bandwidth
   * compared to using EVAL every time.
   * @param script Lua script and its SHA1 digest
   * @param keys List of keys
   * @param args List of argument values
   * @param handler Handler for the result of this call. group: scripting
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient evalScript(io.vertx.reactivex.redis.Script script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.evalScript(script.getDelegate(), keys, args, handler);
    return this;
  }

  /**
   * Execute a Lua script server side. This method is a high level wrapper around EVAL and EVALSHA
   * using the latter if possible, falling back to EVAL if the script is not cached by the server yet.
   * According to Redis documentation, executed scripts are guaranteed to be in the script cache of a
   * given execution of a Redis instance forever, which means typically the overhead incurred by
   * optimistically sending EVALSHA is minimal, while improving performance and saving bandwidth
   * compared to using EVAL every time.
   * @param script Lua script and its SHA1 digest
   * @param keys List of keys
   * @param args List of argument values
   * @return 
   */
  public Single<JsonArray> rxEvalScript(io.vertx.reactivex.redis.Script script, List<String> keys, List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      evalScript(script, keys, args, handler);
    });
  }

  /**
   * Determine if a key exists
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient exists(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.exists(key, handler);
    return this;
  }

  /**
   * Determine if a key exists
   * @param key Key string
   * @return 
   */
  public Single<Long> rxExists(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      exists(key, handler);
    });
  }

  /**
   * Determine if one or many keys exist
   * @param keys List of key strings
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient existsMany(List<String> keys, Handler<AsyncResult<Long>> handler) { 
    delegate.existsMany(keys, handler);
    return this;
  }

  /**
   * Determine if one or many keys exist
   * @param keys List of key strings
   * @return 
   */
  public Single<Long> rxExistsMany(List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      existsMany(keys, handler);
    });
  }

  /**
   * Set a key's time to live in seconds
   * @param key Key string
   * @param seconds Time to live in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient expire(String key, long seconds, Handler<AsyncResult<Long>> handler) { 
    delegate.expire(key, seconds, handler);
    return this;
  }

  /**
   * Set a key's time to live in seconds
   * @param key Key string
   * @param seconds Time to live in seconds
   * @return 
   */
  public Single<Long> rxExpire(String key, long seconds) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      expire(key, seconds, handler);
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp
   * @param key Key string
   * @param seconds Expiry time as Unix timestamp in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient expireat(String key, long seconds, Handler<AsyncResult<Long>> handler) { 
    delegate.expireat(key, seconds, handler);
    return this;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp
   * @param key Key string
   * @param seconds Expiry time as Unix timestamp in seconds
   * @return 
   */
  public Single<Long> rxExpireat(String key, long seconds) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      expireat(key, seconds, handler);
    });
  }

  /**
   * Remove all keys from all databases
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient flushall(Handler<AsyncResult<String>> handler) { 
    delegate.flushall(handler);
    return this;
  }

  /**
   * Remove all keys from all databases
   * @return 
   */
  public Single<String> rxFlushall() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      flushall(handler);
    });
  }

  /**
   * Remove all keys from the current database
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient flushdb(Handler<AsyncResult<String>> handler) { 
    delegate.flushdb(handler);
    return this;
  }

  /**
   * Remove all keys from the current database
   * @return 
   */
  public Single<String> rxFlushdb() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      flushdb(handler);
    });
  }

  /**
   * Get the value of a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient get(String key, Handler<AsyncResult<String>> handler) { 
    delegate.get(key, handler);
    return this;
  }

  /**
   * Get the value of a key
   * @param key Key string
   * @return 
   */
  public Maybe<String> rxGet(String key) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      get(key, handler);
    });
  }

  /**
   * Get the value of a key - without decoding as utf-8
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient getBinary(String key, Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) { 
    delegate.getBinary(key, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Get the value of a key - without decoding as utf-8
   * @param key Key string
   * @return 
   */
  public Maybe<io.vertx.reactivex.core.buffer.Buffer> rxGetBinary(String key) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      getBinary(key, handler);
    });
  }

  /**
   * Returns the bit value at offset in the string value stored at key
   * @param key Key string
   * @param offset Offset in bits
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient getbit(String key, long offset, Handler<AsyncResult<Long>> handler) { 
    delegate.getbit(key, offset, handler);
    return this;
  }

  /**
   * Returns the bit value at offset in the string value stored at key
   * @param key Key string
   * @param offset Offset in bits
   * @return 
   */
  public Single<Long> rxGetbit(String key, long offset) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getbit(key, offset, handler);
    });
  }

  /**
   * Get a substring of the string stored at a key
   * @param key Key string
   * @param start Start offset
   * @param end End offset - inclusive
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) { 
    delegate.getrange(key, start, end, handler);
    return this;
  }

  /**
   * Get a substring of the string stored at a key
   * @param key Key string
   * @param start Start offset
   * @param end End offset - inclusive
   * @return 
   */
  public Single<String> rxGetrange(String key, long start, long end) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getrange(key, start, end, handler);
    });
  }

  /**
   * Set the string value of a key and return its old value
   * @param key Key of which value to set
   * @param value New value for the key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient getset(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.getset(key, value, handler);
    return this;
  }

  /**
   * Set the string value of a key and return its old value
   * @param key Key of which value to set
   * @param value New value for the key
   * @return 
   */
  public Maybe<String> rxGetset(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      getset(key, value, handler);
    });
  }

  /**
   * Delete one or more hash fields
   * @param key Key string
   * @param field Field name
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hdel(String key, String field, Handler<AsyncResult<Long>> handler) { 
    delegate.hdel(key, field, handler);
    return this;
  }

  /**
   * Delete one or more hash fields
   * @param key Key string
   * @param field Field name
   * @return 
   */
  public Single<Long> rxHdel(String key, String field) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hdel(key, field, handler);
    });
  }

  /**
   * Delete one or more hash fields
   * @param key Key string
   * @param fields Field names
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hdelMany(String key, List<String> fields, Handler<AsyncResult<Long>> handler) { 
    delegate.hdelMany(key, fields, handler);
    return this;
  }

  /**
   * Delete one or more hash fields
   * @param key Key string
   * @param fields Field names
   * @return 
   */
  public Single<Long> rxHdelMany(String key, List<String> fields) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hdelMany(key, fields, handler);
    });
  }

  /**
   * Determine if a hash field exists
   * @param key Key string
   * @param field Field name
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hexists(String key, String field, Handler<AsyncResult<Long>> handler) { 
    delegate.hexists(key, field, handler);
    return this;
  }

  /**
   * Determine if a hash field exists
   * @param key Key string
   * @param field Field name
   * @return 
   */
  public Single<Long> rxHexists(String key, String field) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hexists(key, field, handler);
    });
  }

  /**
   * Get the value of a hash field
   * @param key Key string
   * @param field Field name
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hget(String key, String field, Handler<AsyncResult<String>> handler) { 
    delegate.hget(key, field, handler);
    return this;
  }

  /**
   * Get the value of a hash field
   * @param key Key string
   * @param field Field name
   * @return 
   */
  public Maybe<String> rxHget(String key, String field) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hget(key, field, handler);
    });
  }

  /**
   * Get all the fields and values in a hash
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hgetall(String key, Handler<AsyncResult<JsonObject>> handler) { 
    delegate.hgetall(key, handler);
    return this;
  }

  /**
   * Get all the fields and values in a hash
   * @param key Key string
   * @return 
   */
  public Single<JsonObject> rxHgetall(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hgetall(key, handler);
    });
  }

  /**
   * Increment the integer value of a hash field by the given number
   * @param key Key string
   * @param field Field name
   * @param increment Value by which to increment
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hincrby(String key, String field, long increment, Handler<AsyncResult<Long>> handler) { 
    delegate.hincrby(key, field, increment, handler);
    return this;
  }

  /**
   * Increment the integer value of a hash field by the given number
   * @param key Key string
   * @param field Field name
   * @param increment Value by which to increment
   * @return 
   */
  public Single<Long> rxHincrby(String key, String field, long increment) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hincrby(key, field, increment, handler);
    });
  }

  /**
   * Increment the float value of a hash field by the given amount
   * @param key Key string
   * @param field Field name
   * @param increment Value by which to increment
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) { 
    delegate.hincrbyfloat(key, field, increment, handler);
    return this;
  }

  /**
   * Increment the float value of a hash field by the given amount
   * @param key Key string
   * @param field Field name
   * @param increment Value by which to increment
   * @return 
   */
  public Single<String> rxHincrbyfloat(String key, String field, double increment) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hincrbyfloat(key, field, increment, handler);
    });
  }

  /**
   * Get all the fields in a hash
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hkeys(String key, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.hkeys(key, handler);
    return this;
  }

  /**
   * Get all the fields in a hash
   * @param key Key string
   * @return 
   */
  public Single<JsonArray> rxHkeys(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hkeys(key, handler);
    });
  }

  /**
   * Get the number of fields in a hash
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hlen(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.hlen(key, handler);
    return this;
  }

  /**
   * Get the number of fields in a hash
   * @param key Key string
   * @return 
   */
  public Single<Long> rxHlen(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hlen(key, handler);
    });
  }

  /**
   * Get the values of all the given hash fields
   * @param key Key string
   * @param fields Field names
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hmget(String key, List<String> fields, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.hmget(key, fields, handler);
    return this;
  }

  /**
   * Get the values of all the given hash fields
   * @param key Key string
   * @param fields Field names
   * @return 
   */
  public Single<JsonArray> rxHmget(String key, List<String> fields) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hmget(key, fields, handler);
    });
  }

  /**
   * Set multiple hash fields to multiple values
   * @param key Key string
   * @param values Map of field:value pairs
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) { 
    delegate.hmset(key, values, handler);
    return this;
  }

  /**
   * Set multiple hash fields to multiple values
   * @param key Key string
   * @param values Map of field:value pairs
   * @return 
   */
  public Single<String> rxHmset(String key, JsonObject values) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hmset(key, values, handler);
    });
  }

  /**
   * Set the string value of a hash field
   * @param key Key string
   * @param field Field name
   * @param value New value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hset(String key, String field, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.hset(key, field, value, handler);
    return this;
  }

  /**
   * Set the string value of a hash field
   * @param key Key string
   * @param field Field name
   * @param value New value
   * @return 
   */
  public Single<Long> rxHset(String key, String field, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hset(key, field, value, handler);
    });
  }

  /**
   * Set the value of a hash field, only if the field does not exist
   * @param key Key string
   * @param field Field name
   * @param value New value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hsetnx(String key, String field, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.hsetnx(key, field, value, handler);
    return this;
  }

  /**
   * Set the value of a hash field, only if the field does not exist
   * @param key Key string
   * @param field Field name
   * @param value New value
   * @return 
   */
  public Single<Long> rxHsetnx(String key, String field, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hsetnx(key, field, value, handler);
    });
  }

  /**
   * Get all the values in a hash
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hvals(String key, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.hvals(key, handler);
    return this;
  }

  /**
   * Get all the values in a hash
   * @param key Key string
   * @return 
   */
  public Single<JsonArray> rxHvals(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hvals(key, handler);
    });
  }

  /**
   * Increment the integer value of a key by one
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient incr(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.incr(key, handler);
    return this;
  }

  /**
   * Increment the integer value of a key by one
   * @param key Key string
   * @return 
   */
  public Single<Long> rxIncr(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      incr(key, handler);
    });
  }

  /**
   * Increment the integer value of a key by the given amount
   * @param key Key string
   * @param increment Value by which to increment
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient incrby(String key, long increment, Handler<AsyncResult<Long>> handler) { 
    delegate.incrby(key, increment, handler);
    return this;
  }

  /**
   * Increment the integer value of a key by the given amount
   * @param key Key string
   * @param increment Value by which to increment
   * @return 
   */
  public Single<Long> rxIncrby(String key, long increment) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      incrby(key, increment, handler);
    });
  }

  /**
   * Increment the float value of a key by the given amount
   * @param key Key string
   * @param increment Value by which to increment
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) { 
    delegate.incrbyfloat(key, increment, handler);
    return this;
  }

  /**
   * Increment the float value of a key by the given amount
   * @param key Key string
   * @param increment Value by which to increment
   * @return 
   */
  public Single<String> rxIncrbyfloat(String key, double increment) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      incrbyfloat(key, increment, handler);
    });
  }

  /**
   * Get information and statistics about the server
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient info(Handler<AsyncResult<JsonObject>> handler) { 
    delegate.info(handler);
    return this;
  }

  /**
   * Get information and statistics about the server
   * @return 
   */
  public Single<JsonObject> rxInfo() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      info(handler);
    });
  }

  /**
   * Get information and statistics about the server
   * @param section Specific section of information to return
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient infoSection(String section, Handler<AsyncResult<JsonObject>> handler) { 
    delegate.infoSection(section, handler);
    return this;
  }

  /**
   * Get information and statistics about the server
   * @param section Specific section of information to return
   * @return 
   */
  public Single<JsonObject> rxInfoSection(String section) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      infoSection(section, handler);
    });
  }

  /**
   * Find all keys matching the given pattern
   * @param pattern Pattern to limit the keys returned
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient keys(String pattern, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.keys(pattern, handler);
    return this;
  }

  /**
   * Find all keys matching the given pattern
   * @param pattern Pattern to limit the keys returned
   * @return 
   */
  public Single<JsonArray> rxKeys(String pattern) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      keys(pattern, handler);
    });
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lastsave(Handler<AsyncResult<Long>> handler) { 
    delegate.lastsave(handler);
    return this;
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk
   * @return 
   */
  public Single<Long> rxLastsave() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      lastsave(handler);
    });
  }

  /**
   * Get an element from a list by its index
   * @param key Key string
   * @param index Index of list element to get
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lindex(String key, int index, Handler<AsyncResult<String>> handler) { 
    delegate.lindex(key, index, handler);
    return this;
  }

  /**
   * Get an element from a list by its index
   * @param key Key string
   * @param index Index of list element to get
   * @return 
   */
  public Single<String> rxLindex(String key, int index) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      lindex(key, index, handler);
    });
  }

  /**
   * Insert an element before or after another element in a list
   * @param key Key string
   * @param option BEFORE or AFTER
   * @param pivot Key to use as a pivot
   * @param value Value to be inserted before or after the pivot
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.linsert(key, option, pivot, value, handler);
    return this;
  }

  /**
   * Insert an element before or after another element in a list
   * @param key Key string
   * @param option BEFORE or AFTER
   * @param pivot Key to use as a pivot
   * @param value Value to be inserted before or after the pivot
   * @return 
   */
  public Single<Long> rxLinsert(String key, InsertOptions option, String pivot, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      linsert(key, option, pivot, value, handler);
    });
  }

  /**
   * Get the length of a list
   * @param key String key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient llen(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.llen(key, handler);
    return this;
  }

  /**
   * Get the length of a list
   * @param key String key
   * @return 
   */
  public Single<Long> rxLlen(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      llen(key, handler);
    });
  }

  /**
   * Remove and get the first element in a list
   * @param key String key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lpop(String key, Handler<AsyncResult<String>> handler) { 
    delegate.lpop(key, handler);
    return this;
  }

  /**
   * Remove and get the first element in a list
   * @param key String key
   * @return 
   */
  public Maybe<String> rxLpop(String key) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lpop(key, handler);
    });
  }

  /**
   * Prepend one or multiple values to a list
   * @param key Key string
   * @param values Values to be added at the beginning of the list, one by one
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) { 
    delegate.lpushMany(key, values, handler);
    return this;
  }

  /**
   * Prepend one or multiple values to a list
   * @param key Key string
   * @param values Values to be added at the beginning of the list, one by one
   * @return 
   */
  public Single<Long> rxLpushMany(String key, List<String> values) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      lpushMany(key, values, handler);
    });
  }

  /**
   * Prepend one value to a list
   * @param key Key string
   * @param value Value to be added at the beginning of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lpush(String key, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.lpush(key, value, handler);
    return this;
  }

  /**
   * Prepend one value to a list
   * @param key Key string
   * @param value Value to be added at the beginning of the list
   * @return 
   */
  public Single<Long> rxLpush(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      lpush(key, value, handler);
    });
  }

  /**
   * Prepend a value to a list, only if the list exists
   * @param key Key string
   * @param value Value to add at the beginning of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lpushx(String key, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.lpushx(key, value, handler);
    return this;
  }

  /**
   * Prepend a value to a list, only if the list exists
   * @param key Key string
   * @param value Value to add at the beginning of the list
   * @return 
   */
  public Single<Long> rxLpushx(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      lpushx(key, value, handler);
    });
  }

  /**
   * Get a range of elements from a list
   * @param key Key string
   * @param from Start index
   * @param to Stop index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lrange(String key, long from, long to, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.lrange(key, from, to, handler);
    return this;
  }

  /**
   * Get a range of elements from a list
   * @param key Key string
   * @param from Start index
   * @param to Stop index
   * @return 
   */
  public Single<JsonArray> rxLrange(String key, long from, long to) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      lrange(key, from, to, handler);
    });
  }

  /**
   * Remove elements from a list
   * @param key Key string
   * @param count Number of first found occurrences equal to $value to remove from the list
   * @param value Value to be removed
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lrem(String key, long count, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.lrem(key, count, value, handler);
    return this;
  }

  /**
   * Remove elements from a list
   * @param key Key string
   * @param count Number of first found occurrences equal to $value to remove from the list
   * @param value Value to be removed
   * @return 
   */
  public Single<Long> rxLrem(String key, long count, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      lrem(key, count, value, handler);
    });
  }

  /**
   * Set the value of an element in a list by its index
   * @param key Key string
   * @param index Position within list
   * @param value New value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient lset(String key, long index, String value, Handler<AsyncResult<String>> handler) { 
    delegate.lset(key, index, value, handler);
    return this;
  }

  /**
   * Set the value of an element in a list by its index
   * @param key Key string
   * @param index Position within list
   * @param value New value
   * @return 
   */
  public Single<String> rxLset(String key, long index, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      lset(key, index, value, handler);
    });
  }

  /**
   * Trim a list to the specified range
   * @param key Key string
   * @param from Start index
   * @param to Stop index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) { 
    delegate.ltrim(key, from, to, handler);
    return this;
  }

  /**
   * Trim a list to the specified range
   * @param key Key string
   * @param from Start index
   * @param to Stop index
   * @return 
   */
  public Single<String> rxLtrim(String key, long from, long to) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      ltrim(key, from, to, handler);
    });
  }

  /**
   * Get the value of the given key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient mget(String key, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.mget(key, handler);
    return this;
  }

  /**
   * Get the value of the given key
   * @param key Key string
   * @return 
   */
  public Single<JsonArray> rxMget(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      mget(key, handler);
    });
  }

  /**
   * Get the values of all the given keys
   * @param keys List of keys to get
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient mgetMany(List<String> keys, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.mgetMany(keys, handler);
    return this;
  }

  /**
   * Get the values of all the given keys
   * @param keys List of keys to get
   * @return 
   */
  public Single<JsonArray> rxMgetMany(List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      mgetMany(keys, handler);
    });
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * @param host Destination host
   * @param port Destination port
   * @param key Key to migrate
   * @param destdb Destination database index
   * @param timeout 
   * @param options Migrate options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.migrate(host, port, key, destdb, timeout, options, handler);
    return this;
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * @param host Destination host
   * @param port Destination port
   * @param key Key to migrate
   * @param destdb Destination database index
   * @param timeout 
   * @param options Migrate options
   * @return 
   */
  public Single<String> rxMigrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      migrate(host, port, key, destdb, timeout, options, handler);
    });
  }

  /**
   * Listen for all requests received by the server in real time
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient monitor(Handler<AsyncResult<Void>> handler) { 
    delegate.monitor(handler);
    return this;
  }

  /**
   * Listen for all requests received by the server in real time
   * @return 
   */
  public Completable rxMonitor() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      monitor(handler);
    });
  }

  /**
   * Move a key to another database
   * @param key Key to migrate
   * @param destdb Destination database index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient move(String key, int destdb, Handler<AsyncResult<Long>> handler) { 
    delegate.move(key, destdb, handler);
    return this;
  }

  /**
   * Move a key to another database
   * @param key Key to migrate
   * @param destdb Destination database index
   * @return 
   */
  public Single<Long> rxMove(String key, int destdb) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      move(key, destdb, handler);
    });
  }

  /**
   * Set multiple keys to multiple values
   * @param keyvals Key value pairs to set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) { 
    delegate.mset(keyvals, handler);
    return this;
  }

  /**
   * Set multiple keys to multiple values
   * @param keyvals Key value pairs to set
   * @return 
   */
  public Single<String> rxMset(JsonObject keyvals) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      mset(keyvals, handler);
    });
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist
   * @param keyvals Key value pairs to set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient msetnx(JsonObject keyvals, Handler<AsyncResult<Long>> handler) { 
    delegate.msetnx(keyvals, handler);
    return this;
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist
   * @param keyvals Key value pairs to set
   * @return 
   */
  public Single<Long> rxMsetnx(JsonObject keyvals) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      msetnx(keyvals, handler);
    });
  }

  /**
   * Inspect the internals of Redis objects
   * @param key Key string
   * @param cmd Object sub command
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient object(String key, ObjectCmd cmd, Handler<AsyncResult<Void>> handler) { 
    delegate.object(key, cmd, handler);
    return this;
  }

  /**
   * Inspect the internals of Redis objects
   * @param key Key string
   * @param cmd Object sub command
   * @return 
   */
  public Completable rxObject(String key, ObjectCmd cmd) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      object(key, cmd, handler);
    });
  }

  /**
   * Remove the expiration from a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient persist(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.persist(key, handler);
    return this;
  }

  /**
   * Remove the expiration from a key
   * @param key Key string
   * @return 
   */
  public Single<Long> rxPersist(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      persist(key, handler);
    });
  }

  /**
   * Set a key's time to live in milliseconds
   * @param key String key
   * @param millis Time to live in milliseconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pexpire(String key, long millis, Handler<AsyncResult<Long>> handler) { 
    delegate.pexpire(key, millis, handler);
    return this;
  }

  /**
   * Set a key's time to live in milliseconds
   * @param key String key
   * @param millis Time to live in milliseconds
   * @return 
   */
  public Single<Long> rxPexpire(String key, long millis) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pexpire(key, millis, handler);
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds
   * @param key Key string
   * @param millis Expiry time as Unix timestamp in milliseconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pexpireat(String key, long millis, Handler<AsyncResult<Long>> handler) { 
    delegate.pexpireat(key, millis, handler);
    return this;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds
   * @param key Key string
   * @param millis Expiry time as Unix timestamp in milliseconds
   * @return 
   */
  public Single<Long> rxPexpireat(String key, long millis) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pexpireat(key, millis, handler);
    });
  }

  /**
   * Adds the specified element to the specified HyperLogLog.
   * @param key Key string
   * @param element Element to add
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pfadd(String key, String element, Handler<AsyncResult<Long>> handler) { 
    delegate.pfadd(key, element, handler);
    return this;
  }

  /**
   * Adds the specified element to the specified HyperLogLog.
   * @param key Key string
   * @param element Element to add
   * @return 
   */
  public Single<Long> rxPfadd(String key, String element) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pfadd(key, element, handler);
    });
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * @param key Key string
   * @param elements Elementa to add
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pfaddMany(String key, List<String> elements, Handler<AsyncResult<Long>> handler) { 
    delegate.pfaddMany(key, elements, handler);
    return this;
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * @param key Key string
   * @param elements Elementa to add
   * @return 
   */
  public Single<Long> rxPfaddMany(String key, List<String> elements) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pfaddMany(key, elements, handler);
    });
  }

  /**
   * Return the approximated cardinality of the set observed by the HyperLogLog at key.
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pfcount(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.pfcount(key, handler);
    return this;
  }

  /**
   * Return the approximated cardinality of the set observed by the HyperLogLog at key.
   * @param key Key string
   * @return 
   */
  public Single<Long> rxPfcount(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pfcount(key, handler);
    });
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * @param keys List of keys
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pfcountMany(List<String> keys, Handler<AsyncResult<Long>> handler) { 
    delegate.pfcountMany(keys, handler);
    return this;
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * @param keys List of keys
   * @return 
   */
  public Single<Long> rxPfcountMany(List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pfcountMany(keys, handler);
    });
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * @param destkey Destination key
   * @param keys List of source keys
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.pfmerge(destkey, keys, handler);
    return this;
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * @param destkey Destination key
   * @param keys List of source keys
   * @return 
   */
  public Single<String> rxPfmerge(String destkey, List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pfmerge(destkey, keys, handler);
    });
  }

  /**
   * Ping the server
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient ping(Handler<AsyncResult<String>> handler) { 
    delegate.ping(handler);
    return this;
  }

  /**
   * Ping the server
   * @return 
   */
  public Single<String> rxPing() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      ping(handler);
    });
  }

  /**
   * Set the value and expiration in milliseconds of a key
   * @param key Key string
   * @param millis Number of milliseconds until the key expires
   * @param value New value for key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient psetex(String key, long millis, String value, Handler<AsyncResult<Void>> handler) { 
    delegate.psetex(key, millis, value, handler);
    return this;
  }

  /**
   * Set the value and expiration in milliseconds of a key
   * @param key Key string
   * @param millis Number of milliseconds until the key expires
   * @param value New value for key
   * @return 
   */
  public Completable rxPsetex(String key, long millis, String value) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      psetex(key, millis, value, handler);
    });
  }

  /**
   * Listen for messages published to channels matching the given pattern
   * @param pattern Pattern string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient psubscribe(String pattern, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.psubscribe(pattern, handler);
    return this;
  }

  /**
   * Listen for messages published to channels matching the given pattern
   * @param pattern Pattern string
   * @return 
   */
  public Single<JsonArray> rxPsubscribe(String pattern) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      psubscribe(pattern, handler);
    });
  }

  /**
   * Listen for messages published to channels matching the given patterns
   * @param patterns List of patterns
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient psubscribeMany(List<String> patterns, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.psubscribeMany(patterns, handler);
    return this;
  }

  /**
   * Listen for messages published to channels matching the given patterns
   * @param patterns List of patterns
   * @return 
   */
  public Single<JsonArray> rxPsubscribeMany(List<String> patterns) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      psubscribeMany(patterns, handler);
    });
  }

  /**
   * Lists the currently active channels - only those matching the pattern
   * @param pattern A glob-style pattern - an empty string means no pattern
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pubsubChannels(String pattern, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.pubsubChannels(pattern, handler);
    return this;
  }

  /**
   * Lists the currently active channels - only those matching the pattern
   * @param pattern A glob-style pattern - an empty string means no pattern
   * @return 
   */
  public Single<JsonArray> rxPubsubChannels(String pattern) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pubsubChannels(pattern, handler);
    });
  }

  /**
   * Returns the number of subscribers (not counting clients subscribed to patterns) for the specified channels
   * @param channels List of channels
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pubsubNumsub(List<String> channels, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.pubsubNumsub(channels, handler);
    return this;
  }

  /**
   * Returns the number of subscribers (not counting clients subscribed to patterns) for the specified channels
   * @param channels List of channels
   * @return 
   */
  public Single<JsonArray> rxPubsubNumsub(List<String> channels) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pubsubNumsub(channels, handler);
    });
  }

  /**
   * Returns the number of subscriptions to patterns (that are performed using the PSUBSCRIBE command)
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pubsubNumpat(Handler<AsyncResult<Long>> handler) { 
    delegate.pubsubNumpat(handler);
    return this;
  }

  /**
   * Returns the number of subscriptions to patterns (that are performed using the PSUBSCRIBE command)
   * @return 
   */
  public Single<Long> rxPubsubNumpat() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pubsubNumpat(handler);
    });
  }

  /**
   * Get the time to live for a key in milliseconds
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient pttl(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.pttl(key, handler);
    return this;
  }

  /**
   * Get the time to live for a key in milliseconds
   * @param key Key string
   * @return 
   */
  public Single<Long> rxPttl(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      pttl(key, handler);
    });
  }

  /**
   * Post a message to a channel
   * @param channel Channel key
   * @param message Message to send to channel
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient publish(String channel, String message, Handler<AsyncResult<Long>> handler) { 
    delegate.publish(channel, message, handler);
    return this;
  }

  /**
   * Post a message to a channel
   * @param channel Channel key
   * @param message Message to send to channel
   * @return 
   */
  public Single<Long> rxPublish(String channel, String message) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      publish(channel, message, handler);
    });
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns
   * @param patterns List of patterns to match against
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient punsubscribe(List<String> patterns, Handler<AsyncResult<Void>> handler) { 
    delegate.punsubscribe(patterns, handler);
    return this;
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns
   * @param patterns List of patterns to match against
   * @return 
   */
  public Completable rxPunsubscribe(List<String> patterns) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      punsubscribe(patterns, handler);
    });
  }

  /**
   * Return a random key from the keyspace
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient randomkey(Handler<AsyncResult<String>> handler) { 
    delegate.randomkey(handler);
    return this;
  }

  /**
   * Return a random key from the keyspace
   * @return 
   */
  public Single<String> rxRandomkey() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      randomkey(handler);
    });
  }

  /**
   * Rename a key
   * @param key Key string to be renamed
   * @param newkey New key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient rename(String key, String newkey, Handler<AsyncResult<String>> handler) { 
    delegate.rename(key, newkey, handler);
    return this;
  }

  /**
   * Rename a key
   * @param key Key string to be renamed
   * @param newkey New key string
   * @return 
   */
  public Single<String> rxRename(String key, String newkey) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      rename(key, newkey, handler);
    });
  }

  /**
   * Rename a key, only if the new key does not exist
   * @param key Key string to be renamed
   * @param newkey New key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient renamenx(String key, String newkey, Handler<AsyncResult<Long>> handler) { 
    delegate.renamenx(key, newkey, handler);
    return this;
  }

  /**
   * Rename a key, only if the new key does not exist
   * @param key Key string to be renamed
   * @param newkey New key string
   * @return 
   */
  public Single<Long> rxRenamenx(String key, String newkey) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      renamenx(key, newkey, handler);
    });
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * @param key Key string
   * @param millis Expiry time in milliseconds to set on the key
   * @param serialized Serialized form of the key value as obtained using DUMP
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) { 
    delegate.restore(key, millis, serialized, handler);
    return this;
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * @param key Key string
   * @param millis Expiry time in milliseconds to set on the key
   * @param serialized Serialized form of the key value as obtained using DUMP
   * @return 
   */
  public Single<String> rxRestore(String key, long millis, String serialized) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      restore(key, millis, serialized, handler);
    });
  }

  /**
   * Return the role of the instance in the context of replication
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient role(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.role(handler);
    return this;
  }

  /**
   * Return the role of the instance in the context of replication
   * @return 
   */
  public Single<JsonArray> rxRole() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      role(handler);
    });
  }

  /**
   * Remove and get the last element in a list
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient rpop(String key, Handler<AsyncResult<String>> handler) { 
    delegate.rpop(key, handler);
    return this;
  }

  /**
   * Remove and get the last element in a list
   * @param key Key string
   * @return 
   */
  public Single<String> rxRpop(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      rpop(key, handler);
    });
  }

  /**
   * Remove the last element in a list, append it to another list and return it
   * @param key Key string identifying source list
   * @param destkey Key string identifying destination list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) { 
    delegate.rpoplpush(key, destkey, handler);
    return this;
  }

  /**
   * Remove the last element in a list, append it to another list and return it
   * @param key Key string identifying source list
   * @param destkey Key string identifying destination list
   * @return 
   */
  public Single<String> rxRpoplpush(String key, String destkey) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      rpoplpush(key, destkey, handler);
    });
  }

  /**
   * Append one or multiple values to a list
   * @param key Key string
   * @param values List of values to add to the end of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient rpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) { 
    delegate.rpushMany(key, values, handler);
    return this;
  }

  /**
   * Append one or multiple values to a list
   * @param key Key string
   * @param values List of values to add to the end of the list
   * @return 
   */
  public Single<Long> rxRpushMany(String key, List<String> values) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      rpushMany(key, values, handler);
    });
  }

  /**
   * Append one or multiple values to a list
   * @param key Key string
   * @param value Value to be added to the end of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient rpush(String key, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.rpush(key, value, handler);
    return this;
  }

  /**
   * Append one or multiple values to a list
   * @param key Key string
   * @param value Value to be added to the end of the list
   * @return 
   */
  public Single<Long> rxRpush(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      rpush(key, value, handler);
    });
  }

  /**
   * Append a value to a list, only if the list exists
   * @param key Key string
   * @param value Value to be added to the end of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient rpushx(String key, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.rpushx(key, value, handler);
    return this;
  }

  /**
   * Append a value to a list, only if the list exists
   * @param key Key string
   * @param value Value to be added to the end of the list
   * @return 
   */
  public Single<Long> rxRpushx(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      rpushx(key, value, handler);
    });
  }

  /**
   * Add a member to a set
   * @param key Key string
   * @param member Value to be added to the set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sadd(String key, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.sadd(key, member, handler);
    return this;
  }

  /**
   * Add a member to a set
   * @param key Key string
   * @param member Value to be added to the set
   * @return 
   */
  public Single<Long> rxSadd(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sadd(key, member, handler);
    });
  }

  /**
   * Add one or more members to a set
   * @param key Key string
   * @param members Values to be added to the set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient saddMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) { 
    delegate.saddMany(key, members, handler);
    return this;
  }

  /**
   * Add one or more members to a set
   * @param key Key string
   * @param members Values to be added to the set
   * @return 
   */
  public Single<Long> rxSaddMany(String key, List<String> members) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      saddMany(key, members, handler);
    });
  }

  /**
   * Synchronously save the dataset to disk
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient save(Handler<AsyncResult<String>> handler) { 
    delegate.save(handler);
    return this;
  }

  /**
   * Synchronously save the dataset to disk
   * @return 
   */
  public Single<String> rxSave() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      save(handler);
    });
  }

  /**
   * Get the number of members in a set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient scard(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.scard(key, handler);
    return this;
  }

  /**
   * Get the number of members in a set
   * @param key Key string
   * @return 
   */
  public Single<Long> rxScard(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      scard(key, handler);
    });
  }

  /**
   * Check existence of script in the script cache.
   * @param script SHA1 digest identifying a script in the script cache
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient scriptExists(String script, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.scriptExists(script, handler);
    return this;
  }

  /**
   * Check existence of script in the script cache.
   * @param script SHA1 digest identifying a script in the script cache
   * @return 
   */
  public Single<JsonArray> rxScriptExists(String script) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      scriptExists(script, handler);
    });
  }

  /**
   * Check existence of scripts in the script cache.
   * @param scripts List of SHA1 digests identifying scripts in the script cache
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient scriptExistsMany(List<String> scripts, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.scriptExistsMany(scripts, handler);
    return this;
  }

  /**
   * Check existence of scripts in the script cache.
   * @param scripts List of SHA1 digests identifying scripts in the script cache
   * @return 
   */
  public Single<JsonArray> rxScriptExistsMany(List<String> scripts) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      scriptExistsMany(scripts, handler);
    });
  }

  /**
   * Remove all the scripts from the script cache.
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient scriptFlush(Handler<AsyncResult<String>> handler) { 
    delegate.scriptFlush(handler);
    return this;
  }

  /**
   * Remove all the scripts from the script cache.
   * @return 
   */
  public Single<String> rxScriptFlush() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      scriptFlush(handler);
    });
  }

  /**
   * Kill the script currently in execution.
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient scriptKill(Handler<AsyncResult<String>> handler) { 
    delegate.scriptKill(handler);
    return this;
  }

  /**
   * Kill the script currently in execution.
   * @return 
   */
  public Single<String> rxScriptKill() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      scriptKill(handler);
    });
  }

  /**
   * Load the specified Lua script into the script cache.
   * @param script Lua script
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient scriptLoad(String script, Handler<AsyncResult<String>> handler) { 
    delegate.scriptLoad(script, handler);
    return this;
  }

  /**
   * Load the specified Lua script into the script cache.
   * @param script Lua script
   * @return 
   */
  public Single<String> rxScriptLoad(String script) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      scriptLoad(script, handler);
    });
  }

  /**
   * Subtract multiple sets
   * @param key Key identifying the set to compare with all other sets combined
   * @param cmpkeys List of keys identifying sets to subtract from the key set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.sdiff(key, cmpkeys, handler);
    return this;
  }

  /**
   * Subtract multiple sets
   * @param key Key identifying the set to compare with all other sets combined
   * @param cmpkeys List of keys identifying sets to subtract from the key set
   * @return 
   */
  public Single<JsonArray> rxSdiff(String key, List<String> cmpkeys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sdiff(key, cmpkeys, handler);
    });
  }

  /**
   * Subtract multiple sets and store the resulting set in a key
   * @param destkey Destination key where the result should be stored
   * @param key Key identifying the set to compare with all other sets combined
   * @param cmpkeys List of keys identifying sets to subtract from the key set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<Long>> handler) { 
    delegate.sdiffstore(destkey, key, cmpkeys, handler);
    return this;
  }

  /**
   * Subtract multiple sets and store the resulting set in a key
   * @param destkey Destination key where the result should be stored
   * @param key Key identifying the set to compare with all other sets combined
   * @param cmpkeys List of keys identifying sets to subtract from the key set
   * @return 
   */
  public Single<Long> rxSdiffstore(String destkey, String key, List<String> cmpkeys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sdiffstore(destkey, key, cmpkeys, handler);
    });
  }

  /**
   * Change the selected database for the current connection
   * @param dbindex Index identifying the new active database
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient select(int dbindex, Handler<AsyncResult<String>> handler) { 
    delegate.select(dbindex, handler);
    return this;
  }

  /**
   * Change the selected database for the current connection
   * @param dbindex Index identifying the new active database
   * @return 
   */
  public Single<String> rxSelect(int dbindex) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      select(dbindex, handler);
    });
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient set(String key, String value, Handler<AsyncResult<Void>> handler) { 
    delegate.set(key, value, handler);
    return this;
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @return 
   */
  public Completable rxSet(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      set(key, value, handler);
    });
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param options Set options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.setWithOptions(key, value, options, handler);
    return this;
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param options Set options
   * @return 
   */
  public Single<String> rxSetWithOptions(String key, String value, SetOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      setWithOptions(key, value, options, handler);
    });
  }

  /**
   * Set the binary string value of a key - without encoding as utf-8
   * @param key Key of which value to set
   * @param value New value for the key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient setBinary(String key, io.vertx.reactivex.core.buffer.Buffer value, Handler<AsyncResult<Void>> handler) { 
    delegate.setBinary(key, value.getDelegate(), handler);
    return this;
  }

  /**
   * Set the binary string value of a key - without encoding as utf-8
   * @param key Key of which value to set
   * @param value New value for the key
   * @return 
   */
  public Completable rxSetBinary(String key, io.vertx.reactivex.core.buffer.Buffer value) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      setBinary(key, value, handler);
    });
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param options Set options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient setBinaryWithOptions(String key, io.vertx.reactivex.core.buffer.Buffer value, SetOptions options, Handler<AsyncResult<Void>> handler) { 
    delegate.setBinaryWithOptions(key, value.getDelegate(), options, handler);
    return this;
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param options Set options
   * @return 
   */
  public Completable rxSetBinaryWithOptions(String key, io.vertx.reactivex.core.buffer.Buffer value, SetOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      setBinaryWithOptions(key, value, options, handler);
    });
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key
   * @param key Key string
   * @param offset Bit offset
   * @param bit New value - must be 1 or 0
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient setbit(String key, long offset, int bit, Handler<AsyncResult<Long>> handler) { 
    delegate.setbit(key, offset, bit, handler);
    return this;
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key
   * @param key Key string
   * @param offset Bit offset
   * @param bit New value - must be 1 or 0
   * @return 
   */
  public Single<Long> rxSetbit(String key, long offset, int bit) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      setbit(key, offset, bit, handler);
    });
  }

  /**
   * Set the value and expiration of a key
   * @param key Key string
   * @param seconds Number of seconds until the key expires
   * @param value New value for key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) { 
    delegate.setex(key, seconds, value, handler);
    return this;
  }

  /**
   * Set the value and expiration of a key
   * @param key Key string
   * @param seconds Number of seconds until the key expires
   * @param value New value for key
   * @return 
   */
  public Single<String> rxSetex(String key, long seconds, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      setex(key, seconds, value, handler);
    });
  }

  /**
   * Set the value of a key, only if the key does not exist
   * @param key Key of which value to set
   * @param value New value for the key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient setnx(String key, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.setnx(key, value, handler);
    return this;
  }

  /**
   * Set the value of a key, only if the key does not exist
   * @param key Key of which value to set
   * @param value New value for the key
   * @return 
   */
  public Single<Long> rxSetnx(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      setnx(key, value, handler);
    });
  }

  /**
   * Overwrite part of a string at key starting at the specified offset
   * @param key Key string
   * @param offset Offset - the maximum offset that you can set is 2^29 -1 (536870911), as Redis Strings are limited to 512 megabytes
   * @param value Value to overwrite with
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient setrange(String key, int offset, String value, Handler<AsyncResult<Long>> handler) { 
    delegate.setrange(key, offset, value, handler);
    return this;
  }

  /**
   * Overwrite part of a string at key starting at the specified offset
   * @param key Key string
   * @param offset Offset - the maximum offset that you can set is 2^29 -1 (536870911), as Redis Strings are limited to 512 megabytes
   * @param value Value to overwrite with
   * @return 
   */
  public Single<Long> rxSetrange(String key, int offset, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      setrange(key, offset, value, handler);
    });
  }

  /**
   * Intersect multiple sets
   * @param keys List of keys to perform intersection on
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sinter(List<String> keys, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.sinter(keys, handler);
    return this;
  }

  /**
   * Intersect multiple sets
   * @param keys List of keys to perform intersection on
   * @return 
   */
  public Single<JsonArray> rxSinter(List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sinter(keys, handler);
    });
  }

  /**
   * Intersect multiple sets and store the resulting set in a key
   * @param destkey Key where to store the results
   * @param keys List of keys to perform intersection on
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sinterstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) { 
    delegate.sinterstore(destkey, keys, handler);
    return this;
  }

  /**
   * Intersect multiple sets and store the resulting set in a key
   * @param destkey Key where to store the results
   * @param keys List of keys to perform intersection on
   * @return 
   */
  public Single<Long> rxSinterstore(String destkey, List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sinterstore(destkey, keys, handler);
    });
  }

  /**
   * Determine if a given value is a member of a set
   * @param key Key string
   * @param member Member to look for
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sismember(String key, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.sismember(key, member, handler);
    return this;
  }

  /**
   * Determine if a given value is a member of a set
   * @param key Key string
   * @param member Member to look for
   * @return 
   */
  public Single<Long> rxSismember(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sismember(key, member, handler);
    });
  }

  /**
   * Make the server a slave of another instance
   * @param host Host to become this server's master
   * @param port Port of our new master
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient slaveof(String host, int port, Handler<AsyncResult<String>> handler) { 
    delegate.slaveof(host, port, handler);
    return this;
  }

  /**
   * Make the server a slave of another instance
   * @param host Host to become this server's master
   * @param port Port of our new master
   * @return 
   */
  public Single<String> rxSlaveof(String host, int port) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      slaveof(host, port, handler);
    });
  }

  /**
   * Make this server a master
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient slaveofNoone(Handler<AsyncResult<String>> handler) { 
    delegate.slaveofNoone(handler);
    return this;
  }

  /**
   * Make this server a master
   * @return 
   */
  public Single<String> rxSlaveofNoone() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      slaveofNoone(handler);
    });
  }

  /**
   * Read the Redis slow queries log
   * @param limit Number of log entries to return. If value is less than zero all entries are returned
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient slowlogGet(int limit, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.slowlogGet(limit, handler);
    return this;
  }

  /**
   * Read the Redis slow queries log
   * @param limit Number of log entries to return. If value is less than zero all entries are returned
   * @return 
   */
  public Single<JsonArray> rxSlowlogGet(int limit) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      slowlogGet(limit, handler);
    });
  }

  /**
   * Get the length of the Redis slow queries log
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient slowlogLen(Handler<AsyncResult<Long>> handler) { 
    delegate.slowlogLen(handler);
    return this;
  }

  /**
   * Get the length of the Redis slow queries log
   * @return 
   */
  public Single<Long> rxSlowlogLen() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      slowlogLen(handler);
    });
  }

  /**
   * Reset the Redis slow queries log
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient slowlogReset(Handler<AsyncResult<Void>> handler) { 
    delegate.slowlogReset(handler);
    return this;
  }

  /**
   * Reset the Redis slow queries log
   * @return 
   */
  public Completable rxSlowlogReset() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      slowlogReset(handler);
    });
  }

  /**
   * Get all the members in a set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient smembers(String key, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.smembers(key, handler);
    return this;
  }

  /**
   * Get all the members in a set
   * @param key Key string
   * @return 
   */
  public Single<JsonArray> rxSmembers(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      smembers(key, handler);
    });
  }

  /**
   * Move a member from one set to another
   * @param key Key of source set currently containing the member
   * @param destkey Key identifying the destination set
   * @param member Member to move
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient smove(String key, String destkey, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.smove(key, destkey, member, handler);
    return this;
  }

  /**
   * Move a member from one set to another
   * @param key Key of source set currently containing the member
   * @param destkey Key identifying the destination set
   * @param member Member to move
   * @return 
   */
  public Single<Long> rxSmove(String key, String destkey, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      smove(key, destkey, member, handler);
    });
  }

  /**
   * Sort the elements in a list, set or sorted set
   * @param key Key string
   * @param options Sort options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sort(String key, SortOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.sort(key, options, handler);
    return this;
  }

  /**
   * Sort the elements in a list, set or sorted set
   * @param key Key string
   * @param options Sort options
   * @return 
   */
  public Single<JsonArray> rxSort(String key, SortOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sort(key, options, handler);
    });
  }

  /**
   * Remove and return a random member from a set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient spop(String key, Handler<AsyncResult<String>> handler) { 
    delegate.spop(key, handler);
    return this;
  }

  /**
   * Remove and return a random member from a set
   * @param key Key string
   * @return 
   */
  public Maybe<String> rxSpop(String key) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      spop(key, handler);
    });
  }

  /**
   * Remove and return random members from a set
   * @param key Key string
   * @param count Number of members to remove
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient spopMany(String key, int count, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.spopMany(key, count, handler);
    return this;
  }

  /**
   * Remove and return random members from a set
   * @param key Key string
   * @param count Number of members to remove
   * @return 
   */
  public Single<JsonArray> rxSpopMany(String key, int count) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      spopMany(key, count, handler);
    });
  }

  /**
   * Get one or multiple random members from a set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient srandmember(String key, Handler<AsyncResult<String>> handler) { 
    delegate.srandmember(key, handler);
    return this;
  }

  /**
   * Get one or multiple random members from a set
   * @param key Key string
   * @return 
   */
  public Single<String> rxSrandmember(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      srandmember(key, handler);
    });
  }

  /**
   * Get one or multiple random members from a set
   * @param key Key string
   * @param count Number of members to get
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient srandmemberCount(String key, int count, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.srandmemberCount(key, count, handler);
    return this;
  }

  /**
   * Get one or multiple random members from a set
   * @param key Key string
   * @param count Number of members to get
   * @return 
   */
  public Single<JsonArray> rxSrandmemberCount(String key, int count) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      srandmemberCount(key, count, handler);
    });
  }

  /**
   * Remove one member from a set
   * @param key Key string
   * @param member Member to remove
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient srem(String key, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.srem(key, member, handler);
    return this;
  }

  /**
   * Remove one member from a set
   * @param key Key string
   * @param member Member to remove
   * @return 
   */
  public Single<Long> rxSrem(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      srem(key, member, handler);
    });
  }

  /**
   * Remove one or more members from a set
   * @param key Key string
   * @param members Members to remove
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) { 
    delegate.sremMany(key, members, handler);
    return this;
  }

  /**
   * Remove one or more members from a set
   * @param key Key string
   * @param members Members to remove
   * @return 
   */
  public Single<Long> rxSremMany(String key, List<String> members) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sremMany(key, members, handler);
    });
  }

  /**
   * Get the length of the value stored in a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient strlen(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.strlen(key, handler);
    return this;
  }

  /**
   * Get the length of the value stored in a key
   * @param key Key string
   * @return 
   */
  public Single<Long> rxStrlen(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      strlen(key, handler);
    });
  }

  /**
   * Listen for messages published to the given channels
   * @param channel Channel to subscribe to
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient subscribe(String channel, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.subscribe(channel, handler);
    return this;
  }

  /**
   * Listen for messages published to the given channels
   * @param channel Channel to subscribe to
   * @return 
   */
  public Single<JsonArray> rxSubscribe(String channel) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      subscribe(channel, handler);
    });
  }

  /**
   * Listen for messages published to the given channels
   * @param channels List of channels to subscribe to
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient subscribeMany(List<String> channels, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.subscribeMany(channels, handler);
    return this;
  }

  /**
   * Listen for messages published to the given channels
   * @param channels List of channels to subscribe to
   * @return 
   */
  public Single<JsonArray> rxSubscribeMany(List<String> channels) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      subscribeMany(channels, handler);
    });
  }

  /**
   * Add multiple sets
   * @param keys List of keys identifying sets to add up
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sunion(List<String> keys, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.sunion(keys, handler);
    return this;
  }

  /**
   * Add multiple sets
   * @param keys List of keys identifying sets to add up
   * @return 
   */
  public Single<JsonArray> rxSunion(List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sunion(keys, handler);
    });
  }

  /**
   * Add multiple sets and store the resulting set in a key
   * @param destkey Destination key
   * @param keys List of keys identifying sets to add up
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sunionstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) { 
    delegate.sunionstore(destkey, keys, handler);
    return this;
  }

  /**
   * Add multiple sets and store the resulting set in a key
   * @param destkey Destination key
   * @param keys List of keys identifying sets to add up
   * @return 
   */
  public Single<Long> rxSunionstore(String destkey, List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sunionstore(destkey, keys, handler);
    });
  }

  /**
   * Internal command used for replication
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sync(Handler<AsyncResult<Void>> handler) { 
    delegate.sync(handler);
    return this;
  }

  /**
   * Internal command used for replication
   * @return 
   */
  public Completable rxSync() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      sync(handler);
    });
  }

  /**
   * Return the current server time
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient time(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.time(handler);
    return this;
  }

  /**
   * Return the current server time
   * @return 
   */
  public Single<JsonArray> rxTime() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      time(handler);
    });
  }

  /**
   * Return a RedisTransaction instance
   * @return transaction instance
   */
  public io.vertx.reactivex.redis.RedisTransaction transaction() { 
    io.vertx.reactivex.redis.RedisTransaction ret = io.vertx.reactivex.redis.RedisTransaction.newInstance((io.vertx.redis.RedisTransaction)delegate.transaction());
    return ret;
  }

  /**
   * Get the time to live for a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient ttl(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.ttl(key, handler);
    return this;
  }

  /**
   * Get the time to live for a key
   * @param key Key string
   * @return 
   */
  public Single<Long> rxTtl(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      ttl(key, handler);
    });
  }

  /**
   * Determine the type stored at key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient type(String key, Handler<AsyncResult<String>> handler) { 
    delegate.type(key, handler);
    return this;
  }

  /**
   * Determine the type stored at key
   * @param key Key string
   * @return 
   */
  public Single<String> rxType(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      type(key, handler);
    });
  }

  /**
   * Stop listening for messages posted to the given channels
   * @param channels List of channels to subscribe to
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient unsubscribe(List<String> channels, Handler<AsyncResult<Void>> handler) { 
    delegate.unsubscribe(channels, handler);
    return this;
  }

  /**
   * Stop listening for messages posted to the given channels
   * @param channels List of channels to subscribe to
   * @return 
   */
  public Completable rxUnsubscribe(List<String> channels) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      unsubscribe(channels, handler);
    });
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * @param numSlaves 
   * @param timeout 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) { 
    delegate.wait(numSlaves, timeout, handler);
    return this;
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * @param numSlaves 
   * @param timeout 
   * @return 
   */
  public Single<String> rxWait(long numSlaves, long timeout) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      wait(numSlaves, timeout, handler);
    });
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists
   * @param key Key string
   * @param score Score used for sorting
   * @param member New member key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zadd(String key, double score, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.zadd(key, score, member, handler);
    return this;
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists
   * @param key Key string
   * @param score Score used for sorting
   * @param member New member key
   * @return 
   */
  public Single<Long> rxZadd(String key, double score, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zadd(key, score, member, handler);
    });
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists
   * @param key Key string
   * @param members New member keys and their scores
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<Long>> handler) { 
    delegate.zaddMany(key, members, handler);
    return this;
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists
   * @param key Key string
   * @param members New member keys and their scores
   * @return 
   */
  public Single<Long> rxZaddMany(String key, Map<String, Double> members) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zaddMany(key, members, handler);
    });
  }

  /**
   * Get the number of members in a sorted set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zcard(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.zcard(key, handler);
    return this;
  }

  /**
   * Get the number of members in a sorted set
   * @param key Key string
   * @return 
   */
  public Single<Long> rxZcard(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zcard(key, handler);
    });
  }

  /**
   * Count the members in a sorted set with scores within the given values
   * @param key Key string
   * @param min Minimum score
   * @param max Maximum score
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zcount(String key, double min, double max, Handler<AsyncResult<Long>> handler) { 
    delegate.zcount(key, min, max, handler);
    return this;
  }

  /**
   * Count the members in a sorted set with scores within the given values
   * @param key Key string
   * @param min Minimum score
   * @param max Maximum score
   * @return 
   */
  public Single<Long> rxZcount(String key, double min, double max) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zcount(key, min, max, handler);
    });
  }

  /**
   * Increment the score of a member in a sorted set
   * @param key Key string
   * @param increment Increment amount
   * @param member Member key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) { 
    delegate.zincrby(key, increment, member, handler);
    return this;
  }

  /**
   * Increment the score of a member in a sorted set
   * @param key Key string
   * @param increment Increment amount
   * @param member Member key
   * @return 
   */
  public Single<String> rxZincrby(String key, double increment, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zincrby(key, increment, member, handler);
    });
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets to intersect
   * @param options Aggregation options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) { 
    delegate.zinterstore(destkey, sets, options, handler);
    return this;
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets to intersect
   * @param options Aggregation options
   * @return 
   */
  public Single<Long> rxZinterstore(String destkey, List<String> sets, AggregateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zinterstore(destkey, sets, options, handler);
    });
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key using weights for scoring
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets to intersect
   * @param options Aggregation options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) { 
    delegate.zinterstoreWeighed(destkey, sets, options, handler);
    return this;
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key using weights for scoring
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets to intersect
   * @param options Aggregation options
   * @return 
   */
  public Single<Long> rxZinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zinterstoreWeighed(destkey, sets, options, handler);
    });
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range
   * @param key Key string
   * @param min Pattern to compare against for minimum value
   * @param max Pattern to compare against for maximum value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zlexcount(String key, String min, String max, Handler<AsyncResult<Long>> handler) { 
    delegate.zlexcount(key, min, max, handler);
    return this;
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range
   * @param key Key string
   * @param min Pattern to compare against for minimum value
   * @param max Pattern to compare against for maximum value
   * @return 
   */
  public Single<Long> rxZlexcount(String key, String min, String max) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zlexcount(key, min, max, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by index
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrange(String key, long start, long stop, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.zrange(key, start, stop, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by index
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @return 
   */
  public Single<JsonArray> rxZrange(String key, long start, long stop) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrange(key, start, stop, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by index
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param options Range options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.zrangeWithOptions(key, start, stop, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by index
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param options Range options
   * @return 
   */
  public Single<JsonArray> rxZrangeWithOptions(String key, long start, long stop, RangeOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrangeWithOptions(key, start, stop, options, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range
   * @param key Key string
   * @param min Pattern representing a minimum allowed value
   * @param max Pattern representing a maximum allowed value
   * @param options Limit options where limit can be specified
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.zrangebylex(key, min, max, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range
   * @param key Key string
   * @param min Pattern representing a minimum allowed value
   * @param max Pattern representing a maximum allowed value
   * @param options Limit options where limit can be specified
   * @return 
   */
  public Single<JsonArray> rxZrangebylex(String key, String min, String max, LimitOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrangebylex(key, min, max, options, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @param options Range and limit options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.zrangebyscore(key, min, max, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @param options Range and limit options
   * @return 
   */
  public Single<JsonArray> rxZrangebyscore(String key, String min, String max, RangeLimitOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrangebyscore(key, min, max, options, handler);
    });
  }

  /**
   * Determine the index of a member in a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrank(String key, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.zrank(key, member, handler);
    return this;
  }

  /**
   * Determine the index of a member in a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @return 
   */
  public Single<Long> rxZrank(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrank(key, member, handler);
    });
  }

  /**
   * Remove one member from a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrem(String key, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.zrem(key, member, handler);
    return this;
  }

  /**
   * Remove one member from a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @return 
   */
  public Single<Long> rxZrem(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrem(key, member, handler);
    });
  }

  /**
   * Remove one or more members from a sorted set
   * @param key Key string
   * @param members Members in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) { 
    delegate.zremMany(key, members, handler);
    return this;
  }

  /**
   * Remove one or more members from a sorted set
   * @param key Key string
   * @param members Members in the sorted set identified by key
   * @return 
   */
  public Single<Long> rxZremMany(String key, List<String> members) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zremMany(key, members, handler);
    });
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zremrangebylex(String key, String min, String max, Handler<AsyncResult<Long>> handler) { 
    delegate.zremrangebylex(key, min, max, handler);
    return this;
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @return 
   */
  public Single<Long> rxZremrangebylex(String key, String min, String max) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zremrangebylex(key, min, max, handler);
    });
  }

  /**
   * Remove all members in a sorted set within the given indexes
   * @param key Key string
   * @param start Start index
   * @param stop Stop index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<Long>> handler) { 
    delegate.zremrangebyrank(key, start, stop, handler);
    return this;
  }

  /**
   * Remove all members in a sorted set within the given indexes
   * @param key Key string
   * @param start Start index
   * @param stop Stop index
   * @return 
   */
  public Single<Long> rxZremrangebyrank(String key, long start, long stop) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zremrangebyrank(key, start, stop, handler);
    });
  }

  /**
   * Remove all members in a sorted set within the given scores
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zremrangebyscore(String key, String min, String max, Handler<AsyncResult<Long>> handler) { 
    delegate.zremrangebyscore(key, min, max, handler);
    return this;
  }

  /**
   * Remove all members in a sorted set within the given scores
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @return 
   */
  public Single<Long> rxZremrangebyscore(String key, String min, String max) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zremrangebyscore(key, min, max, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param options Range options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.zrevrange(key, start, stop, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param options Range options
   * @return 
   */
  public Single<JsonArray> rxZrevrange(String key, long start, long stop, RangeOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrevrange(key, start, stop, options, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score, between the given lexicographical range with scores ordered from high to low
   * @param key Key string
   * @param max Pattern defining a maximum value
   * @param min Pattern defining a minimum value
   * @param options Limit options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.zrevrangebylex(key, max, min, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score, between the given lexicographical range with scores ordered from high to low
   * @param key Key string
   * @param max Pattern defining a maximum value
   * @param min Pattern defining a minimum value
   * @param options Limit options
   * @return 
   */
  public Single<JsonArray> rxZrevrangebylex(String key, String max, String min, LimitOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrevrangebylex(key, max, min, options, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low
   * @param key Key string
   * @param max Pattern defining a maximum value
   * @param min Pattern defining a minimum value
   * @param options Range and limit options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.zrevrangebyscore(key, max, min, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low
   * @param key Key string
   * @param max Pattern defining a maximum value
   * @param min Pattern defining a minimum value
   * @param options Range and limit options
   * @return 
   */
  public Single<JsonArray> rxZrevrangebyscore(String key, String max, String min, RangeLimitOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrevrangebyscore(key, max, min, options, handler);
    });
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zrevrank(String key, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.zrevrank(key, member, handler);
    return this;
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @return 
   */
  public Single<Long> rxZrevrank(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zrevrank(key, member, handler);
    });
  }

  /**
   * Get the score associated with the given member in a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zscore(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.zscore(key, member, handler);
    return this;
  }

  /**
   * Get the score associated with the given member in a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @return 
   */
  public Single<String> rxZscore(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zscore(key, member, handler);
    });
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets
   * @param options Aggregation options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) { 
    delegate.zunionstore(destkey, sets, options, handler);
    return this;
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets
   * @param options Aggregation options
   * @return 
   */
  public Single<Long> rxZunionstore(String destkey, List<String> sets, AggregateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zunionstore(destkey, sets, options, handler);
    });
  }

  /**
   * Add multiple sorted sets using weights, and store the resulting sorted set in a new key
   * @param key Destination key
   * @param sets Map containing set-key:weight pairs
   * @param options Aggregation options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) { 
    delegate.zunionstoreWeighed(key, sets, options, handler);
    return this;
  }

  /**
   * Add multiple sorted sets using weights, and store the resulting sorted set in a new key
   * @param key Destination key
   * @param sets Map containing set-key:weight pairs
   * @param options Aggregation options
   * @return 
   */
  public Single<Long> rxZunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zunionstoreWeighed(key, sets, options, handler);
    });
  }

  /**
   * Incrementally iterate the keys space
   * @param cursor Cursor id
   * @param options Scan options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient scan(String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.scan(cursor, options, handler);
    return this;
  }

  /**
   * Incrementally iterate the keys space
   * @param cursor Cursor id
   * @param options Scan options
   * @return 
   */
  public Single<JsonArray> rxScan(String cursor, ScanOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      scan(cursor, options, handler);
    });
  }

  /**
   * Incrementally iterate Set elements
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.sscan(key, cursor, options, handler);
    return this;
  }

  /**
   * Incrementally iterate Set elements
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @return 
   */
  public Single<JsonArray> rxSscan(String key, String cursor, ScanOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sscan(key, cursor, options, handler);
    });
  }

  /**
   * Incrementally iterate hash fields and associated values
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.hscan(key, cursor, options, handler);
    return this;
  }

  /**
   * Incrementally iterate hash fields and associated values
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @return 
   */
  public Single<JsonArray> rxHscan(String key, String cursor, ScanOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hscan(key, cursor, options, handler);
    });
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.zscan(key, cursor, options, handler);
    return this;
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @return 
   */
  public Single<JsonArray> rxZscan(String key, String cursor, ScanOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      zscan(key, cursor, options, handler);
    });
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param member member
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<Long>> handler) { 
    delegate.geoadd(key, longitude, latitude, member, handler);
    return this;
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param member member
   * @return 
   */
  public Single<Long> rxGeoadd(String key, double longitude, double latitude, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      geoadd(key, longitude, latitude, member, handler);
    });
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * @param key Key string
   * @param members list of &lt;lon, lat, member&gt;
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<Long>> handler) { 
    delegate.geoaddMany(key, members, handler);
    return this;
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * @param key Key string
   * @param members list of &lt;lon, lat, member&gt;
   * @return 
   */
  public Single<Long> rxGeoaddMany(String key, List<GeoMember> members) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      geoaddMany(key, members, handler);
    });
  }

  /**
   * Return valid Geohash strings representing the position of one or more elements in a sorted set value representing
   * a geospatial index (where elements were added using GEOADD).
   * @param key Key string
   * @param member member
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient geohash(String key, String member, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.geohash(key, member, handler);
    return this;
  }

  /**
   * Return valid Geohash strings representing the position of one or more elements in a sorted set value representing
   * a geospatial index (where elements were added using GEOADD).
   * @param key Key string
   * @param member member
   * @return 
   */
  public Single<JsonArray> rxGeohash(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      geohash(key, member, handler);
    });
  }

  /**
   * Return valid Geohash strings representing the position of one or more elements in a sorted set value representing
   * a geospatial index (where elements were added using GEOADD).
   * @param key Key string
   * @param members list of members
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient geohashMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.geohashMany(key, members, handler);
    return this;
  }

  /**
   * Return valid Geohash strings representing the position of one or more elements in a sorted set value representing
   * a geospatial index (where elements were added using GEOADD).
   * @param key Key string
   * @param members list of members
   * @return 
   */
  public Single<JsonArray> rxGeohashMany(String key, List<String> members) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      geohashMany(key, members, handler);
    });
  }

  /**
   * Return the positions (longitude,latitude) of all the specified members of the geospatial index represented by the
   * sorted set at key.
   * @param key Key string
   * @param member member
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient geopos(String key, String member, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.geopos(key, member, handler);
    return this;
  }

  /**
   * Return the positions (longitude,latitude) of all the specified members of the geospatial index represented by the
   * sorted set at key.
   * @param key Key string
   * @param member member
   * @return 
   */
  public Single<JsonArray> rxGeopos(String key, String member) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      geopos(key, member, handler);
    });
  }

  /**
   * Return the positions (longitude,latitude) of all the specified members of the geospatial index represented by the
   * sorted set at key.
   * @param key Key string
   * @param members list of members
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient geoposMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.geoposMany(key, members, handler);
    return this;
  }

  /**
   * Return the positions (longitude,latitude) of all the specified members of the geospatial index represented by the
   * sorted set at key.
   * @param key Key string
   * @param members list of members
   * @return 
   */
  public Single<JsonArray> rxGeoposMany(String key, List<String> members) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      geoposMany(key, members, handler);
    });
  }

  /**
   * Return the distance between two members in the geospatial index represented by the sorted set.
   * @param key Key string
   * @param member1 member 1
   * @param member2 member 2
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) { 
    delegate.geodist(key, member1, member2, handler);
    return this;
  }

  /**
   * Return the distance between two members in the geospatial index represented by the sorted set.
   * @param key Key string
   * @param member1 member 1
   * @param member2 member 2
   * @return 
   */
  public Single<String> rxGeodist(String key, String member1, String member2) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      geodist(key, member1, member2, handler);
    });
  }

  /**
   * Return the distance between two members in the geospatial index represented by the sorted set.
   * @param key Key string
   * @param member1 member 1
   * @param member2 member 2
   * @param unit geo unit
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) { 
    delegate.geodistWithUnit(key, member1, member2, unit, handler);
    return this;
  }

  /**
   * Return the distance between two members in the geospatial index represented by the sorted set.
   * @param key Key string
   * @param member1 member 1
   * @param member2 member 2
   * @param unit geo unit
   * @return 
   */
  public Single<String> rxGeodistWithUnit(String key, String member1, String member2, GeoUnit unit) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      geodistWithUnit(key, member1, member2, unit, handler);
    });
  }

  /**
   * Return the members of a sorted set populated with geospatial information using GEOADD, which are within the borders
   * of the area specified with the center location and the maximum distance from the center (the radius).
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param radius radius
   * @param unit geo unit
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.georadius(key, longitude, latitude, radius, unit, handler);
    return this;
  }

  /**
   * Return the members of a sorted set populated with geospatial information using GEOADD, which are within the borders
   * of the area specified with the center location and the maximum distance from the center (the radius).
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param radius radius
   * @param unit geo unit
   * @return 
   */
  public Single<JsonArray> rxGeoradius(String key, double longitude, double latitude, double radius, GeoUnit unit) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      georadius(key, longitude, latitude, radius, unit, handler);
    });
  }

  /**
   * Return the members of a sorted set populated with geospatial information using GEOADD, which are within the borders
   * of the area specified with the center location and the maximum distance from the center (the radius).
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param radius radius
   * @param unit geo unit
   * @param options geo radius options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
    return this;
  }

  /**
   * Return the members of a sorted set populated with geospatial information using GEOADD, which are within the borders
   * of the area specified with the center location and the maximum distance from the center (the radius).
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param radius radius
   * @param unit geo unit
   * @param options geo radius options
   * @return 
   */
  public Single<JsonArray> rxGeoradiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
    });
  }

  /**
   * This command is exactly like GEORADIUS with the sole difference that instead of taking, as the center of the area
   * to query, a longitude and latitude value, it takes the name of a member already existing inside the geospatial
   * index represented by the sorted set.
   * @param key Key string
   * @param member member
   * @param radius radius
   * @param unit geo unit
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.georadiusbymember(key, member, radius, unit, handler);
    return this;
  }

  /**
   * This command is exactly like GEORADIUS with the sole difference that instead of taking, as the center of the area
   * to query, a longitude and latitude value, it takes the name of a member already existing inside the geospatial
   * index represented by the sorted set.
   * @param key Key string
   * @param member member
   * @param radius radius
   * @param unit geo unit
   * @return 
   */
  public Single<JsonArray> rxGeoradiusbymember(String key, String member, double radius, GeoUnit unit) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      georadiusbymember(key, member, radius, unit, handler);
    });
  }

  /**
   * This command is exactly like GEORADIUS with the sole difference that instead of taking, as the center of the area
   * to query, a longitude and latitude value, it takes the name of a member already existing inside the geospatial
   * index represented by the sorted set.
   * @param key Key string
   * @param member member
   * @param radius radius
   * @param unit geo unit
   * @param options geo radius options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
    return this;
  }

  /**
   * This command is exactly like GEORADIUS with the sole difference that instead of taking, as the center of the area
   * to query, a longitude and latitude value, it takes the name of a member already existing inside the geospatial
   * index represented by the sorted set.
   * @param key Key string
   * @param member member
   * @param radius radius
   * @param unit geo unit
   * @param options geo radius options
   * @return 
   */
  public Single<JsonArray> rxGeoradiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
    });
  }

  /**
   * Instruct the server whether to reply to commands.
   * @param options 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient clientReply(ClientReplyOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.clientReply(options, handler);
    return this;
  }

  /**
   * Instruct the server whether to reply to commands.
   * @param options 
   * @return 
   */
  public Single<String> rxClientReply(ClientReplyOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      clientReply(options, handler);
    });
  }

  /**
   * Get the length of the value of a hash field.
   * @param key Key String
   * @param field field
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient hstrlen(String key, String field, Handler<AsyncResult<Long>> handler) { 
    delegate.hstrlen(key, field, handler);
    return this;
  }

  /**
   * Get the length of the value of a hash field.
   * @param key Key String
   * @param field field
   * @return 
   */
  public Single<Long> rxHstrlen(String key, String field) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hstrlen(key, field, handler);
    });
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * @param key Key String
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient touch(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.touch(key, handler);
    return this;
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * @param key Key String
   * @return 
   */
  public Single<Long> rxTouch(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      touch(key, handler);
    });
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * @param keys list of keys
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient touchMany(List<String> keys, Handler<AsyncResult<Long>> handler) { 
    delegate.touchMany(keys, handler);
    return this;
  }

  /**
   * Alters the last access time of a key(s). Returns the number of existing keys specified.
   * @param keys list of keys
   * @return 
   */
  public Single<Long> rxTouchMany(List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      touchMany(keys, handler);
    });
  }

  /**
   * Set the debug mode for executed scripts.
   * @param scriptDebugOptions the option
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient scriptDebug(ScriptDebugOptions scriptDebugOptions, Handler<AsyncResult<String>> handler) { 
    delegate.scriptDebug(scriptDebugOptions, handler);
    return this;
  }

  /**
   * Set the debug mode for executed scripts.
   * @param scriptDebugOptions the option
   * @return 
   */
  public Single<String> rxScriptDebug(ScriptDebugOptions scriptDebugOptions) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      scriptDebug(scriptDebugOptions, handler);
    });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * @param key Key string
   * @param bitFieldOptions 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bitfield(String key, BitFieldOptions bitFieldOptions, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.bitfield(key, bitFieldOptions, handler);
    return this;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * @param key Key string
   * @param bitFieldOptions 
   * @return 
   */
  public Single<JsonArray> rxBitfield(String key, BitFieldOptions bitFieldOptions) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bitfield(key, bitFieldOptions, handler);
    });
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * @param key Key string
   * @param commands 
   * @param overflow 
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient bitfieldWithOverflow(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.bitfieldWithOverflow(key, commands, overflow, handler);
    return this;
  }

  /**
   * Perform arbitrary bitfield integer operations on strings.
   * @param key Key string
   * @param commands 
   * @param overflow 
   * @return 
   */
  public Single<JsonArray> rxBitfieldWithOverflow(String key, BitFieldOptions commands, BitFieldOverflowOptions overflow) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      bitfieldWithOverflow(key, commands, overflow, handler);
    });
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * @param key Key to delete
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient unlink(String key, Handler<AsyncResult<Long>> handler) { 
    delegate.unlink(key, handler);
    return this;
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * @param key Key to delete
   * @return 
   */
  public Single<Long> rxUnlink(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      unlink(key, handler);
    });
  }

  /**
   * Delete multiple keys asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * @param keys List of keys to delete
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient unlinkMany(List<String> keys, Handler<AsyncResult<Long>> handler) { 
    delegate.unlinkMany(keys, handler);
    return this;
  }

  /**
   * Delete multiple keys asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * @param keys List of keys to delete
   * @return 
   */
  public Single<Long> rxUnlinkMany(List<String> keys) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      unlinkMany(keys, handler);
    });
  }

  /**
   * Swaps two Redis databases
   * @param index1 index of first database to swap
   * @param index2 index of second database to swap
   * @param handler Handler for the result of this call.
   * @return 
   */
  public io.vertx.reactivex.redis.RedisClient swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) { 
    delegate.swapdb(index1, index2, handler);
    return this;
  }

  /**
   * Swaps two Redis databases
   * @param index1 index of first database to swap
   * @param index2 index of second database to swap
   * @return 
   */
  public Single<String> rxSwapdb(int index1, int index2) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      swapdb(index1, index2, handler);
    });
  }

  public static RedisClient newInstance(io.vertx.redis.RedisClient arg) {
    return arg != null ? new RedisClient(arg) : null;
  }

}
