/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.redis.client.RedisOptions;
import io.vertx.core.Handler;

/**
 * A simple Redis client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Redis original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.redis.client.Redis.class)
public class Redis {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Redis that = (Redis) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Redis> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Redis((io.vertx.redis.client.Redis) obj),
    Redis::getDelegate
  );

  private final io.vertx.redis.client.Redis delegate;
  
  public Redis(io.vertx.redis.client.Redis delegate) {
    this.delegate = delegate;
  }

  public Redis(Object delegate) {
    this.delegate = (io.vertx.redis.client.Redis)delegate;
  }

  public io.vertx.redis.client.Redis getDelegate() {
    return delegate;
  }

  /**
   * Create a new redis client using the default client options.
   * @param vertx the vertx instance
   * @return the client
   */
  public static io.vertx.reactivex.redis.client.Redis createClient(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new redis client using the default client options. Does not support rediss (redis over ssl scheme) for now.
   * @param vertx the vertx instance
   * @param connectionString a string URI following the scheme: redis://[username:password@][host][:port][/database]
   * @return the client
   */
  public static io.vertx.reactivex.redis.client.Redis createClient(io.vertx.reactivex.core.Vertx vertx, String connectionString) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), connectionString));
    return ret;
  }

  /**
   * Create a new redis client using the given client options.
   * @param vertx the vertx instance
   * @param options the user provided options
   * @return the client
   */
  public static io.vertx.reactivex.redis.client.Redis createClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options) { 
    io.vertx.reactivex.redis.client.Redis ret = io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the redis server.
   * @param handler the async result handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.redis.client.Redis connect(Handler<AsyncResult<io.vertx.reactivex.redis.client.RedisConnection>> handler) { 
    delegate.connect(new Handler<AsyncResult<io.vertx.redis.client.RedisConnection>>() {
      public void handle(AsyncResult<io.vertx.redis.client.RedisConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Connects to the redis server.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.redis.client.RedisConnection> rxConnect() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(handler);
    });
  }

  /**
   * Closes the client and terminates any connection.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @param onSend the asynchronous result handler.
   * @return fluent self.
   */
  public io.vertx.reactivex.redis.client.Redis send(io.vertx.reactivex.redis.client.Request command, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> onSend) { 
    delegate.send(command.getDelegate(), new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          onSend.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          onSend.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSend(io.vertx.reactivex.redis.client.Request command) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      send(command, handler);
    });
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @param onSend the asynchronous result handler.
   * @return fluent self.
   */
  public io.vertx.reactivex.redis.client.Redis batch(List<io.vertx.reactivex.redis.client.Request> commands, Handler<AsyncResult<List<io.vertx.reactivex.redis.client.Response>>> onSend) { 
    delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<java.util.List<io.vertx.redis.client.Response>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.redis.client.Response>> ar) {
        if (ar.succeeded()) {
          onSend.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          onSend.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public Single<List<io.vertx.reactivex.redis.client.Response>> rxBatch(List<io.vertx.reactivex.redis.client.Request> commands) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      batch(commands, handler);
    });
  }

  public static Redis newInstance(io.vertx.redis.client.Redis arg) {
    return arg != null ? new Redis(arg) : null;
  }

}
