/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<RedisAPI> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI append(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.append(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxAppend(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      append(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI asking(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.asking(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxAsking() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      asking(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI auth(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.auth(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxAuth(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      auth(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgrewriteaof(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bgrewriteaof(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBgrewriteaof() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bgrewriteaof(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgsave(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bgsave(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBgsave(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bgsave(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitcount(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBitcount(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bitcount(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfield(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitfield(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBitfield(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bitfield(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitop(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBitop(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bitop(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitpos(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitpos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBitpos(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bitpos(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blpop(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.blpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBlpop(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      blpop(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpop(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.brpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBrpop(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      brpop(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpoplpush(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.brpoplpush(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBrpoplpush(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      brpoplpush(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmax(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bzpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBzpopmax(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bzpopmax(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmin(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bzpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxBzpopmin(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bzpopmin(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI client(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.client(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxClient(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      client(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cluster(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cluster(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxCluster(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      cluster(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI command(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.command(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxCommand() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      command(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI config(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.config(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxConfig(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      config(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dbsize(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.dbsize(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxDbsize() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      dbsize(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI debug(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.debug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxDebug(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      debug(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decr(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.decr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxDecr(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      decr(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decrby(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.decrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxDecrby(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      decrby(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI del(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.del(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxDel(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      del(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI discard(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.discard(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxDiscard() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      discard(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dump(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.dump(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxDump(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      dump(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI echo(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.echo(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxEcho(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      echo(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI eval(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.eval(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxEval(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      eval(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalsha(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.evalsha(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxEvalsha(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      evalsha(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exec(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.exec(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxExec() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      exec(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exists(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.exists(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxExists(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      exists(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expire(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.expire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxExpire(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      expire(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expireat(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.expireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxExpireat(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      expireat(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushall(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.flushall(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxFlushall(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      flushall(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushdb(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.flushdb(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxFlushdb(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      flushdb(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geoadd(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geoadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGeoadd(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      geoadd(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geodist(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geodist(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGeodist(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      geodist(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geohash(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geohash(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGeohash(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      geohash(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geopos(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geopos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGeopos(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      geopos(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadius(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadius(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradius(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      georadius(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusRo(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusRo(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      georadiusRo(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymember(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusbymember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusbymember(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      georadiusbymember(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymemberRo(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusbymemberRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusbymemberRo(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      georadiusbymemberRo(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI get(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.get(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGet(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      get(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getbit(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getbit(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGetbit(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      getbit(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getrange(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGetrange(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      getrange(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getset(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getset(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxGetset(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      getset(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hdel(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHdel(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hdel(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hexists(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hexists(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHexists(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hexists(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hget(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hget(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHget(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hget(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hgetall(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hgetall(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHgetall(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hgetall(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrby(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHincrby(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hincrby(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrbyfloat(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hincrbyfloat(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHincrbyfloat(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hincrbyfloat(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hkeys(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hkeys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHkeys(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hkeys(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hlen(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHlen(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hlen(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmget(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hmget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHmget(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hmget(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmset(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hmset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHmset(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hmset(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI host(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.host(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHost(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      host(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hscan(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHscan(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hscan(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hset(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHset(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hset(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hsetnx(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hsetnx(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHsetnx(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hsetnx(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hstrlen(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hstrlen(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHstrlen(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hstrlen(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hvals(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hvals(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxHvals(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      hvals(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incr(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxIncr(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      incr(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrby(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxIncrby(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      incrby(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrbyfloat(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incrbyfloat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxIncrbyfloat(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      incrbyfloat(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI info(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.info(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxInfo(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      info(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI keys(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.keys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxKeys(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      keys(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lastsave(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lastsave(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLastsave() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lastsave(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI latency(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.latency(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLatency(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      latency(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lindex(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lindex(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLindex(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lindex(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI linsert(String arg0, String arg1, String arg2, String arg3, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.linsert(arg0, arg1, arg2, arg3, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLinsert(String arg0, String arg1, String arg2, String arg3) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      linsert(arg0, arg1, arg2, arg3, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI llen(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.llen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLlen(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      llen(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lolwut(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lolwut(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLolwut(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lolwut(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpop(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpop(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLpop(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lpop(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpush(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLpush(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lpush(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpushx(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLpushx(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lpushx(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrange(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLrange(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lrange(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrem(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lrem(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLrem(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lrem(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lset(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lset(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLset(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lset(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ltrim(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ltrim(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxLtrim(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      ltrim(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI memory(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.memory(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxMemory(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      memory(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mget(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.mget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxMget(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      mget(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI migrate(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.migrate(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxMigrate(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      migrate(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI module(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.module(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxModule(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      module(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI monitor(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.monitor(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxMonitor() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      monitor(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI move(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.move(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxMove(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      move(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mset(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.mset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxMset(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      mset(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI msetnx(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.msetnx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxMsetnx(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      msetnx(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI multi(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.multi(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxMulti() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      multi(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI object(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.object(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxObject(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      object(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI persist(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.persist(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPersist(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      persist(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpire(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pexpire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPexpire(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pexpire(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpireat(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pexpireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPexpireat(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pexpireat(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfadd(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPfadd(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pfadd(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfcount(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPfcount(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pfcount(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfdebug(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfdebug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPfdebug(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pfdebug(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfmerge(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfmerge(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPfmerge(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pfmerge(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfselftest(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfselftest(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPfselftest() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pfselftest(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ping(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ping(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPing(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      ping(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI post(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.post(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPost(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      post(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psetex(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psetex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPsetex(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      psetex(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psubscribe(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPsubscribe(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      psubscribe(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psync(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psync(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPsync(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      psync(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pttl(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPttl(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pttl(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI publish(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.publish(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPublish(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      publish(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pubsub(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pubsub(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPubsub(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      pubsub(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI punsubscribe(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.punsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxPunsubscribe(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      punsubscribe(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI randomkey(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.randomkey(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRandomkey() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      randomkey(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readonly(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.readonly(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxReadonly() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      readonly(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readwrite(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.readwrite(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxReadwrite() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      readwrite(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rename(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rename(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRename(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      rename(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI renamenx(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.renamenx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRenamenx(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      renamenx(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replconf(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.replconf(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxReplconf(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      replconf(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replicaof(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.replicaof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxReplicaof(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      replicaof(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restore(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.restore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRestore(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      restore(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restoreAsking(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.restoreAsking(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRestoreAsking(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      restoreAsking(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI role(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.role(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRole() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      role(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpop(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpop(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRpop(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      rpop(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpoplpush(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpoplpush(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRpoplpush(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      rpoplpush(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpush(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRpush(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      rpush(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpushx(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxRpushx(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      rpushx(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sadd(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSadd(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sadd(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI save(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.save(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSave() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      save(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scan(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.scan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxScan(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      scan(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scard(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.scard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxScard(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      scard(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI script(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.script(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxScript(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      script(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiff(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sdiff(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSdiff(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sdiff(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiffstore(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sdiffstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSdiffstore(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sdiffstore(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI select(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.select(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSelect(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      select(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI set(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.set(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSet(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      set(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setbit(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setbit(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSetbit(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      setbit(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setex(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSetex(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      setex(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setnx(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setnx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSetnx(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      setnx(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setrange(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSetrange(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      setrange(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI shutdown(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.shutdown(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxShutdown(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      shutdown(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinter(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sinter(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSinter(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sinter(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinterstore(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSinterstore(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sinterstore(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sismember(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sismember(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSismember(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sismember(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slaveof(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.slaveof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSlaveof(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      slaveof(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slowlog(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.slowlog(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSlowlog(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      slowlog(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smembers(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.smembers(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSmembers(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      smembers(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smove(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.smove(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSmove(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      smove(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sort(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sort(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSort(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sort(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI spop(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.spop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSpop(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      spop(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srandmember(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.srandmember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSrandmember(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      srandmember(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srem(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.srem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSrem(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      srem(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sscan(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSscan(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sscan(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI strlen(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.strlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxStrlen(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      strlen(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI subscribe(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.subscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSubscribe(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      subscribe(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI substr(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.substr(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSubstr(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      substr(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunion(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sunion(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSunion(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sunion(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunionstore(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSunionstore(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sunionstore(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI swapdb(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.swapdb(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSwapdb(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      swapdb(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sync(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sync(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxSync() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      sync(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI time(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.time(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxTime() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      time(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI touch(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.touch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxTouch(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      touch(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ttl(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxTtl(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      ttl(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI type(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.type(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxType(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      type(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unlink(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unlink(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxUnlink(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      unlink(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unsubscribe(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxUnsubscribe(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      unsubscribe(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unwatch(Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unwatch(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxUnwatch() { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      unwatch(handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI wait(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.wait(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxWait(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      wait(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI watch(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.watch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxWatch(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      watch(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xack(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xack(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXack(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xack(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xadd(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXadd(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xadd(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xclaim(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xclaim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXclaim(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xclaim(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xdel(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXdel(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xdel(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xgroup(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXgroup(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xgroup(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xinfo(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xinfo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXinfo(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xinfo(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xlen(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXlen(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xlen(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xpending(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xpending(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXpending(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xpending(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrange(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXrange(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xrange(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xread(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xread(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXread(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xread(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xreadgroup(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xreadgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXreadgroup(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xreadgroup(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrevrange(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXrevrange(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xrevrange(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xsetid(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xsetid(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXsetid(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xsetid(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xtrim(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xtrim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxXtrim(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      xtrim(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zadd(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZadd(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zadd(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcard(String arg0, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zcard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZcard(String arg0) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zcard(arg0, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcount(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZcount(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zcount(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zincrby(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZincrby(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zincrby(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zinterstore(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZinterstore(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zinterstore(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zlexcount(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zlexcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZlexcount(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zlexcount(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmax(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZpopmax(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zpopmax(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmin(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZpopmin(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zpopmin(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrange(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrange(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrange(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebylex(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrangebylex(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrangebylex(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebyscore(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrangebyscore(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrangebyscore(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrank(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrank(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrank(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrem(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrem(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrem(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebylex(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebylex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebylex(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zremrangebylex(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyrank(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebyrank(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebyrank(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zremrangebyrank(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyscore(String arg0, String arg1, String arg2, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebyscore(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebyscore(String arg0, String arg1, String arg2) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zremrangebyscore(arg0, arg1, arg2, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrange(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrange(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrevrange(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebylex(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrangebylex(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrevrangebylex(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebyscore(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrangebyscore(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrevrangebyscore(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrank(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrank(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zrevrank(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscan(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZscan(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zscan(args, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscore(String arg0, String arg1, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zscore(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZscore(String arg0, String arg1) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zscore(arg0, arg1, handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zunionstore(List<String> args, Handler<AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public Maybe<io.vertx.reactivex.redis.client.Response> rxZunionstore(List<String> args) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      zunionstore(args, handler);
    });
  }

  public static io.vertx.reactivex.redis.client.RedisAPI api(io.vertx.reactivex.redis.client.Redis client) { 
    io.vertx.reactivex.redis.client.RedisAPI ret = io.vertx.reactivex.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.reactivex.redis.client.RedisAPI api(io.vertx.reactivex.redis.client.RedisConnection connection) { 
    io.vertx.reactivex.redis.client.RedisAPI ret = io.vertx.reactivex.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
