/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * A query for a prepared statement allowing parameterized execution of the query, this query will use
 * a prepared statement.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.PreparedQuery original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.PreparedQuery.class)
public class PreparedQuery<T> extends io.vertx.reactivex.sqlclient.Query<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreparedQuery that = (PreparedQuery) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<PreparedQuery> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new PreparedQuery((io.vertx.sqlclient.PreparedQuery) obj),
    PreparedQuery::getDelegate
  );

  private final io.vertx.sqlclient.PreparedQuery<T> delegate;
  public final io.vertx.lang.rx.TypeArg<T> __typeArg_0;
  
  public PreparedQuery(io.vertx.sqlclient.PreparedQuery delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rx.TypeArg.unknown();  }

  public PreparedQuery(Object delegate, io.vertx.lang.rx.TypeArg<T> typeArg_0) {
    super((io.vertx.sqlclient.PreparedQuery)delegate);
    this.delegate = (io.vertx.sqlclient.PreparedQuery)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.sqlclient.PreparedQuery getDelegate() {
    return delegate;
  }


  /**
   * Execute the query.
   * @param handler the handler receiving the response
   */
  public void execute(Handler<AsyncResult<T>> handler) { 
    delegate.execute(new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Execute the query.
   * @return 
   */
  public Single<T> rxExecute() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      execute(handler);
    });
  }

  /**
   * Execute the query.
   * @param tuple 
   * @param handler the handler receiving the response
   */
  public void execute(io.vertx.reactivex.sqlclient.Tuple tuple, Handler<AsyncResult<T>> handler) { 
    delegate.execute(tuple.getDelegate(), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Execute the query.
   * @param tuple 
   * @return 
   */
  public Single<T> rxExecute(io.vertx.reactivex.sqlclient.Tuple tuple) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      execute(tuple, handler);
    });
  }

  /**
   * Execute the query with a batch of tuples.
   * @param batch the batch of tuples
   * @param handler the handler receiving the response
   */
  public void executeBatch(List<io.vertx.reactivex.sqlclient.Tuple> batch, Handler<AsyncResult<T>> handler) { 
    delegate.executeBatch(batch.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Execute the query with a batch of tuples.
   * @param batch the batch of tuples
   * @return 
   */
  public Single<T> rxExecuteBatch(List<io.vertx.reactivex.sqlclient.Tuple> batch) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executeBatch(batch, handler);
    });
  }

  /**
   * Use the specified <code>mapper</code> for mapping {@link io.vertx.reactivex.sqlclient.Row} to <code><U></code>.
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<U>> mapping(Function<io.vertx.reactivex.sqlclient.Row, U> mapper) { 
    io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<U>> ret = io.vertx.reactivex.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.mapping(new java.util.function.Function<io.vertx.sqlclient.Row,U>() {
      public U apply(io.vertx.sqlclient.Row arg) {
        U ret = mapper.apply(io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)arg));
        return ret;
      }
    }), new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.RowSet<U>>(o0 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, io.vertx.lang.rx.TypeArg.unknown()), o0 -> o0.getDelegate()));
    return ret;
  }

  public static <T> PreparedQuery<T> newInstance(io.vertx.sqlclient.PreparedQuery arg) {
    return arg != null ? new PreparedQuery<T>(arg) : null;
  }

  public static <T> PreparedQuery<T> newInstance(io.vertx.sqlclient.PreparedQuery arg, io.vertx.lang.rx.TypeArg<T> __typeArg_T) {
    return arg != null ? new PreparedQuery<T>(arg, __typeArg_T) : null;
  }

}
