/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A prepared statement, the statement is pre-compiled and it's more efficient to execute the statement for multiple times.
 * In addition, this kind of statement provides protection against SQL injection attacks.
 *
 * <p>From a prepared statement you can
 *
 * <ul>
 *   <li>use {@link io.vertx.reactivex.sqlclient.PreparedStatement#query} to create and execute a {@link io.vertx.reactivex.sqlclient.PreparedQuery}</li>
 *   <li>use {@link io.vertx.reactivex.sqlclient.PreparedStatement#cursor} to create a {@link io.vertx.reactivex.sqlclient.Cursor}</li>
 *   <li>use {@link io.vertx.reactivex.sqlclient.PreparedStatement#createStream} to create a {@link io.vertx.reactivex.sqlclient.RowStream}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.PreparedStatement original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.PreparedStatement.class)
public class PreparedStatement {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreparedStatement that = (PreparedStatement) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<PreparedStatement> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new PreparedStatement((io.vertx.sqlclient.PreparedStatement) obj),
    PreparedStatement::getDelegate
  );

  private final io.vertx.sqlclient.PreparedStatement delegate;
  
  public PreparedStatement(io.vertx.sqlclient.PreparedStatement delegate) {
    this.delegate = delegate;
  }

  public PreparedStatement(Object delegate) {
    this.delegate = (io.vertx.sqlclient.PreparedStatement)delegate;
  }

  public io.vertx.sqlclient.PreparedStatement getDelegate() {
    return delegate;
  }

  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_0 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.Row> TYPE_ARG_1 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.Row>(o1 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o1), o1 -> o1.getDelegate());

  /**
   * Create a prepared query for this statement.
   * @return the prepared query
   */
  public io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> query() { 
    io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = io.vertx.reactivex.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.query(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @return create a query cursor with a <code>fetch</code> size and empty arguments
   */
  public io.vertx.reactivex.sqlclient.Cursor cursor() { 
    io.vertx.reactivex.sqlclient.Cursor ret = io.vertx.reactivex.sqlclient.Cursor.newInstance((io.vertx.sqlclient.Cursor)delegate.cursor());
    return ret;
  }

  /**
   * Create a cursor with the provided <code>arguments</code>.
   * @param args the list of arguments
   * @return the query
   */
  public io.vertx.reactivex.sqlclient.Cursor cursor(io.vertx.reactivex.sqlclient.Tuple args) { 
    io.vertx.reactivex.sqlclient.Cursor ret = io.vertx.reactivex.sqlclient.Cursor.newInstance((io.vertx.sqlclient.Cursor)delegate.cursor(args.getDelegate()));
    return ret;
  }

  /**
   * Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
   * with a <code>fetch</code> size to fetch the results.
   * <p/>
   * Note: this requires to be in a transaction, since cursors require it.
   * @param fetch the cursor fetch size
   * @param args the prepared query arguments
   * @return the createStream
   */
  public io.vertx.reactivex.sqlclient.RowStream<io.vertx.reactivex.sqlclient.Row> createStream(int fetch, io.vertx.reactivex.sqlclient.Tuple args) { 
    io.vertx.reactivex.sqlclient.RowStream<io.vertx.reactivex.sqlclient.Row> ret = io.vertx.reactivex.sqlclient.RowStream.newInstance((io.vertx.sqlclient.RowStream)delegate.createStream(fetch, args.getDelegate()), TYPE_ARG_1);
    return ret;
  }

  /**
   * Close the prepared query and release its resources.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.PreparedStatement#close} but notifies the <code>completionHandler</code> when it's closed.
   * @param completionHandler 
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.PreparedStatement#close} but notifies the <code>completionHandler</code> when it's closed.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  public static PreparedStatement newInstance(io.vertx.sqlclient.PreparedStatement arg) {
    return arg != null ? new PreparedStatement(arg) : null;
  }

}
