/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.time.OffsetTime;
import java.time.LocalDateTime;
import java.util.UUID;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.Temporal;

/**
 * Represents single row of the result set.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Row original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.Row.class)
public class Row extends io.vertx.reactivex.sqlclient.Tuple {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Row that = (Row) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Row> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Row((io.vertx.sqlclient.Row) obj),
    Row::getDelegate
  );

  private final io.vertx.sqlclient.Row delegate;
  
  public Row(io.vertx.sqlclient.Row delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Row(Object delegate) {
    super((io.vertx.sqlclient.Row)delegate);
    this.delegate = (io.vertx.sqlclient.Row)delegate;
  }

  public io.vertx.sqlclient.Row getDelegate() {
    return delegate;
  }

  /**
   * Get a column name at <code>pos</code>.
   * @param pos the column position
   * @return the column name or <code>null</code>
   */
  public String getColumnName(int pos) { 
    String ret = delegate.getColumnName(pos);
    return ret;
  }

  /**
   * Get a column position for the given column <code>name</code>.
   * @param name the column name
   * @return the column name or <code>-1</code> if not found
   */
  public int getColumnIndex(String name) { 
    int ret = delegate.getColumnIndex(name);
    return ret;
  }

  /**
   * Get an object value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Object getValue(String name) { 
    Object ret = (Object) delegate.getValue(name);
    return ret;
  }

  /**
   * Get a boolean value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Boolean getBoolean(String name) { 
    Boolean ret = delegate.getBoolean(name);
    return ret;
  }

  /**
   * Get a short value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Short getShort(String name) { 
    Short ret = delegate.getShort(name);
    return ret;
  }

  /**
   * Get an integer value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Integer getInteger(String name) { 
    Integer ret = delegate.getInteger(name);
    return ret;
  }

  /**
   * Get a long value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Long getLong(String name) { 
    Long ret = delegate.getLong(name);
    return ret;
  }

  /**
   * Get a float value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Float getFloat(String name) { 
    Float ret = delegate.getFloat(name);
    return ret;
  }

  /**
   * Get a double value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Double getDouble(String name) { 
    Double ret = delegate.getDouble(name);
    return ret;
  }

  /**
   * Get a string value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public String getString(String name) { 
    String ret = delegate.getString(name);
    return ret;
  }

  /**
   * Get a buffer value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public io.vertx.reactivex.core.buffer.Buffer getBuffer(String name) { 
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(name));
    return ret;
  }

  /**
   * Get a temporal value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Temporal getTemporal(String name) { 
    Temporal ret = delegate.getTemporal(name);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDate} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public LocalDate getLocalDate(String name) { 
    LocalDate ret = delegate.getLocalDate(name);
    return ret;
  }

  /**
   * Get {@link java.time.LocalTime} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public LocalTime getLocalTime(String name) { 
    LocalTime ret = delegate.getLocalTime(name);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDateTime} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public LocalDateTime getLocalDateTime(String name) { 
    LocalDateTime ret = delegate.getLocalDateTime(name);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetTime} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public OffsetTime getOffsetTime(String name) { 
    OffsetTime ret = delegate.getOffsetTime(name);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetDateTime} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public OffsetDateTime getOffsetDateTime(String name) { 
    OffsetDateTime ret = delegate.getOffsetDateTime(name);
    return ret;
  }

  /**
   * Get {@link java.util.UUID} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public UUID getUUID(String name) { 
    UUID ret = delegate.getUUID(name);
    return ret;
  }

  /**
   * Get  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public BigDecimal getBigDecimal(String name) { 
    BigDecimal ret = delegate.getBigDecimal(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Boolean} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Boolean[] getBooleanArray(String name) { 
    Boolean[] ret = delegate.getBooleanArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Short} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Short[] getShortArray(String name) { 
    Short[] ret = delegate.getShortArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Integer} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Integer[] getIntegerArray(String name) { 
    Integer[] ret = delegate.getIntegerArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Long} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Long[] getLongArray(String name) { 
    Long[] ret = delegate.getLongArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Float} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Float[] getFloatArray(String name) { 
    Float[] ret = delegate.getFloatArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Double} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Double[] getDoubleArray(String name) { 
    Double[] ret = delegate.getDoubleArray(name);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.String} value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public String[] getStringArray(String name) { 
    String[] ret = delegate.getStringArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public Temporal[] getTemporalArray(String name) { 
    Temporal[] ret = delegate.getTemporalArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public LocalDate[] getLocalDateArray(String name) { 
    LocalDate[] ret = delegate.getLocalDateArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public LocalTime[] getLocalTimeArray(String name) { 
    LocalTime[] ret = delegate.getLocalTimeArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public LocalDateTime[] getLocalDateTimeArray(String name) { 
    LocalDateTime[] ret = delegate.getLocalDateTimeArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public OffsetTime[] getOffsetTimeArray(String name) { 
    OffsetTime[] ret = delegate.getOffsetTimeArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public OffsetDateTime[] getOffsetDateTimeArray(String name) { 
    OffsetDateTime[] ret = delegate.getOffsetDateTimeArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public UUID[] getUUIDArray(String name) { 
    UUID[] ret = delegate.getUUIDArray(name);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param name the column
   * @return the value or <code>null</code>
   */
  public BigDecimal[] getBigDecimalArray(String name) { 
    BigDecimal[] ret = delegate.getBigDecimalArray(name);
    return ret;
  }

  /**
   * The JSON null literal value.
   * <br/>
   * It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
   * used when the database supports JSON types.
   */
  public static final Object JSON_NULL = (Object) io.vertx.sqlclient.Row.JSON_NULL;
  public static Row newInstance(io.vertx.sqlclient.Row arg) {
    return arg != null ? new Row(arg) : null;
  }

}
