/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * Defines the client operations with a database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.SqlClient.class)
public class SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlClient that = (SqlClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SqlClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SqlClient((io.vertx.sqlclient.SqlClient) obj),
    SqlClient::getDelegate
  );

  private final io.vertx.sqlclient.SqlClient delegate;
  
  public SqlClient(io.vertx.sqlclient.SqlClient delegate) {
    this.delegate = delegate;
  }

  public SqlClient(Object delegate) {
    this.delegate = (io.vertx.sqlclient.SqlClient)delegate;
  }

  public io.vertx.sqlclient.SqlClient getDelegate() {
    return delegate;
  }

  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_0 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_1 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  /**
   * Create a query, the {@link io.vertx.reactivex.sqlclient.Query#execute} method must be called to execute the query.
   * @param sql 
   * @return the query
   */
  public io.vertx.reactivex.sqlclient.Query<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> query(String sql) { 
    io.vertx.reactivex.sqlclient.Query<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = io.vertx.reactivex.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.query(sql), TYPE_ARG_0);
    return ret;
  }

  /**
   * Create a prepared query, one of the {@link io.vertx.reactivex.sqlclient.Query#execute} or {@link io.vertx.reactivex.sqlclient.PreparedQuery#executeBatch}
   * methods must be called to execute the query.
   * @param sql 
   * @return the prepared query
   */
  public io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> preparedQuery(String sql) { 
    io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = io.vertx.reactivex.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.preparedQuery(sql), TYPE_ARG_1);
    return ret;
  }

  /**
   * Close the client and release the associated resources.
   */
  public void close() { 
    delegate.close();
  }

  public static SqlClient newInstance(io.vertx.sqlclient.SqlClient arg) {
    return arg != null ? new SqlClient(arg) : null;
  }

}
