/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A connection to database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlConnection original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection extends io.vertx.reactivex.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlConnection that = (SqlConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SqlConnection> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection) obj),
    SqlConnection::getDelegate
  );

  private final io.vertx.sqlclient.SqlConnection delegate;
  
  public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public SqlConnection(Object delegate) {
    super((io.vertx.sqlclient.SqlConnection)delegate);
    this.delegate = (io.vertx.sqlclient.SqlConnection)delegate;
  }

  public io.vertx.sqlclient.SqlConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a prepared query.
   * @param sql the sql
   * @param handler the handler notified with the prepared query asynchronously
   * @return 
   */
  public io.vertx.reactivex.sqlclient.SqlConnection prepare(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Create a prepared query.
   * @param sql the sql
   * @return 
   */
  public Single<io.vertx.reactivex.sqlclient.PreparedStatement> rxPrepare(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      prepare(sql, handler);
    });
  }

  /**
   * Set an handler called with connection errors.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlConnection exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set an handler called when the connection is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlConnection closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Begin a transaction and returns a {@link io.vertx.reactivex.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   * @return the transaction instance
   */
  public io.vertx.reactivex.sqlclient.Transaction begin() { 
    io.vertx.reactivex.sqlclient.Transaction ret = io.vertx.reactivex.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)delegate.begin());
    return ret;
  }

  /**
   * @return whether the connection uses SSL
   */
  public boolean isSSL() { 
    boolean ret = delegate.isSSL();
    return ret;
  }

  /**
   * Close the current connection after all the pending commands have been processed.
   */
  public void close() { 
    delegate.close();
  }

  public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
    return arg != null ? new SqlConnection(arg) : null;
  }

}
