/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A transaction that allows to control the transaction and receive events.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Transaction original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.Transaction.class)
public class Transaction extends io.vertx.reactivex.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Transaction that = (Transaction) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Transaction> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Transaction((io.vertx.sqlclient.Transaction) obj),
    Transaction::getDelegate
  );

  private final io.vertx.sqlclient.Transaction delegate;
  
  public Transaction(io.vertx.sqlclient.Transaction delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Transaction(Object delegate) {
    super((io.vertx.sqlclient.Transaction)delegate);
    this.delegate = (io.vertx.sqlclient.Transaction)delegate;
  }

  public io.vertx.sqlclient.Transaction getDelegate() {
    return delegate;
  }

  /**
   * Create a prepared query.
   * @param sql the sql
   * @param handler the handler notified with the prepared query asynchronously
   * @return 
   */
  public io.vertx.reactivex.sqlclient.Transaction prepare(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Create a prepared query.
   * @param sql the sql
   * @return 
   */
  public Single<io.vertx.reactivex.sqlclient.PreparedStatement> rxPrepare(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      prepare(sql, handler);
    });
  }

  /**
   * Commit the current transaction.
   */
  public void commit() { 
    delegate.commit();
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#commit} with an handler to be notified when the transaction commit has completed
   * @param handler 
   */
  public void commit(Handler<AsyncResult<Void>> handler) { 
    delegate.commit(handler);
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#commit} with an handler to be notified when the transaction commit has completed
   * @return 
   */
  public Completable rxCommit() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      commit(handler);
    });
  }

  /**
   * Rollback the current transaction.
   */
  public void rollback() { 
    delegate.rollback();
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#rollback} with an handler to be notified when the transaction rollback has completed
   * @param handler 
   */
  public void rollback(Handler<AsyncResult<Void>> handler) { 
    delegate.rollback(handler);
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Transaction#rollback} with an handler to be notified when the transaction rollback has completed
   * @return 
   */
  public Completable rxRollback() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      rollback(handler);
    });
  }

  /**
   * Set an handler to be called when the transaction is aborted.
   * @param handler the handler
   * @return 
   */
  public io.vertx.reactivex.sqlclient.Transaction abortHandler(Handler<Void> handler) { 
    delegate.abortHandler(handler);
    return this;
  }

  /**
   * Rollback the transaction and release the associated resources.
   */
  public void close() { 
    delegate.close();
  }

  public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
    return arg != null ? new Transaction(arg) : null;
  }

}
