/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.eventbus;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a stream of message that can be written to.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageProducer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T> implements io.vertx.reactivex.core.streams.WriteStream<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageProducer that = (MessageProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MessageProducer> __TYPE_ARG = new TypeArg<>(    obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer) obj),
    MessageProducer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageProducer<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public MessageProducer(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.eventbus.MessageProducer)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.eventbus.MessageProducer getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<T> observer;
  private WriteStreamSubscriber<T> subscriber;

  public synchronized WriteStreamObserver<T> toObserver() {
    if (observer == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.unwrap;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<T> toSubscriber() {
    if (subscriber == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.unwrap;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Same as {@link io.vertx.reactivex.core.eventbus.MessageProducer#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(T data) { 
    delegate.end(__typeArg_0.<T>unwrap(data));
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Completable rxEnd(T data) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.core.eventbus.MessageProducer#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * This method actually sends a message using the send semantic regardless this producer
   * is a sender or a publisher.
   * @param message the message to send
   * @return reference to this for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.core.eventbus.MessageProducer<T> send(T message) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.send(__typeArg_0.<T>unwrap(message)), __typeArg_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.MessageProducer#send} but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * @param message the message to send
   * @param replyHandler reply handler will be called when any reply from the recipient is received, may be <code>null</code>
   * @return reference to this for fluency
   */
  @Deprecated()
  public <R> io.vertx.reactivex.core.eventbus.MessageProducer<T> send(T message, Handler<AsyncResult<io.vertx.reactivex.core.eventbus.Message<R>>> replyHandler) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.send(__typeArg_0.<T>unwrap(message), new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    }), __typeArg_0);
    return ret;
  }

  public io.vertx.reactivex.core.eventbus.MessageProducer<T> exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageProducer<T> write(T data) { 
    delegate.write(__typeArg_0.<T>unwrap(data));
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageProducer<T> write(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(__typeArg_0.<T>unwrap(data), handler);
    return this;
  }

  public Completable rxWrite(T data) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      write(data, handler);
    });
  }

  public io.vertx.reactivex.core.eventbus.MessageProducer<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageProducer<T> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Update the delivery options of this producer.
   * @param options the new options
   * @return this producer object
   */
  public io.vertx.reactivex.core.eventbus.MessageProducer<T> deliveryOptions(io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.deliveryOptions(options);
    return this;
  }

  /**
   * @return The address to which the producer produces messages.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Closes the producer, calls {@link io.vertx.reactivex.core.eventbus.MessageProducer#close}
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Closes the producer, calls {@link io.vertx.reactivex.core.eventbus.MessageProducer#close}
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Closes the producer, calls {@link io.vertx.reactivex.core.eventbus.MessageProducer#close}
   * @return 
   */
  public Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      end(handler);
    });
  }

  /**
   * Closes the producer, this method should be called when the message producer is not used anymore.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Same as {@link io.vertx.reactivex.core.eventbus.MessageProducer#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.eventbus.MessageProducer#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Completable rxClose() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  public static final int DEFAULT_WRITE_QUEUE_MAX_SIZE = io.vertx.core.eventbus.MessageProducer.DEFAULT_WRITE_QUEUE_MAX_SIZE;
  public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
    return arg != null ? new MessageProducer<T>(arg) : null;
  }

  public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
  }

}
