/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AccessToken extension to the User interface
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.AccessToken original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken extends io.vertx.reactivex.ext.auth.User {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AccessToken that = (AccessToken) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AccessToken> __TYPE_ARG = new TypeArg<>(    obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken) obj),
    AccessToken::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.AccessToken delegate;
  
  public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public AccessToken(Object delegate) {
    super((io.vertx.ext.auth.oauth2.AccessToken)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.AccessToken)delegate;
  }

  public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
    return delegate;
  }

  /**
   * Check if the access token is expired or not.
   * @return 
   */
  public boolean expired() { 
    boolean ret = delegate.expired();
    return ret;
  }

  /**
   * The Access Token if present parsed as a JsonObject
   * @return JSON
   */
  public JsonObject accessToken() { 
    if (cached_0 != null) {
      return cached_0;
    }
    JsonObject ret = delegate.accessToken();
    cached_0 = ret;
    return ret;
  }

  /**
   * The Refresh Token if present parsed as a JsonObject
   * @return JSON
   */
  @Deprecated()
  public JsonObject refreshToken() { 
    if (cached_1 != null) {
      return cached_1;
    }
    JsonObject ret = delegate.refreshToken();
    cached_1 = ret;
    return ret;
  }

  /**
   * The Id Token if present parsed as a JsonObject
   * @return JSON
   */
  public JsonObject idToken() { 
    if (cached_2 != null) {
      return cached_2;
    }
    JsonObject ret = delegate.idToken();
    cached_2 = ret;
    return ret;
  }

  /**
   * The RAW String if available for the Access Token
   * @return String
   */
  public String opaqueAccessToken() { 
    String ret = delegate.opaqueAccessToken();
    return ret;
  }

  /**
   * The RAW String if available for the Refresh Token
   * @return String
   */
  public String opaqueRefreshToken() { 
    String ret = delegate.opaqueRefreshToken();
    return ret;
  }

  /**
   * The RAW String if available for the Id Token
   * @return String
   */
  public String opaqueIdToken() { 
    String ret = delegate.opaqueIdToken();
    return ret;
  }

  public String tokenType() { 
    String ret = delegate.tokenType();
    return ret;
  }

  public io.vertx.reactivex.ext.auth.oauth2.AccessToken setTrustJWT(boolean trust) { 
    delegate.setTrustJWT(trust);
    return this;
  }

  /**
   * Refresh the access token
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.oauth2.AccessToken refresh(Handler<AsyncResult<Void>> callback) { 
    delegate.refresh(callback);
    return this;
  }

  /**
   * Refresh the access token
   * @return 
   */
  public Completable rxRefresh() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      refresh(handler);
    });
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.oauth2.AccessToken revoke(String token_type, Handler<AsyncResult<Void>> callback) { 
    delegate.revoke(token_type, callback);
    return this;
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public Completable rxRevoke(String token_type) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      revoke(token_type, handler);
    });
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.oauth2.AccessToken logout(Handler<AsyncResult<Void>> callback) { 
    delegate.logout(callback);
    return this;
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @return 
   */
  public Completable rxLogout() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      logout(handler);
    });
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.oauth2.AccessToken introspect(Handler<AsyncResult<Void>> callback) { 
    delegate.introspect(callback);
    return this;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @return 
   */
  public Completable rxIntrospect() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      introspect(handler);
    });
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.oauth2.AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> callback) { 
    delegate.introspect(tokenType, callback);
    return this;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public Completable rxIntrospect(String tokenType) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      introspect(tokenType, handler);
    });
  }

  /**
   * Load the user info as per OIDC spec.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.oauth2.AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) { 
    delegate.userInfo(callback);
    return this;
  }

  /**
   * Load the user info as per OIDC spec.
   * @return 
   */
  public Single<JsonObject> rxUserInfo() { 
    return AsyncResultSingle.toSingle(handler -> {
      userInfo(handler);
    });
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.oauth2.AccessToken fetch(String resource, Handler<AsyncResult<io.vertx.reactivex.ext.auth.oauth2.OAuth2Response>> callback) { 
    delegate.fetch(resource, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
        if (ar.succeeded()) {
          callback.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.auth.oauth2.OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
        } else {
          callback.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @return 
   */
  public Single<io.vertx.reactivex.ext.auth.oauth2.OAuth2Response> rxFetch(String resource) { 
    return AsyncResultSingle.toSingle(handler -> {
      fetch(resource, handler);
    });
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.oauth2.AccessToken fetch(io.vertx.core.http.HttpMethod method, String resource, JsonObject headers, io.vertx.reactivex.core.buffer.Buffer payload, Handler<AsyncResult<io.vertx.reactivex.ext.auth.oauth2.OAuth2Response>> callback) { 
    delegate.fetch(method, resource, headers, payload.getDelegate(), new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
        if (ar.succeeded()) {
          callback.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.auth.oauth2.OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
        } else {
          callback.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @return 
   */
  public Single<io.vertx.reactivex.ext.auth.oauth2.OAuth2Response> rxFetch(io.vertx.core.http.HttpMethod method, String resource, JsonObject headers, io.vertx.reactivex.core.buffer.Buffer payload) { 
    return AsyncResultSingle.toSingle(handler -> {
      fetch(method, resource, headers, payload, handler);
    });
  }

  private JsonObject cached_0;
  private JsonObject cached_1;
  private JsonObject cached_2;
  public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
    return arg != null ? new AccessToken(arg) : null;
  }

}
