/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A container with the request's headers that are meaningful enough to be parsed
 * Contains:
 * <ul>
 * <li>Accept -> MIME header, parameters and sortable</li>
 * <li>Accept-Charset -> Parameters and sortable</li>
 * <li>Accept-Encoding -> Parameters and sortable</li>
 * <li>Accept-Language -> Parameters and sortable</li>
 * <li>Content-Type -> MIME header and parameters</li>
 * </ul>
 *
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.ParsedHeaderValues original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.ParsedHeaderValues.class)
public class ParsedHeaderValues {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParsedHeaderValues that = (ParsedHeaderValues) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ParsedHeaderValues> __TYPE_ARG = new TypeArg<>(    obj -> new ParsedHeaderValues((io.vertx.ext.web.ParsedHeaderValues) obj),
    ParsedHeaderValues::getDelegate
  );

  private final io.vertx.ext.web.ParsedHeaderValues delegate;
  
  public ParsedHeaderValues(io.vertx.ext.web.ParsedHeaderValues delegate) {
    this.delegate = delegate;
  }

  public ParsedHeaderValues(Object delegate) {
    this.delegate = (io.vertx.ext.web.ParsedHeaderValues)delegate;
  }

  public io.vertx.ext.web.ParsedHeaderValues getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.MIMEHeader> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.MIMEHeader>(o1 -> io.vertx.reactivex.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.web.ParsedHeaderValue> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.ext.web.ParsedHeaderValue>(o1 -> io.vertx.reactivex.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.web.ParsedHeaderValue> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.ext.web.ParsedHeaderValue>(o1 -> io.vertx.reactivex.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.web.LanguageHeader> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.ext.web.LanguageHeader>(o1 -> io.vertx.reactivex.ext.web.LanguageHeader.newInstance((io.vertx.ext.web.LanguageHeader)o1), o1 -> o1.getDelegate());

  /**
   * @return List of MIME values in the <code>Accept</code> header
   */
  public List<io.vertx.reactivex.ext.web.MIMEHeader> accept() { 
    List<io.vertx.reactivex.ext.web.MIMEHeader> ret = delegate.accept().stream().map(elt -> io.vertx.reactivex.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return List of charset values in the <code>Accept-Charset</code> header
   */
  public List<io.vertx.reactivex.ext.web.ParsedHeaderValue> acceptCharset() { 
    List<io.vertx.reactivex.ext.web.ParsedHeaderValue> ret = delegate.acceptCharset().stream().map(elt -> io.vertx.reactivex.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return List of encofing values in the <code>Accept-Encoding</code> header
   */
  public List<io.vertx.reactivex.ext.web.ParsedHeaderValue> acceptEncoding() { 
    List<io.vertx.reactivex.ext.web.ParsedHeaderValue> ret = delegate.acceptEncoding().stream().map(elt -> io.vertx.reactivex.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return List of languages in the <code>Accept-Language</code> header
   */
  public List<io.vertx.reactivex.ext.web.LanguageHeader> acceptLanguage() { 
    List<io.vertx.reactivex.ext.web.LanguageHeader> ret = delegate.acceptLanguage().stream().map(elt -> io.vertx.reactivex.ext.web.LanguageHeader.newInstance((io.vertx.ext.web.LanguageHeader)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return MIME value in the <code>Content-Type</code> header
   */
  public io.vertx.reactivex.ext.web.MIMEHeader contentType() { 
    io.vertx.reactivex.ext.web.MIMEHeader ret = io.vertx.reactivex.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)delegate.contentType());
    return ret;
  }

  public static ParsedHeaderValues newInstance(io.vertx.ext.web.ParsedHeaderValues arg) {
    return arg != null ? new ParsedHeaderValues(arg) : null;
  }

}
