/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery.types;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Service type for Redis data source.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.RedisDataSource original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.RedisDataSource.class)
public class RedisDataSource {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisDataSource that = (RedisDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisDataSource> __TYPE_ARG = new TypeArg<>(    obj -> new RedisDataSource((io.vertx.servicediscovery.types.RedisDataSource) obj),
    RedisDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.RedisDataSource delegate;
  
  public RedisDataSource(io.vertx.servicediscovery.types.RedisDataSource delegate) {
    this.delegate = delegate;
  }

  public RedisDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.RedisDataSource)delegate;
  }

  public io.vertx.servicediscovery.types.RedisDataSource getDelegate() {
    return delegate;
  }

  /**
   * Convenient method to create a record for a Redis data source.
   * @param name the service name
   * @param location the location of the service (e.g. url, port...)
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, JsonObject location, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.RedisDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.RedisClient}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param resultHandler The result handler
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<io.vertx.reactivex.redis.RedisClient>> resultHandler) { 
    io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.redis.RedisClient>>() {
      public void handle(AsyncResult<io.vertx.redis.RedisClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.RedisClient.newInstance((io.vertx.redis.RedisClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.RedisClient}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static Single<io.vertx.reactivex.redis.RedisClient> rxGetRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return AsyncResultSingle.toSingle(handler -> {
      getRedisClient(discovery, filter, handler);
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.RedisClient}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param resultHandler The result handler
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, Handler<AsyncResult<io.vertx.reactivex.redis.RedisClient>> resultHandler) { 
    io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.redis.RedisClient>>() {
      public void handle(AsyncResult<io.vertx.redis.RedisClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.RedisClient.newInstance((io.vertx.redis.RedisClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.RedisClient}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @return 
   */
  public static Single<io.vertx.reactivex.redis.RedisClient> rxGetRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return AsyncResultSingle.toSingle(handler -> {
      getRedisClient(discovery, filter, handler);
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.RedisClient}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration The additional consumer configuration
   * @param resultHandler The result handler
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration, Handler<AsyncResult<io.vertx.reactivex.redis.RedisClient>> resultHandler) { 
    io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.redis.RedisClient>>() {
      public void handle(AsyncResult<io.vertx.redis.RedisClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.RedisClient.newInstance((io.vertx.redis.RedisClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.RedisClient}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration The additional consumer configuration
   * @return 
   */
  public static Single<io.vertx.reactivex.redis.RedisClient> rxGetRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return AsyncResultSingle.toSingle(handler -> {
      getRedisClient(discovery, filter, consumerConfiguration, handler);
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.RedisClient}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param consumerConfiguration The additional consumer configuration
   * @param resultHandler The result handler
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration, Handler<AsyncResult<io.vertx.reactivex.redis.RedisClient>> resultHandler) { 
    io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.redis.RedisClient>>() {
      public void handle(AsyncResult<io.vertx.redis.RedisClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.RedisClient.newInstance((io.vertx.redis.RedisClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.RedisClient}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param consumerConfiguration The additional consumer configuration
   * @return 
   */
  public static Single<io.vertx.reactivex.redis.RedisClient> rxGetRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration) { 
    return AsyncResultSingle.toSingle(handler -> {
      getRedisClient(discovery, filter, consumerConfiguration, handler);
    });
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.RedisDataSource.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.RedisDataSource.TYPE;
  public static RedisDataSource newInstance(io.vertx.servicediscovery.types.RedisDataSource arg) {
    return arg != null ? new RedisDataSource(arg) : null;
  }

}
