/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A  for  consumption.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraRowStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.CassandraRowStream.class)
public class CassandraRowStream implements io.vertx.reactivex.core.streams.ReadStream<com.datastax.driver.core.Row> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraRowStream that = (CassandraRowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CassandraRowStream> __TYPE_ARG = new TypeArg<>(    obj -> new CassandraRowStream((io.vertx.cassandra.CassandraRowStream) obj),
    CassandraRowStream::getDelegate
  );

  private final io.vertx.cassandra.CassandraRowStream delegate;
  
  public CassandraRowStream(io.vertx.cassandra.CassandraRowStream delegate) {
    this.delegate = delegate;
  }

  public CassandraRowStream(Object delegate) {
    this.delegate = (io.vertx.cassandra.CassandraRowStream)delegate;
  }

  public io.vertx.cassandra.CassandraRowStream getDelegate() {
    return delegate;
  }

  private Observable<com.datastax.driver.core.Row> observable;
  private Flowable<com.datastax.driver.core.Row> flowable;

  public synchronized Observable<com.datastax.driver.core.Row> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized Flowable<com.datastax.driver.core.Row> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<com.datastax.driver.core.Row> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<com.datastax.driver.core.Row> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<com.datastax.driver.core.Row> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<com.datastax.driver.core.Row> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<com.datastax.driver.core.Row> dst) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream endHandler(Handler<Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream fetch(long l) { 
    delegate.fetch(l);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream handler(Handler<com.datastax.driver.core.Row> handler) { 
    delegate.handler(handler);
    return this;
  }

  public static CassandraRowStream newInstance(io.vertx.cassandra.CassandraRowStream arg) {
    return arg != null ? new CassandraRowStream(arg) : null;
  }

}
