/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.jdbc;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating {@link io.vertx.reactivex.ext.auth.AuthProvider} instances that use the Vert.x JDBC client.
 *
 * By default the hashing strategy is SHA-512. If you're already running in production this is backwards
 * compatible, however for new deployments or security upgrades it is recommended to use the PBKDF2 strategy
 * as it is the current OWASP recommendation for password storage.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jdbc.JDBCAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.jdbc.JDBCAuth.class)
public class JDBCAuth extends io.vertx.reactivex.ext.auth.AuthProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCAuth that = (JDBCAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCAuth> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCAuth((io.vertx.ext.auth.jdbc.JDBCAuth) obj),
    JDBCAuth::getDelegate
  );

  private final io.vertx.ext.auth.jdbc.JDBCAuth delegate;
  
  public JDBCAuth(io.vertx.ext.auth.jdbc.JDBCAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCAuth(Object delegate) {
    super((io.vertx.ext.auth.jdbc.JDBCAuth)delegate);
    this.delegate = (io.vertx.ext.auth.jdbc.JDBCAuth)delegate;
  }

  public io.vertx.ext.auth.jdbc.JDBCAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a JDBC auth provider implementation
   * @param vertx 
   * @param client the JDBC client instance
   * @return the auth provider
   */
  public static io.vertx.reactivex.ext.auth.jdbc.JDBCAuth create(io.vertx.reactivex.core.Vertx vertx, io.vertx.reactivex.ext.jdbc.JDBCClient client) { 
    io.vertx.reactivex.ext.auth.jdbc.JDBCAuth ret = io.vertx.reactivex.ext.auth.jdbc.JDBCAuth.newInstance((io.vertx.ext.auth.jdbc.JDBCAuth)io.vertx.ext.auth.jdbc.JDBCAuth.create(vertx.getDelegate(), client.getDelegate()));
    return ret;
  }

  /**
   * Set the authentication query to use. Use this if you want to override the default authentication query.
   * @param authenticationQuery the authentication query
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.auth.jdbc.JDBCAuth setAuthenticationQuery(String authenticationQuery) { 
    delegate.setAuthenticationQuery(authenticationQuery);
    return this;
  }

  /**
   * Set the roles query to use. Use this if you want to override the default roles query.
   * @param rolesQuery the roles query
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.auth.jdbc.JDBCAuth setRolesQuery(String rolesQuery) { 
    delegate.setRolesQuery(rolesQuery);
    return this;
  }

  /**
   * Set the permissions query to use. Use this if you want to override the default permissions query.
   * @param permissionsQuery the permissions query
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.auth.jdbc.JDBCAuth setPermissionsQuery(String permissionsQuery) { 
    delegate.setPermissionsQuery(permissionsQuery);
    return this;
  }

  /**
   * Set the role prefix to distinguish from permissions when checking for isPermitted requests.
   * @param rolePrefix a Prefix e.g.: "role:"
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.auth.jdbc.JDBCAuth setRolePrefix(String rolePrefix) { 
    delegate.setRolePrefix(rolePrefix);
    return this;
  }

  /**
   * Compute the hashed password given the unhashed password and the salt without nonce
   *
   * The implementation relays to the JDBCHashStrategy provided.
   * @param password the unhashed password
   * @param salt the salt
   * @return the hashed password
   */
  public String computeHash(String password, String salt) { 
    String ret = delegate.computeHash(password, salt);
    return ret;
  }

  /**
   * Compute the hashed password given the unhashed password and the salt
   *
   * The implementation relays to the JDBCHashStrategy provided.
   * @param password the unhashed password
   * @param salt the salt
   * @param version the nonce version to use
   * @return the hashed password
   */
  public String computeHash(String password, String salt, int version) { 
    String ret = delegate.computeHash(password, salt, version);
    return ret;
  }

  /**
   * Compute a salt string.
   *
   * The implementation relays to the JDBCHashStrategy provided.
   * @return a non null salt value
   */
  public String generateSalt() { 
    String ret = delegate.generateSalt();
    return ret;
  }

  /**
   * Provide a application configuration level on hash nonce's as a ordered list of
   * nonces where each position corresponds to a version.
   *
   * The nonces are supposed not to be stored in the underlying jdbc storage but to
   * be provided as a application configuration. The idea is to add one extra variable
   * to the hash function in order to make breaking the passwords using rainbow tables
   * or precomputed hashes harder. Leaving the attacker only with the brute force
   * approach.
   *
   * The implementation relays to the JDBCHashStrategy provided.
   * @param nonces a List of non null Strings.
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.auth.jdbc.JDBCAuth setNonces(JsonArray nonces) { 
    delegate.setNonces(nonces);
    return this;
  }

  /**
   * The default query to be used for authentication
   */
  public static final String DEFAULT_AUTHENTICATE_QUERY = io.vertx.ext.auth.jdbc.JDBCAuth.DEFAULT_AUTHENTICATE_QUERY;
  /**
   * The default query to retrieve all roles for the user
   */
  public static final String DEFAULT_ROLES_QUERY = io.vertx.ext.auth.jdbc.JDBCAuth.DEFAULT_ROLES_QUERY;
  /**
   * The default query to retrieve all permissions for the role
   */
  public static final String DEFAULT_PERMISSIONS_QUERY = io.vertx.ext.auth.jdbc.JDBCAuth.DEFAULT_PERMISSIONS_QUERY;
  /**
   * The default role prefix
   */
  public static final String DEFAULT_ROLE_PREFIX = io.vertx.ext.auth.jdbc.JDBCAuth.DEFAULT_ROLE_PREFIX;
  public static JDBCAuth newInstance(io.vertx.ext.auth.jdbc.JDBCAuth arg) {
    return arg != null ? new JDBCAuth(arg) : null;
  }

}
