/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.mongo;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An extension of AuthProvider which is using  as store
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.MongoAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.mongo.MongoAuth.class)
public class MongoAuth extends io.vertx.reactivex.ext.auth.AuthProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoAuth that = (MongoAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoAuth> __TYPE_ARG = new TypeArg<>(    obj -> new MongoAuth((io.vertx.ext.auth.mongo.MongoAuth) obj),
    MongoAuth::getDelegate
  );

  private final io.vertx.ext.auth.mongo.MongoAuth delegate;
  
  public MongoAuth(io.vertx.ext.auth.mongo.MongoAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MongoAuth(Object delegate) {
    super((io.vertx.ext.auth.mongo.MongoAuth)delegate);
    this.delegate = (io.vertx.ext.auth.mongo.MongoAuth)delegate;
  }

  public io.vertx.ext.auth.mongo.MongoAuth getDelegate() {
    return delegate;
  }

  /**
   * Creates an instance of MongoAuth by using the given  and configuration object. An example for a
   * configuration object:
   *
   * <pre>
   * JsonObject js = new JsonObject();
   * js.put(MongoAuth.PROPERTY_COLLECTION_NAME, createCollectionName(MongoAuth.DEFAULT_COLLECTION_NAME));
   * </pre>
   * @param mongoClient an instance of  to be used for data storage and retrival
   * @param config the configuration object for the current instance. By this
   * @return the created instance of {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}s
   */
  public static io.vertx.reactivex.ext.auth.mongo.MongoAuth create(io.vertx.reactivex.ext.mongo.MongoClient mongoClient, JsonObject config) { 
    io.vertx.reactivex.ext.auth.mongo.MongoAuth ret = io.vertx.reactivex.ext.auth.mongo.MongoAuth.newInstance((io.vertx.ext.auth.mongo.MongoAuth)io.vertx.ext.auth.mongo.MongoAuth.create(mongoClient.getDelegate(), config));
    return ret;
  }

  /**
   * Set the name of the collection to be used. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @param collectionName the name of the collection to be used for storing and reading user data
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setCollectionName(String collectionName) { 
    delegate.setCollectionName(collectionName);
    return this;
  }

  /**
   * Set the name of the field to be used for the username. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setUsernameField(String fieldName) { 
    delegate.setUsernameField(fieldName);
    return this;
  }

  /**
   * Set the name of the field to be used for the password Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setPasswordField(String fieldName) { 
    delegate.setPasswordField(fieldName);
    return this;
  }

  /**
   * Set the name of the field to be used for the roles. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}. Roles are expected to
   * be saved as JsonArray
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setRoleField(String fieldName) { 
    delegate.setRoleField(fieldName);
    return this;
  }

  /**
   * Set the name of the field to be used for the permissions. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}.
   * Permissions are expected to be saved as JsonArray
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setPermissionField(String fieldName) { 
    delegate.setPermissionField(fieldName);
    return this;
  }

  /**
   * Set the name of the field to be used as property for the username in the method
   * {@link io.vertx.reactivex.ext.auth.AuthProvider#authenticate}. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setUsernameCredentialField(String fieldName) { 
    delegate.setUsernameCredentialField(fieldName);
    return this;
  }

  /**
   * Set the name of the field to be used as property for the password of credentials in the method
   * {@link io.vertx.reactivex.ext.auth.AuthProvider#authenticate}. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setPasswordCredentialField(String fieldName) { 
    delegate.setPasswordCredentialField(fieldName);
    return this;
  }

  /**
   * Set the name of the field to be used for the salt. Only used when {@link io.vertx.reactivex.ext.auth.mongo.HashStrategy#setSaltStyle} is
   * set to 
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setSaltField(String fieldName) { 
    delegate.setSaltField(fieldName);
    return this;
  }

  /**
   * The name of the collection used to store User objects inside. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @return the collectionName
   */
  public String getCollectionName() { 
    String ret = delegate.getCollectionName();
    return ret;
  }

  /**
   * Get the name of the field to be used for the username. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @return the usernameField
   */
  public String getUsernameField() { 
    String ret = delegate.getUsernameField();
    return ret;
  }

  /**
   * Get the name of the field to be used for the password Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @return the passwordField
   */
  public String getPasswordField() { 
    String ret = delegate.getPasswordField();
    return ret;
  }

  /**
   * Get the name of the field to be used for the roles. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}. Roles are expected to
   * be saved as JsonArray
   * @return the roleField
   */
  public String getRoleField() { 
    String ret = delegate.getRoleField();
    return ret;
  }

  /**
   * Get the name of the field to be used for the permissions. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}.
   * Permissions are expected to be saved as JsonArray
   * @return the permissionField
   */
  public String getPermissionField() { 
    String ret = delegate.getPermissionField();
    return ret;
  }

  /**
   * Get the name of the field to be used as property for the username in the method
   * {@link io.vertx.reactivex.ext.auth.AuthProvider#authenticate}. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @return the usernameCredentialField
   */
  public String getUsernameCredentialField() { 
    String ret = delegate.getUsernameCredentialField();
    return ret;
  }

  /**
   * Get the name of the field to be used as property for the password of credentials in the method
   * {@link io.vertx.reactivex.ext.auth.AuthProvider#authenticate}. Defaults to {@link io.vertx.reactivex.ext.auth.mongo.MongoAuth}
   * @return the passwordCredentialField
   */
  public String getPasswordCredentialField() { 
    String ret = delegate.getPasswordCredentialField();
    return ret;
  }

  /**
   * Get the name of the field to be used for the salt. Only used when {@link io.vertx.reactivex.ext.auth.mongo.HashStrategy#setSaltStyle} is
   * set to 
   * @return the saltField
   */
  public String getSaltField() { 
    String ret = delegate.getSaltField();
    return ret;
  }

  /**
   * The HashStrategy which is used by the current instance
   * @param hashStrategy the {@link io.vertx.reactivex.ext.auth.mongo.HashStrategy} to be set
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setHashStrategy(io.vertx.reactivex.ext.auth.mongo.HashStrategy hashStrategy) { 
    delegate.setHashStrategy(hashStrategy.getDelegate());
    return this;
  }

  /**
   * The HashStrategy which is used by the current instance
   * @return the defined instance of {@link io.vertx.reactivex.ext.auth.mongo.HashStrategy}
   */
  public io.vertx.reactivex.ext.auth.mongo.HashStrategy getHashStrategy() { 
    io.vertx.reactivex.ext.auth.mongo.HashStrategy ret = io.vertx.reactivex.ext.auth.mongo.HashStrategy.newInstance((io.vertx.ext.auth.mongo.HashStrategy)delegate.getHashStrategy());
    return ret;
  }

  /**
   * The Hash Algorithm which is used by the current instance
   * @param hashAlgorithm the {@link io.vertx.ext.auth.mongo.HashAlgorithm} to be set
   * @return the current instance itself for fluent calls
   */
  public io.vertx.reactivex.ext.auth.mongo.MongoAuth setHashAlgorithm(io.vertx.ext.auth.mongo.HashAlgorithm hashAlgorithm) { 
    delegate.setHashAlgorithm(hashAlgorithm);
    return this;
  }

  /**
   * Insert a new user into mongo in the convenient way
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined {@link io.vertx.reactivex.ext.auth.mongo.HashStrategy}
   * @param roles a list of roles to be set
   * @param permissions a list of permissions to be set
   * @param resultHandler the ResultHandler will be provided with the id of the generated record
   */
  public void insertUser(String username, String password, List<String> roles, List<String> permissions, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insertUser(username, password, roles, permissions, resultHandler);
  }

  /**
   * Insert a new user into mongo in the convenient way
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined {@link io.vertx.reactivex.ext.auth.mongo.HashStrategy}
   * @param roles a list of roles to be set
   * @param permissions a list of permissions to be set
   * @return 
   */
  public Single<String> rxInsertUser(String username, String password, List<String> roles, List<String> permissions) { 
    return AsyncResultSingle.toSingle(handler -> {
      insertUser(username, password, roles, permissions, handler);
    });
  }

  /**
   * The property name to be used to set the name of the collection inside the config
   */
  public static final String PROPERTY_COLLECTION_NAME = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_COLLECTION_NAME;
  /**
   * The property name to be used to set the name of the field, where the username is stored inside
   */
  public static final String PROPERTY_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_USERNAME_FIELD;
  /**
   * The property name to be used to set the name of the field, where the roles are stored inside
   */
  public static final String PROPERTY_ROLE_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_ROLE_FIELD;
  /**
   * The property name to be used to set the name of the field, where the permissions are stored inside
   */
  public static final String PROPERTY_PERMISSION_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_PERMISSION_FIELD;
  /**
   * The property name to be used to set the name of the field, where the password is stored inside
   */
  public static final String PROPERTY_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_PASSWORD_FIELD;
  /**
   * The property name to be used to set the name of the field, where the username for the credentials is stored inside
   */
  public static final String PROPERTY_CREDENTIAL_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_CREDENTIAL_USERNAME_FIELD;
  /**
   * The property name to be used to set the name of the field, where the password for the credentials is stored inside
   */
  public static final String PROPERTY_CREDENTIAL_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_CREDENTIAL_PASSWORD_FIELD;
  /**
   * The property name to be used to set the name of the field, where the SALT is stored inside
   */
  public static final String PROPERTY_SALT_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_SALT_FIELD;
  /**
   * The property name to be used to set the name of the field, where the salt style is stored inside
   */
  public static final String PROPERTY_SALT_STYLE = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_SALT_STYLE;
  /**
   * The default name of the collection to be used
   */
  public static final String DEFAULT_COLLECTION_NAME = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_COLLECTION_NAME;
  /**
   * The default name of the property for the username, like it is stored in mongodb
   */
  public static final String DEFAULT_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_USERNAME_FIELD;
  /**
   * The default name of the property for the password, like it is stored in mongodb
   */
  public static final String DEFAULT_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_PASSWORD_FIELD;
  /**
   * The default name of the property for the roles, like it is stored in mongodb. Roles are expected to be saved as
   * JsonArray
   */
  public static final String DEFAULT_ROLE_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_ROLE_FIELD;
  /**
   * The default name of the property for the permissions, like it is stored in mongodb. Permissions are expected to be
   * saved as JsonArray
   */
  public static final String DEFAULT_PERMISSION_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_PERMISSION_FIELD;
  /**
   * The default name of the property for the username, like it is transported in credentials by method
   * {@link io.vertx.reactivex.ext.auth.AuthProvider#authenticate}
   */
  public static final String DEFAULT_CREDENTIAL_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_CREDENTIAL_USERNAME_FIELD;
  /**
   * The default name of the property for the password, like it is transported in credentials by method
   * {@link io.vertx.reactivex.ext.auth.AuthProvider#authenticate}
   */
  public static final String DEFAULT_CREDENTIAL_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_CREDENTIAL_PASSWORD_FIELD;
  /**
   * The default name of the property for the salt field
   */
  public static final String DEFAULT_SALT_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_SALT_FIELD;
  /**
   * The prefix which is used by the method  when checking for role access
   */
  public static final String ROLE_PREFIX = io.vertx.ext.auth.mongo.MongoAuth.ROLE_PREFIX;
  public static MongoAuth newInstance(io.vertx.ext.auth.mongo.MongoAuth arg) {
    return arg != null ? new MongoAuth(arg) : null;
  }

}
