/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.consul;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x service used to interact with Consul.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ConsulClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.consul.ConsulClient.class)
public class ConsulClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsulClient that = (ConsulClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ConsulClient> __TYPE_ARG = new TypeArg<>(    obj -> new ConsulClient((io.vertx.ext.consul.ConsulClient) obj),
    ConsulClient::getDelegate
  );

  private final io.vertx.ext.consul.ConsulClient delegate;
  
  public ConsulClient(io.vertx.ext.consul.ConsulClient delegate) {
    this.delegate = delegate;
  }

  public ConsulClient(Object delegate) {
    this.delegate = (io.vertx.ext.consul.ConsulClient)delegate;
  }

  public io.vertx.ext.consul.ConsulClient getDelegate() {
    return delegate;
  }

  /**
   * Create a Consul client with default options.
   * @param vertx the Vert.x instance
   * @return the client
   */
  public static io.vertx.reactivex.ext.consul.ConsulClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Consul client.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.ext.consul.ConsulClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @param resultHandler will be provided with the configuration and member information of the local agent
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient agentInfo(Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.agentInfo(resultHandler);
    return this;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @return reference to this, for fluency
   */
  public Single<JsonObject> rxAgentInfo() { 
    return AsyncResultSingle.toSingle(handler -> {
      agentInfo(handler);
    });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @param resultHandler will be provided with network coordinates of nodes in datacenter
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateNodes(Handler<AsyncResult<io.vertx.ext.consul.CoordinateList>> resultHandler) { 
    delegate.coordinateNodes(resultHandler);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.CoordinateList> rxCoordinateNodes() { 
    return AsyncResultSingle.toSingle(handler -> {
      coordinateNodes(handler);
    });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @param resultHandler will be provided with network coordinates of nodes in datacenter
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.CoordinateList>> resultHandler) { 
    delegate.coordinateNodesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.CoordinateList> rxCoordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      coordinateNodesWithOptions(options, handler);
    });
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @param resultHandler will be provided with network coordinates for all Consul servers
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateDatacenters(Handler<AsyncResult<List<io.vertx.ext.consul.DcCoordinates>>> resultHandler) { 
    delegate.coordinateDatacenters(resultHandler);
    return this;
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @return reference to this, for fluency
   */
  public Single<List<io.vertx.ext.consul.DcCoordinates>> rxCoordinateDatacenters() { 
    return AsyncResultSingle.toSingle(handler -> {
      coordinateDatacenters(handler);
    });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param resultHandler will be provided with keys list
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getKeys(String keyPrefix, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeys(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public Single<List<String>> rxGetKeys(String keyPrefix) { 
    return AsyncResultSingle.toSingle(handler -> {
      getKeys(keyPrefix, handler);
    });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @param resultHandler will be provided with keys list
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getKeysWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeysWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<List<String>> rxGetKeysWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      getKeysWithOptions(keyPrefix, options, handler);
    });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @param resultHandler will be provided with key/value pair
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValue(String key, Handler<AsyncResult<io.vertx.ext.consul.KeyValue>> resultHandler) { 
    delegate.getValue(key, resultHandler);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.KeyValue> rxGetValue(String key) { 
    return AsyncResultSingle.toSingle(handler -> {
      getValue(key, handler);
    });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @param resultHandler will be provided with key/value pair
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValueWithOptions(String key, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.KeyValue>> resultHandler) { 
    delegate.getValueWithOptions(key, options, resultHandler);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.KeyValue> rxGetValueWithOptions(String key, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      getValueWithOptions(key, options, handler);
    });
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteValue(String key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValue(key, resultHandler);
    return this;
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @return reference to this, for fluency
   */
  public Completable rxDeleteValue(String key) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deleteValue(key, handler);
    });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @param resultHandler will be provided with list of key/value pairs
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValues(String keyPrefix, Handler<AsyncResult<io.vertx.ext.consul.KeyValueList>> resultHandler) { 
    delegate.getValues(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.KeyValueList> rxGetValues(String keyPrefix) { 
    return AsyncResultSingle.toSingle(handler -> {
      getValues(keyPrefix, handler);
    });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @param resultHandler will be provided with list of key/value pairs
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValuesWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.KeyValueList>> resultHandler) { 
    delegate.getValuesWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.KeyValueList> rxGetValuesWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      getValuesWithOptions(keyPrefix, options, handler);
    });
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteValues(String keyPrefix, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValues(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public Completable rxDeleteValues(String keyPrefix) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deleteValues(keyPrefix, handler);
    });
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @param resultHandler will be provided with success of operation
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient putValue(String key, String value, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValue(key, value, resultHandler);
    return this;
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @return reference to this, for fluency
   */
  public Single<Boolean> rxPutValue(String key, String value) { 
    return AsyncResultSingle.toSingle(handler -> {
      putValue(key, value, handler);
    });
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @param resultHandler will be provided with success of operation
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient putValueWithOptions(String key, String value, io.vertx.ext.consul.KeyValueOptions options, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValueWithOptions(key, value, options, resultHandler);
    return this;
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return reference to this, for fluency
   */
  public Single<Boolean> rxPutValueWithOptions(String key, String value, io.vertx.ext.consul.KeyValueOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      putValueWithOptions(key, value, options, handler);
    });
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @param resultHandler will be provided with result of transaction
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient transaction(io.vertx.ext.consul.TxnRequest request, Handler<AsyncResult<io.vertx.ext.consul.TxnResponse>> resultHandler) { 
    delegate.transaction(request, resultHandler);
    return this;
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.TxnResponse> rxTransaction(io.vertx.ext.consul.TxnRequest request) { 
    return AsyncResultSingle.toSingle(handler -> {
      transaction(request, handler);
    });
  }

  /**
   * Create new Acl token
   * @param token properties of the token
   * @param idHandler will be provided with ID of created token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createAclToken(io.vertx.ext.consul.AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.createAclToken(token, idHandler);
    return this;
  }

  /**
   * Create new Acl token
   * @param token properties of the token
   * @return reference to this, for fluency
   */
  public Single<String> rxCreateAclToken(io.vertx.ext.consul.AclToken token) { 
    return AsyncResultSingle.toSingle(handler -> {
      createAclToken(token, handler);
    });
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @param idHandler will be provided with ID of updated
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateAclToken(io.vertx.ext.consul.AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.updateAclToken(token, idHandler);
    return this;
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @return reference to this, for fluency
   */
  public Single<String> rxUpdateAclToken(io.vertx.ext.consul.AclToken token) { 
    return AsyncResultSingle.toSingle(handler -> {
      updateAclToken(token, handler);
    });
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @param idHandler will be provided with ID of cloned token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient cloneAclToken(String id, Handler<AsyncResult<String>> idHandler) { 
    delegate.cloneAclToken(id, idHandler);
    return this;
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @return reference to this, for fluency
   */
  public Single<String> rxCloneAclToken(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      cloneAclToken(id, handler);
    });
  }

  /**
   * Get list of Acl token
   * @param resultHandler will be provided with list of tokens
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listAclTokens(Handler<AsyncResult<List<io.vertx.ext.consul.AclToken>>> resultHandler) { 
    delegate.listAclTokens(resultHandler);
    return this;
  }

  /**
   * Get list of Acl token
   * @return reference to this, for fluency
   */
  public Single<List<io.vertx.ext.consul.AclToken>> rxListAclTokens() { 
    return AsyncResultSingle.toSingle(handler -> {
      listAclTokens(handler);
    });
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @param tokenHandler will be provided with token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoAclToken(String id, Handler<AsyncResult<io.vertx.ext.consul.AclToken>> tokenHandler) { 
    delegate.infoAclToken(id, tokenHandler);
    return this;
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.AclToken> rxInfoAclToken(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      infoAclToken(id, handler);
    });
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient destroyAclToken(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroyAclToken(id, resultHandler);
    return this;
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @return reference to this, for fluency
   */
  public Completable rxDestroyAclToken(String id) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      destroyAclToken(id, handler);
    });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param resultHandler will be provided with properties of event
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient fireEvent(String name, Handler<AsyncResult<io.vertx.ext.consul.Event>> resultHandler) { 
    delegate.fireEvent(name, resultHandler);
    return this;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.Event> rxFireEvent(String name) { 
    return AsyncResultSingle.toSingle(handler -> {
      fireEvent(name, handler);
    });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @param resultHandler will be provided with properties of event
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient fireEventWithOptions(String name, io.vertx.ext.consul.EventOptions options, Handler<AsyncResult<io.vertx.ext.consul.Event>> resultHandler) { 
    delegate.fireEventWithOptions(name, options, resultHandler);
    return this;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.Event> rxFireEventWithOptions(String name, io.vertx.ext.consul.EventOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      fireEventWithOptions(name, options, handler);
    });
  }

  /**
   * Returns the most recent events known by the agent
   * @param resultHandler will be provided with list of events
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listEvents(Handler<AsyncResult<io.vertx.ext.consul.EventList>> resultHandler) { 
    delegate.listEvents(resultHandler);
    return this;
  }

  /**
   * Returns the most recent events known by the agent
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.EventList> rxListEvents() { 
    return AsyncResultSingle.toSingle(handler -> {
      listEvents(handler);
    });
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @param resultHandler will be provided with list of events
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listEventsWithOptions(io.vertx.ext.consul.EventListOptions options, Handler<AsyncResult<io.vertx.ext.consul.EventList>> resultHandler) { 
    delegate.listEventsWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.EventList> rxListEventsWithOptions(io.vertx.ext.consul.EventListOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      listEventsWithOptions(options, handler);
    });
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerService(io.vertx.ext.consul.ServiceOptions serviceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerService(serviceOptions, resultHandler);
    return this;
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @return reference to this, for fluency
   */
  public Completable rxRegisterService(io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      registerService(serviceOptions, handler);
    });
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient maintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.maintenanceService(maintenanceOptions, resultHandler);
    return this;
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @return reference to this, for fluency
   */
  public Completable rxMaintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      maintenanceService(maintenanceOptions, handler);
    });
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterService(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterService(id, resultHandler);
    return this;
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @return reference to this, for fluency
   */
  public Completable rxDeregisterService(String id) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deregisterService(id, handler);
    });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param resultHandler will be provided with list of nodes providing given service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServiceNodes(String service, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServiceNodes(service, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.ServiceList> rxCatalogServiceNodes(String service) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogServiceNodes(service, handler);
    });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @param resultHandler will be provided with list of nodes providing given service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServiceNodesWithOptions(String service, io.vertx.ext.consul.ServiceQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServiceNodesWithOptions(service, options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.ServiceList> rxCatalogServiceNodesWithOptions(String service, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogServiceNodesWithOptions(service, options, handler);
    });
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @param resultHandler will be provided with list of datacenters
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogDatacenters(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.catalogDatacenters(resultHandler);
    return this;
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @return reference to this, for fluency
   */
  public Single<List<String>> rxCatalogDatacenters() { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogDatacenters(handler);
    });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param resultHandler will be provided with list of nodes
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodes(Handler<AsyncResult<io.vertx.ext.consul.NodeList>> resultHandler) { 
    delegate.catalogNodes(resultHandler);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.NodeList> rxCatalogNodes() { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogNodes(handler);
    });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @param resultHandler will be provided with list of nodes
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.NodeList>> resultHandler) { 
    delegate.catalogNodesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.NodeList> rxCatalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogNodesWithOptions(options, handler);
    });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthChecks(String service, Handler<AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthChecks(service, resultHandler);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.CheckList> rxHealthChecks(String service) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthChecks(service, handler);
    });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthChecksWithOptions(String service, io.vertx.ext.consul.CheckQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthChecksWithOptions(service, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.CheckList> rxHealthChecksWithOptions(String service, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthChecksWithOptions(service, options, handler);
    });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthState(io.vertx.ext.consul.HealthState healthState, Handler<AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthState(healthState, resultHandler);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.CheckList> rxHealthState(io.vertx.ext.consul.HealthState healthState) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthState(healthState, handler);
    });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthStateWithOptions(healthState, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.CheckList> rxHealthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthStateWithOptions(healthState, options, handler);
    });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthServiceNodes(String service, boolean passing, Handler<AsyncResult<io.vertx.ext.consul.ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodes(service, passing, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.ServiceEntryList> rxHealthServiceNodes(String service, boolean passing) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthServiceNodes(service, passing, handler);
    });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthServiceNodesWithOptions(String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.ServiceEntryList> rxHealthServiceNodesWithOptions(String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthServiceNodesWithOptions(service, passing, options, handler);
    });
  }

  /**
   * Returns the services registered in a datacenter
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServices(Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServices(resultHandler);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.ServiceList> rxCatalogServices() { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogServices(handler);
    });
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServicesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.ServiceList> rxCatalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogServicesWithOptions(options, handler);
    });
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodeServices(String node, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogNodeServices(node, resultHandler);
    return this;
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.ServiceList> rxCatalogNodeServices(String node) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogNodeServices(node, handler);
    });
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodeServicesWithOptions(String node, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogNodeServicesWithOptions(node, options, resultHandler);
    return this;
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.ServiceList> rxCatalogNodeServicesWithOptions(String node, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogNodeServicesWithOptions(node, options, handler);
    });
  }

  /**
   * Returns list of services registered with the local agent.
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient localServices(Handler<AsyncResult<List<io.vertx.ext.consul.Service>>> resultHandler) { 
    delegate.localServices(resultHandler);
    return this;
  }

  /**
   * Returns list of services registered with the local agent.
   * @return reference to this, for fluency
   */
  public Single<List<io.vertx.ext.consul.Service>> rxLocalServices() { 
    return AsyncResultSingle.toSingle(handler -> {
      localServices(handler);
    });
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient localChecks(Handler<AsyncResult<List<io.vertx.ext.consul.Check>>> resultHandler) { 
    delegate.localChecks(resultHandler);
    return this;
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @return reference to this, for fluency
   */
  public Single<List<io.vertx.ext.consul.Check>> rxLocalChecks() { 
    return AsyncResultSingle.toSingle(handler -> {
      localChecks(handler);
    });
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerCheck(io.vertx.ext.consul.CheckOptions checkOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerCheck(checkOptions, resultHandler);
    return this;
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @return reference to this, for fluency
   */
  public Completable rxRegisterCheck(io.vertx.ext.consul.CheckOptions checkOptions) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      registerCheck(checkOptions, handler);
    });
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public Completable rxDeregisterCheck(String checkId) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deregisterCheck(checkId, handler);
    });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient passCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public Completable rxPassCheck(String checkId) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      passCheck(checkId, handler);
    });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient passCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public Completable rxPassCheckWithNote(String checkId, String note) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      passCheckWithNote(checkId, note, handler);
    });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient warnCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public Completable rxWarnCheck(String checkId) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      warnCheck(checkId, handler);
    });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient warnCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public Completable rxWarnCheckWithNote(String checkId, String note) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      warnCheckWithNote(checkId, note, handler);
    });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient failCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public Completable rxFailCheck(String checkId) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      failCheck(checkId, handler);
    });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient failCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public Completable rxFailCheckWithNote(String checkId, String note) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      failCheckWithNote(checkId, note, handler);
    });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateCheck(String checkId, io.vertx.ext.consul.CheckStatus status, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheck(checkId, status, resultHandler);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @return reference to this, for fluency
   */
  public Completable rxUpdateCheck(String checkId, io.vertx.ext.consul.CheckStatus status) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      updateCheck(checkId, status, handler);
    });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateCheckWithNote(String checkId, io.vertx.ext.consul.CheckStatus status, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheckWithNote(checkId, status, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public Completable rxUpdateCheckWithNote(String checkId, io.vertx.ext.consul.CheckStatus status, String note) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      updateCheckWithNote(checkId, status, note, handler);
    });
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @param resultHandler will be provided with address of cluster leader
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient leaderStatus(Handler<AsyncResult<String>> resultHandler) { 
    delegate.leaderStatus(resultHandler);
    return this;
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @return reference to this, for fluency
   */
  public Single<String> rxLeaderStatus() { 
    return AsyncResultSingle.toSingle(handler -> {
      leaderStatus(handler);
    });
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @param resultHandler will be provided with list of peers
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient peersStatus(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.peersStatus(resultHandler);
    return this;
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @return reference to this, for fluency
   */
  public Single<List<String>> rxPeersStatus() { 
    return AsyncResultSingle.toSingle(handler -> {
      peersStatus(handler);
    });
  }

  /**
   * Initialize a new session
   * @param idHandler will be provided with ID of new session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createSession(Handler<AsyncResult<String>> idHandler) { 
    delegate.createSession(idHandler);
    return this;
  }

  /**
   * Initialize a new session
   * @return reference to this, for fluency
   */
  public Single<String> rxCreateSession() { 
    return AsyncResultSingle.toSingle(handler -> {
      createSession(handler);
    });
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @param idHandler will be provided with ID of new session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createSessionWithOptions(io.vertx.ext.consul.SessionOptions options, Handler<AsyncResult<String>> idHandler) { 
    delegate.createSessionWithOptions(options, idHandler);
    return this;
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @return reference to this, for fluency
   */
  public Single<String> rxCreateSessionWithOptions(io.vertx.ext.consul.SessionOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      createSessionWithOptions(options, handler);
    });
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @param resultHandler will be provided with info of requested session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoSession(String id, Handler<AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.infoSession(id, resultHandler);
    return this;
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.Session> rxInfoSession(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      infoSession(id, handler);
    });
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @param resultHandler will be provided with info of requested session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoSessionWithOptions(String id, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.infoSessionWithOptions(id, options, resultHandler);
    return this;
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.Session> rxInfoSessionWithOptions(String id, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      infoSessionWithOptions(id, options, handler);
    });
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @param resultHandler will be provided with info of renewed session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient renewSession(String id, Handler<AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.renewSession(id, resultHandler);
    return this;
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.Session> rxRenewSession(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      renewSession(id, handler);
    });
  }

  /**
   * Returns the active sessions
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listSessions(Handler<AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listSessions(resultHandler);
    return this;
  }

  /**
   * Returns the active sessions
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.SessionList> rxListSessions() { 
    return AsyncResultSingle.toSingle(handler -> {
      listSessions(handler);
    });
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listSessionsWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.SessionList> rxListSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      listSessionsWithOptions(options, handler);
    });
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listNodeSessions(String nodeId, Handler<AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listNodeSessions(nodeId, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.SessionList> rxListNodeSessions(String nodeId) { 
    return AsyncResultSingle.toSingle(handler -> {
      listNodeSessions(nodeId, handler);
    });
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listNodeSessionsWithOptions(String nodeId, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.SessionList> rxListNodeSessionsWithOptions(String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      listNodeSessionsWithOptions(nodeId, options, handler);
    });
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient destroySession(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroySession(id, resultHandler);
    return this;
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @return reference to this, for fluency
   */
  public Completable rxDestroySession(String id) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      destroySession(id, handler);
    });
  }

  /**
   * @param definition definition of the prepare query
   * @param resultHandler will be provided with id of created prepare query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createPreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition, Handler<AsyncResult<String>> resultHandler) { 
    delegate.createPreparedQuery(definition, resultHandler);
    return this;
  }

  /**
   * @param definition definition of the prepare query
   * @return reference to this, for fluency
   */
  public Single<String> rxCreatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return AsyncResultSingle.toSingle(handler -> {
      createPreparedQuery(definition, handler);
    });
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @param resultHandler will be provided with definition of the prepare query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getPreparedQuery(String id, Handler<AsyncResult<io.vertx.ext.consul.PreparedQueryDefinition>> resultHandler) { 
    delegate.getPreparedQuery(id, resultHandler);
    return this;
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.PreparedQueryDefinition> rxGetPreparedQuery(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      getPreparedQuery(id, handler);
    });
  }

  /**
   * Returns a list of all prepared queries.
   * @param resultHandler will be provided with list of definitions of the all prepare queries
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getAllPreparedQueries(Handler<AsyncResult<List<io.vertx.ext.consul.PreparedQueryDefinition>>> resultHandler) { 
    delegate.getAllPreparedQueries(resultHandler);
    return this;
  }

  /**
   * Returns a list of all prepared queries.
   * @return reference to this, for fluency
   */
  public Single<List<io.vertx.ext.consul.PreparedQueryDefinition>> rxGetAllPreparedQueries() { 
    return AsyncResultSingle.toSingle(handler -> {
      getAllPreparedQueries(handler);
    });
  }

  /**
   * @param definition definition of the prepare query
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updatePreparedQuery(definition, resultHandler);
    return this;
  }

  /**
   * @param definition definition of the prepare query
   * @return reference to this, for fluency
   */
  public Completable rxUpdatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      updatePreparedQuery(definition, handler);
    });
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deletePreparedQuery(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deletePreparedQuery(id, resultHandler);
    return this;
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @return reference to this, for fluency
   */
  public Completable rxDeletePreparedQuery(String id) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deletePreparedQuery(id, handler);
    });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient executePreparedQuery(String query, Handler<AsyncResult<io.vertx.ext.consul.PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQuery(query, resultHandler);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.PreparedQueryExecuteResponse> rxExecutePreparedQuery(String query) { 
    return AsyncResultSingle.toSingle(handler -> {
      executePreparedQuery(query, handler);
    });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient executePreparedQueryWithOptions(String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options, Handler<AsyncResult<io.vertx.ext.consul.PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQueryWithOptions(query, options, resultHandler);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return reference to this, for fluency
   */
  public Single<io.vertx.ext.consul.PreparedQueryExecuteResponse> rxExecutePreparedQueryWithOptions(String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      executePreparedQueryWithOptions(query, options, handler);
    });
  }

  /**
   * Close the client and release its resources
   */
  public void close() { 
    delegate.close();
  }

  public static ConsulClient newInstance(io.vertx.ext.consul.ConsulClient arg) {
    return arg != null ? new ConsulClient(arg) : null;
  }

}
