/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.consul;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.consul.ConsulService.class)
public class ConsulService extends io.vertx.reactivex.ext.consul.ConsulClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsulService that = (ConsulService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ConsulService> __TYPE_ARG = new TypeArg<>(    obj -> new ConsulService((io.vertx.ext.consul.ConsulService) obj),
    ConsulService::getDelegate
  );

  private final io.vertx.ext.consul.ConsulService delegate;
  
  public ConsulService(io.vertx.ext.consul.ConsulService delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ConsulService(Object delegate) {
    super((io.vertx.ext.consul.ConsulService)delegate);
    this.delegate = (io.vertx.ext.consul.ConsulService)delegate;
  }

  public io.vertx.ext.consul.ConsulService getDelegate() {
    return delegate;
  }

  /**
   * Create a proxy to a service that is deployed somewhere on the event bus
   * @param vertx the Vert.x instance
   * @param address the address the service is listening on on the event bus
   * @return the service
   */
  public static io.vertx.reactivex.ext.consul.ConsulService createEventBusProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.vertx.reactivex.ext.consul.ConsulService ret = io.vertx.reactivex.ext.consul.ConsulService.newInstance((io.vertx.ext.consul.ConsulService)io.vertx.ext.consul.ConsulService.createEventBusProxy(vertx.getDelegate(), address));
    return ret;
  }

  public io.vertx.reactivex.ext.consul.ConsulService agentInfo(Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.agentInfo(resultHandler);
    return this;
  }

  public Single<JsonObject> rxAgentInfo() { 
    return AsyncResultSingle.toSingle(handler -> {
      agentInfo(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService coordinateNodes(Handler<AsyncResult<io.vertx.ext.consul.CoordinateList>> resultHandler) { 
    delegate.coordinateNodes(resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.CoordinateList> rxCoordinateNodes() { 
    return AsyncResultSingle.toSingle(handler -> {
      coordinateNodes(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService coordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.CoordinateList>> resultHandler) { 
    delegate.coordinateNodesWithOptions(options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.CoordinateList> rxCoordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      coordinateNodesWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService coordinateDatacenters(Handler<AsyncResult<List<io.vertx.ext.consul.DcCoordinates>>> resultHandler) { 
    delegate.coordinateDatacenters(resultHandler);
    return this;
  }

  public Single<List<io.vertx.ext.consul.DcCoordinates>> rxCoordinateDatacenters() { 
    return AsyncResultSingle.toSingle(handler -> {
      coordinateDatacenters(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getKeys(String keyPrefix, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeys(keyPrefix, resultHandler);
    return this;
  }

  public Single<List<String>> rxGetKeys(String keyPrefix) { 
    return AsyncResultSingle.toSingle(handler -> {
      getKeys(keyPrefix, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getKeysWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeysWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  public Single<List<String>> rxGetKeysWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      getKeysWithOptions(keyPrefix, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getValue(String key, Handler<AsyncResult<io.vertx.ext.consul.KeyValue>> resultHandler) { 
    delegate.getValue(key, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.KeyValue> rxGetValue(String key) { 
    return AsyncResultSingle.toSingle(handler -> {
      getValue(key, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getValueWithOptions(String key, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.KeyValue>> resultHandler) { 
    delegate.getValueWithOptions(key, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.KeyValue> rxGetValueWithOptions(String key, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      getValueWithOptions(key, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deleteValue(String key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValue(key, resultHandler);
    return this;
  }

  public Completable rxDeleteValue(String key) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deleteValue(key, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getValues(String keyPrefix, Handler<AsyncResult<io.vertx.ext.consul.KeyValueList>> resultHandler) { 
    delegate.getValues(keyPrefix, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.KeyValueList> rxGetValues(String keyPrefix) { 
    return AsyncResultSingle.toSingle(handler -> {
      getValues(keyPrefix, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getValuesWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.KeyValueList>> resultHandler) { 
    delegate.getValuesWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.KeyValueList> rxGetValuesWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      getValuesWithOptions(keyPrefix, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deleteValues(String keyPrefix, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValues(keyPrefix, resultHandler);
    return this;
  }

  public Completable rxDeleteValues(String keyPrefix) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deleteValues(keyPrefix, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService putValue(String key, String value, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValue(key, value, resultHandler);
    return this;
  }

  public Single<Boolean> rxPutValue(String key, String value) { 
    return AsyncResultSingle.toSingle(handler -> {
      putValue(key, value, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService putValueWithOptions(String key, String value, io.vertx.ext.consul.KeyValueOptions options, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValueWithOptions(key, value, options, resultHandler);
    return this;
  }

  public Single<Boolean> rxPutValueWithOptions(String key, String value, io.vertx.ext.consul.KeyValueOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      putValueWithOptions(key, value, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService transaction(io.vertx.ext.consul.TxnRequest request, Handler<AsyncResult<io.vertx.ext.consul.TxnResponse>> resultHandler) { 
    delegate.transaction(request, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.TxnResponse> rxTransaction(io.vertx.ext.consul.TxnRequest request) { 
    return AsyncResultSingle.toSingle(handler -> {
      transaction(request, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService createAclToken(io.vertx.ext.consul.AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.createAclToken(token, idHandler);
    return this;
  }

  public Single<String> rxCreateAclToken(io.vertx.ext.consul.AclToken token) { 
    return AsyncResultSingle.toSingle(handler -> {
      createAclToken(token, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService updateAclToken(io.vertx.ext.consul.AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.updateAclToken(token, idHandler);
    return this;
  }

  public Single<String> rxUpdateAclToken(io.vertx.ext.consul.AclToken token) { 
    return AsyncResultSingle.toSingle(handler -> {
      updateAclToken(token, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService cloneAclToken(String id, Handler<AsyncResult<String>> idHandler) { 
    delegate.cloneAclToken(id, idHandler);
    return this;
  }

  public Single<String> rxCloneAclToken(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      cloneAclToken(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listAclTokens(Handler<AsyncResult<List<io.vertx.ext.consul.AclToken>>> resultHandler) { 
    delegate.listAclTokens(resultHandler);
    return this;
  }

  public Single<List<io.vertx.ext.consul.AclToken>> rxListAclTokens() { 
    return AsyncResultSingle.toSingle(handler -> {
      listAclTokens(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService infoAclToken(String id, Handler<AsyncResult<io.vertx.ext.consul.AclToken>> tokenHandler) { 
    delegate.infoAclToken(id, tokenHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.AclToken> rxInfoAclToken(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      infoAclToken(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService destroyAclToken(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroyAclToken(id, resultHandler);
    return this;
  }

  public Completable rxDestroyAclToken(String id) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      destroyAclToken(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService fireEvent(String name, Handler<AsyncResult<io.vertx.ext.consul.Event>> resultHandler) { 
    delegate.fireEvent(name, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.Event> rxFireEvent(String name) { 
    return AsyncResultSingle.toSingle(handler -> {
      fireEvent(name, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService fireEventWithOptions(String name, io.vertx.ext.consul.EventOptions options, Handler<AsyncResult<io.vertx.ext.consul.Event>> resultHandler) { 
    delegate.fireEventWithOptions(name, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.Event> rxFireEventWithOptions(String name, io.vertx.ext.consul.EventOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      fireEventWithOptions(name, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listEvents(Handler<AsyncResult<io.vertx.ext.consul.EventList>> resultHandler) { 
    delegate.listEvents(resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.EventList> rxListEvents() { 
    return AsyncResultSingle.toSingle(handler -> {
      listEvents(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listEventsWithOptions(io.vertx.ext.consul.EventListOptions options, Handler<AsyncResult<io.vertx.ext.consul.EventList>> resultHandler) { 
    delegate.listEventsWithOptions(options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.EventList> rxListEventsWithOptions(io.vertx.ext.consul.EventListOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      listEventsWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService registerService(io.vertx.ext.consul.ServiceOptions serviceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerService(serviceOptions, resultHandler);
    return this;
  }

  public Completable rxRegisterService(io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      registerService(serviceOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService maintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.maintenanceService(maintenanceOptions, resultHandler);
    return this;
  }

  public Completable rxMaintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      maintenanceService(maintenanceOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deregisterService(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterService(id, resultHandler);
    return this;
  }

  public Completable rxDeregisterService(String id) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deregisterService(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthChecks(String service, Handler<AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthChecks(service, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.CheckList> rxHealthChecks(String service) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthChecks(service, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthChecksWithOptions(String service, io.vertx.ext.consul.CheckQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.CheckList>> resultHandler) { 
    delegate.healthChecksWithOptions(service, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.CheckList> rxHealthChecksWithOptions(String service, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthChecksWithOptions(service, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthState(io.vertx.ext.consul.HealthState healthState, Handler<AsyncResult<io.vertx.ext.consul.CheckList>> handler) { 
    delegate.healthState(healthState, handler);
    return this;
  }

  public Single<io.vertx.ext.consul.CheckList> rxHealthState(io.vertx.ext.consul.HealthState healthState) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthState(healthState, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions checkQueryOptions, Handler<AsyncResult<io.vertx.ext.consul.CheckList>> handler) { 
    delegate.healthStateWithOptions(healthState, checkQueryOptions, handler);
    return this;
  }

  public Single<io.vertx.ext.consul.CheckList> rxHealthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions checkQueryOptions) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthStateWithOptions(healthState, checkQueryOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthServiceNodes(String service, boolean passing, Handler<AsyncResult<io.vertx.ext.consul.ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodes(service, passing, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.ServiceEntryList> rxHealthServiceNodes(String service, boolean passing) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthServiceNodes(service, passing, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService healthServiceNodesWithOptions(String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.ServiceEntryList> rxHealthServiceNodesWithOptions(String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      healthServiceNodesWithOptions(service, passing, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogServiceNodes(String service, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServiceNodes(service, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.ServiceList> rxCatalogServiceNodes(String service) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogServiceNodes(service, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogServiceNodesWithOptions(String service, io.vertx.ext.consul.ServiceQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServiceNodesWithOptions(service, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.ServiceList> rxCatalogServiceNodesWithOptions(String service, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogServiceNodesWithOptions(service, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogDatacenters(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.catalogDatacenters(resultHandler);
    return this;
  }

  public Single<List<String>> rxCatalogDatacenters() { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogDatacenters(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogNodes(Handler<AsyncResult<io.vertx.ext.consul.NodeList>> resultHandler) { 
    delegate.catalogNodes(resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.NodeList> rxCatalogNodes() { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogNodes(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.NodeList>> resultHandler) { 
    delegate.catalogNodesWithOptions(options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.NodeList> rxCatalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogNodesWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogServices(Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServices(resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.ServiceList> rxCatalogServices() { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogServices(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogServicesWithOptions(options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.ServiceList> rxCatalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogServicesWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService localServices(Handler<AsyncResult<List<io.vertx.ext.consul.Service>>> resultHandler) { 
    delegate.localServices(resultHandler);
    return this;
  }

  public Single<List<io.vertx.ext.consul.Service>> rxLocalServices() { 
    return AsyncResultSingle.toSingle(handler -> {
      localServices(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogNodeServices(String node, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogNodeServices(node, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.ServiceList> rxCatalogNodeServices(String node) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogNodeServices(node, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService catalogNodeServicesWithOptions(String node, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.ServiceList>> resultHandler) { 
    delegate.catalogNodeServicesWithOptions(node, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.ServiceList> rxCatalogNodeServicesWithOptions(String node, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      catalogNodeServicesWithOptions(node, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService localChecks(Handler<AsyncResult<List<io.vertx.ext.consul.Check>>> resultHandler) { 
    delegate.localChecks(resultHandler);
    return this;
  }

  public Single<List<io.vertx.ext.consul.Check>> rxLocalChecks() { 
    return AsyncResultSingle.toSingle(handler -> {
      localChecks(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService registerCheck(io.vertx.ext.consul.CheckOptions checkOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerCheck(checkOptions, resultHandler);
    return this;
  }

  public Completable rxRegisterCheck(io.vertx.ext.consul.CheckOptions checkOptions) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      registerCheck(checkOptions, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deregisterCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterCheck(checkId, resultHandler);
    return this;
  }

  public Completable rxDeregisterCheck(String checkId) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deregisterCheck(checkId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService passCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheck(checkId, resultHandler);
    return this;
  }

  public Completable rxPassCheck(String checkId) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      passCheck(checkId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService passCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  public Completable rxPassCheckWithNote(String checkId, String note) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      passCheckWithNote(checkId, note, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService warnCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheck(checkId, resultHandler);
    return this;
  }

  public Completable rxWarnCheck(String checkId) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      warnCheck(checkId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService warnCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  public Completable rxWarnCheckWithNote(String checkId, String note) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      warnCheckWithNote(checkId, note, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService failCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheck(checkId, resultHandler);
    return this;
  }

  public Completable rxFailCheck(String checkId) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      failCheck(checkId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService failCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  public Completable rxFailCheckWithNote(String checkId, String note) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      failCheckWithNote(checkId, note, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService updateCheck(String checkId, io.vertx.ext.consul.CheckStatus status, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheck(checkId, status, resultHandler);
    return this;
  }

  public Completable rxUpdateCheck(String checkId, io.vertx.ext.consul.CheckStatus status) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      updateCheck(checkId, status, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService updateCheckWithNote(String checkId, io.vertx.ext.consul.CheckStatus status, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheckWithNote(checkId, status, note, resultHandler);
    return this;
  }

  public Completable rxUpdateCheckWithNote(String checkId, io.vertx.ext.consul.CheckStatus status, String note) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      updateCheckWithNote(checkId, status, note, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService leaderStatus(Handler<AsyncResult<String>> resultHandler) { 
    delegate.leaderStatus(resultHandler);
    return this;
  }

  public Single<String> rxLeaderStatus() { 
    return AsyncResultSingle.toSingle(handler -> {
      leaderStatus(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService peersStatus(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.peersStatus(resultHandler);
    return this;
  }

  public Single<List<String>> rxPeersStatus() { 
    return AsyncResultSingle.toSingle(handler -> {
      peersStatus(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService createSession(Handler<AsyncResult<String>> idHandler) { 
    delegate.createSession(idHandler);
    return this;
  }

  public Single<String> rxCreateSession() { 
    return AsyncResultSingle.toSingle(handler -> {
      createSession(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService createSessionWithOptions(io.vertx.ext.consul.SessionOptions options, Handler<AsyncResult<String>> idHandler) { 
    delegate.createSessionWithOptions(options, idHandler);
    return this;
  }

  public Single<String> rxCreateSessionWithOptions(io.vertx.ext.consul.SessionOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      createSessionWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService infoSession(String id, Handler<AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.infoSession(id, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.Session> rxInfoSession(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      infoSession(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService infoSessionWithOptions(String id, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.infoSessionWithOptions(id, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.Session> rxInfoSessionWithOptions(String id, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      infoSessionWithOptions(id, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService renewSession(String id, Handler<AsyncResult<io.vertx.ext.consul.Session>> resultHandler) { 
    delegate.renewSession(id, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.Session> rxRenewSession(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      renewSession(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listSessions(Handler<AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listSessions(resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.SessionList> rxListSessions() { 
    return AsyncResultSingle.toSingle(handler -> {
      listSessions(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listSessionsWithOptions(options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.SessionList> rxListSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      listSessionsWithOptions(options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listNodeSessions(String nodeId, Handler<AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listNodeSessions(nodeId, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.SessionList> rxListNodeSessions(String nodeId) { 
    return AsyncResultSingle.toSingle(handler -> {
      listNodeSessions(nodeId, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService listNodeSessionsWithOptions(String nodeId, io.vertx.ext.consul.BlockingQueryOptions options, Handler<AsyncResult<io.vertx.ext.consul.SessionList>> resultHandler) { 
    delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.SessionList> rxListNodeSessionsWithOptions(String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      listNodeSessionsWithOptions(nodeId, options, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService destroySession(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroySession(id, resultHandler);
    return this;
  }

  public Completable rxDestroySession(String id) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      destroySession(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService createPreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition, Handler<AsyncResult<String>> resultHandler) { 
    delegate.createPreparedQuery(definition, resultHandler);
    return this;
  }

  public Single<String> rxCreatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return AsyncResultSingle.toSingle(handler -> {
      createPreparedQuery(definition, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getPreparedQuery(String id, Handler<AsyncResult<io.vertx.ext.consul.PreparedQueryDefinition>> resultHandler) { 
    delegate.getPreparedQuery(id, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.PreparedQueryDefinition> rxGetPreparedQuery(String id) { 
    return AsyncResultSingle.toSingle(handler -> {
      getPreparedQuery(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService getAllPreparedQueries(Handler<AsyncResult<List<io.vertx.ext.consul.PreparedQueryDefinition>>> resultHandler) { 
    delegate.getAllPreparedQueries(resultHandler);
    return this;
  }

  public Single<List<io.vertx.ext.consul.PreparedQueryDefinition>> rxGetAllPreparedQueries() { 
    return AsyncResultSingle.toSingle(handler -> {
      getAllPreparedQueries(handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService updatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updatePreparedQuery(definition, resultHandler);
    return this;
  }

  public Completable rxUpdatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      updatePreparedQuery(definition, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService deletePreparedQuery(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deletePreparedQuery(id, resultHandler);
    return this;
  }

  public Completable rxDeletePreparedQuery(String id) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      deletePreparedQuery(id, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService executePreparedQuery(String query, Handler<AsyncResult<io.vertx.ext.consul.PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQuery(query, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.PreparedQueryExecuteResponse> rxExecutePreparedQuery(String query) { 
    return AsyncResultSingle.toSingle(handler -> {
      executePreparedQuery(query, handler);
    });
  }

  public io.vertx.reactivex.ext.consul.ConsulService executePreparedQueryWithOptions(String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options, Handler<AsyncResult<io.vertx.ext.consul.PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQueryWithOptions(query, options, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.consul.PreparedQueryExecuteResponse> rxExecutePreparedQueryWithOptions(String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) { 
    return AsyncResultSingle.toSingle(handler -> {
      executePreparedQueryWithOptions(query, options, handler);
    });
  }

  public void close() { 
    delegate.close();
  }

  public static ConsulService newInstance(io.vertx.ext.consul.ConsulService arg) {
    return arg != null ? new ConsulService(arg) : null;
  }

}
