/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mail;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailService original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.mail.MailService.class)
public class MailService extends io.vertx.reactivex.ext.mail.MailClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailService that = (MailService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MailService> __TYPE_ARG = new TypeArg<>(    obj -> new MailService((io.vertx.ext.mail.MailService) obj),
    MailService::getDelegate
  );

  private final io.vertx.ext.mail.MailService delegate;
  
  public MailService(io.vertx.ext.mail.MailService delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MailService(Object delegate) {
    super((io.vertx.ext.mail.MailService)delegate);
    this.delegate = (io.vertx.ext.mail.MailService)delegate;
  }

  public io.vertx.ext.mail.MailService getDelegate() {
    return delegate;
  }

  /**
   * create a proxy of  MailService that delegates to the mail service running somewhere else via the event bus
   * @param vertx the Vertx instance the proxy will be run in
   * @param address the eb address of the mail service running somewhere, default is "vertx.mail"
   * @return MailService instance that can then be used to send multiple mails
   */
  public static io.vertx.reactivex.ext.mail.MailService createEventBusProxy(io.vertx.reactivex.core.Vertx vertx, String address) { 
    io.vertx.reactivex.ext.mail.MailService ret = io.vertx.reactivex.ext.mail.MailService.newInstance((io.vertx.ext.mail.MailService)io.vertx.ext.mail.MailService.createEventBusProxy(vertx.getDelegate(), address));
    return ret;
  }

  public io.vertx.reactivex.ext.mail.MailService sendMail(io.vertx.ext.mail.MailMessage email, Handler<AsyncResult<io.vertx.ext.mail.MailResult>> resultHandler) { 
    delegate.sendMail(email, resultHandler);
    return this;
  }

  public Single<io.vertx.ext.mail.MailResult> rxSendMail(io.vertx.ext.mail.MailMessage email) { 
    return AsyncResultSingle.toSingle(handler -> {
      sendMail(email, handler);
    });
  }

  public void close() { 
    delegate.close();
  }

  /**
   * The name of the default pool
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.mail.MailService.DEFAULT_POOL_NAME;
  public static MailService newInstance(io.vertx.ext.mail.MailService arg) {
    return arg != null ? new MailService(arg) : null;
  }

}
