/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.stomp;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * STOMP server handler implements the behavior of the STOMP server when a specific event occurs. For instance, if
 * let customize the behavior when specific STOMP frames arrives or when a connection is closed. This class has been
 * designed to let you customize the server behavior. The default implementation is compliant with the STOMP
 * specification. In this default implementation, not acknowledge frames are dropped.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.StompServerHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.stomp.StompServerHandler.class)
public class StompServerHandler implements Handler<io.vertx.reactivex.ext.stomp.ServerFrame> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StompServerHandler that = (StompServerHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<StompServerHandler> __TYPE_ARG = new TypeArg<>(    obj -> new StompServerHandler((io.vertx.ext.stomp.StompServerHandler) obj),
    StompServerHandler::getDelegate
  );

  private final io.vertx.ext.stomp.StompServerHandler delegate;
  
  public StompServerHandler(io.vertx.ext.stomp.StompServerHandler delegate) {
    this.delegate = delegate;
  }

  public StompServerHandler(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.StompServerHandler)delegate;
  }

  public io.vertx.ext.stomp.StompServerHandler getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.stomp.Destination> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.stomp.Destination>(o1 -> io.vertx.reactivex.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)o1), o1 -> o1.getDelegate());

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.stomp.ServerFrame event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Creates an instance of {@link io.vertx.reactivex.ext.stomp.StompServerHandler} using the default (compliant) implementation.
   * @param vertx the vert.x instance to use
   * @return the created {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public static io.vertx.reactivex.ext.stomp.StompServerHandler create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.stomp.StompServerHandler ret = io.vertx.reactivex.ext.stomp.StompServerHandler.newInstance((io.vertx.ext.stomp.StompServerHandler)io.vertx.ext.stomp.StompServerHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Configures a handler that get notified when a STOMP frame is received by the server.
   * This handler can be used for logging, debugging or ad-hoc behavior.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler receivedFrameHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.receivedFrameHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>CONNECT</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler connectHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.connectHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>STOMP</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler stompHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.stompHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>SUBSCRIBE</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler subscribeHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.subscribeHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>UNSUBSCRIBE</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler unsubscribeHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.unsubscribeHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>SEND</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler sendHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.sendHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a connection with the client is closed.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler closeHandler(Handler<io.vertx.reactivex.ext.stomp.StompServerConnection> handler) { 
    delegate.closeHandler(new Handler<io.vertx.ext.stomp.StompServerConnection>() {
      public void handle(io.vertx.ext.stomp.StompServerConnection event) {
        handler.handle(io.vertx.reactivex.ext.stomp.StompServerConnection.newInstance((io.vertx.ext.stomp.StompServerConnection)event));
      }
    });
    return this;
  }

  /**
   * Called when the connection is closed. This method executes a default behavior and must calls the configured
   * {@link io.vertx.reactivex.ext.stomp.StompServerHandler#closeHandler} if any.
   * @param connection the connection
   */
  public void onClose(io.vertx.reactivex.ext.stomp.StompServerConnection connection) { 
    delegate.onClose(connection.getDelegate());
  }

  /**
   * Configures the action to execute when a <code>COMMIT</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler commitHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.commitHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>ABORT</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler abortHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.abortHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>BEGIN</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler beginHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.beginHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>DISCONNECT</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler disconnectHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.disconnectHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>ACK</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler ackHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.ackHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when a <code>NACK</code> frame is received.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler nackHandler(Handler<io.vertx.reactivex.ext.stomp.ServerFrame> handler) { 
    delegate.nackHandler(new Handler<io.vertx.ext.stomp.ServerFrame>() {
      public void handle(io.vertx.ext.stomp.ServerFrame event) {
        handler.handle(io.vertx.reactivex.ext.stomp.ServerFrame.newInstance((io.vertx.ext.stomp.ServerFrame)event));
      }
    });
    return this;
  }

  /**
   * Called when the client connects to a server requiring authentication. It invokes the  configured
   * using {@link io.vertx.reactivex.ext.stomp.StompServerHandler#authProvider}.
   * @param connection server connection that contains session ID
   * @param login the login
   * @param passcode the password
   * @param handler handler receiving the authentication result
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler onAuthenticationRequest(io.vertx.reactivex.ext.stomp.StompServerConnection connection, String login, String passcode, Handler<AsyncResult<Boolean>> handler) { 
    delegate.onAuthenticationRequest(connection.getDelegate(), login, passcode, handler);
    return this;
  }

  /**
   * Called when the client connects to a server requiring authentication. It invokes the  configured
   * using {@link io.vertx.reactivex.ext.stomp.StompServerHandler#authProvider}.
   * @param connection server connection that contains session ID
   * @param login the login
   * @param passcode the password
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public Single<Boolean> rxOnAuthenticationRequest(io.vertx.reactivex.ext.stomp.StompServerConnection connection, String login, String passcode) { 
    return AsyncResultSingle.toSingle(handler -> {
      onAuthenticationRequest(connection, login, passcode, handler);
    });
  }

  /**
   * Provides for authorization matches on a destination level, this will return the User created by the .
   * @param session session ID for the server connection.
   * @return null if not authenticated.
   */
  public io.vertx.reactivex.ext.auth.User getUserBySession(String session) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.getUserBySession(session));
    return ret;
  }

  /**
   * Configures the  to be used to authenticate the user.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler authProvider(io.vertx.reactivex.ext.auth.AuthProvider handler) { 
    delegate.authProvider(handler.getDelegate());
    return this;
  }

  /**
   * @return the list of destination managed by the STOMP server. Don't forget the STOMP interprets destination as opaque Strings.
   */
  public List<io.vertx.reactivex.ext.stomp.Destination> getDestinations() { 
    List<io.vertx.reactivex.ext.stomp.Destination> ret = delegate.getDestinations().stream().map(elt -> io.vertx.reactivex.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * Gets the destination with the given name.
   * @param destination the destination
   * @return the {@link io.vertx.reactivex.ext.stomp.Destination}, <code>null</code> if not existing.
   */
  public io.vertx.reactivex.ext.stomp.Destination getDestination(String destination) { 
    io.vertx.reactivex.ext.stomp.Destination ret = io.vertx.reactivex.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)delegate.getDestination(destination));
    return ret;
  }

  /**
   * Method called by single message (client-individual policy) or a set of message (client policy) are acknowledged.
   * Implementations must call the handler configured using {@link io.vertx.reactivex.ext.stomp.StompServerHandler#onAckHandler}.
   * @param connection the connection
   * @param subscribe the <code>SUBSCRIBE</code> frame
   * @param messages the acknowledge messages
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler onAck(io.vertx.reactivex.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame subscribe, List<io.vertx.ext.stomp.Frame> messages) { 
    delegate.onAck(connection.getDelegate(), subscribe, messages);
    return this;
  }

  /**
   * Method called by single message (client-individual policy) or a set of message (client policy) are
   * <strong>not</strong> acknowledged. Not acknowledgment can result from a <code>NACK</code> frame or from a timeout (no
   * <code>ACK</code> frame received in a given time. Implementations must call the handler configured using
   * {@link io.vertx.reactivex.ext.stomp.StompServerHandler#onNackHandler}.
   * @param connection the connection
   * @param subscribe the <code>SUBSCRIBE</code> frame
   * @param messages the acknowledge messages
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler onNack(io.vertx.reactivex.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame subscribe, List<io.vertx.ext.stomp.Frame> messages) { 
    delegate.onNack(connection.getDelegate(), subscribe, messages);
    return this;
  }

  /**
   * Configures the action to execute when messages are acknowledged.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler onAckHandler(Handler<io.vertx.reactivex.ext.stomp.Acknowledgement> handler) { 
    delegate.onAckHandler(new Handler<io.vertx.ext.stomp.Acknowledgement>() {
      public void handle(io.vertx.ext.stomp.Acknowledgement event) {
        handler.handle(io.vertx.reactivex.ext.stomp.Acknowledgement.newInstance((io.vertx.ext.stomp.Acknowledgement)event));
      }
    });
    return this;
  }

  /**
   * Configures the action to execute when messages are <strong>not</strong> acknowledged.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler onNackHandler(Handler<io.vertx.reactivex.ext.stomp.Acknowledgement> handler) { 
    delegate.onNackHandler(new Handler<io.vertx.ext.stomp.Acknowledgement>() {
      public void handle(io.vertx.ext.stomp.Acknowledgement event) {
        handler.handle(io.vertx.reactivex.ext.stomp.Acknowledgement.newInstance((io.vertx.ext.stomp.Acknowledgement)event));
      }
    });
    return this;
  }

  /**
   * Allows customizing the action to do when the server needs to send a `PING` to the client. By default it send a
   * frame containing <code>EOL</code> (specification). However, you can customize this and send another frame. However,
   * be aware that this may requires a custom client.
   * <p/>
   * The handler will only be called if the connection supports heartbeats.
   * @param handler the action to execute when a `PING` needs to be sent.
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler pingHandler(Handler<io.vertx.reactivex.ext.stomp.StompServerConnection> handler) { 
    delegate.pingHandler(new Handler<io.vertx.ext.stomp.StompServerConnection>() {
      public void handle(io.vertx.ext.stomp.StompServerConnection event) {
        handler.handle(io.vertx.reactivex.ext.stomp.StompServerConnection.newInstance((io.vertx.ext.stomp.StompServerConnection)event));
      }
    });
    return this;
  }

  /**
   * Gets a {@link io.vertx.reactivex.ext.stomp.Destination} object if existing, or create a new one. The creation is delegated to the
   * {@link io.vertx.reactivex.ext.stomp.DestinationFactory}.
   * @param destination the destination
   * @return the {@link io.vertx.reactivex.ext.stomp.Destination} instance, may have been created.
   */
  public io.vertx.reactivex.ext.stomp.Destination getOrCreateDestination(String destination) { 
    io.vertx.reactivex.ext.stomp.Destination ret = io.vertx.reactivex.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)delegate.getOrCreateDestination(destination));
    return ret;
  }

  /**
   * Configures the {@link io.vertx.reactivex.ext.stomp.DestinationFactory} used to create {@link io.vertx.reactivex.ext.stomp.Destination} objects.
   * @param factory the factory
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}.
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler destinationFactory(io.vertx.reactivex.ext.stomp.DestinationFactory factory) { 
    delegate.destinationFactory(factory.getDelegate());
    return this;
  }

  /**
   * Configures the STOMP server to act as a bridge with the Vert.x event bus.
   * @param options the configuration options
   * @return the current {@link io.vertx.reactivex.ext.stomp.StompServerHandler}.
   */
  public io.vertx.reactivex.ext.stomp.StompServerHandler bridge(io.vertx.ext.stomp.BridgeOptions options) { 
    delegate.bridge(options);
    return this;
  }

  public static StompServerHandler newInstance(io.vertx.ext.stomp.StompServerHandler arg) {
    return arg != null ? new StompServerHandler(arg) : null;
  }

}
