/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Handler that will timeout requests if the response has not been written after a certain time.
 * Timeout requests will be ended with an HTTP status code `503`.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.TimeoutHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.TimeoutHandler.class)
public class TimeoutHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeoutHandler that = (TimeoutHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TimeoutHandler> __TYPE_ARG = new TypeArg<>(    obj -> new TimeoutHandler((io.vertx.ext.web.handler.TimeoutHandler) obj),
    TimeoutHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.TimeoutHandler delegate;
  
  public TimeoutHandler(io.vertx.ext.web.handler.TimeoutHandler delegate) {
    this.delegate = delegate;
  }

  public TimeoutHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.TimeoutHandler)delegate;
  }

  public io.vertx.ext.web.handler.TimeoutHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.TimeoutHandler create() { 
    io.vertx.reactivex.ext.web.handler.TimeoutHandler ret = io.vertx.reactivex.ext.web.handler.TimeoutHandler.newInstance((io.vertx.ext.web.handler.TimeoutHandler)io.vertx.ext.web.handler.TimeoutHandler.create());
    return ret;
  }

  /**
   * Create a handler
   * @param timeout the timeout, in ms
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.TimeoutHandler create(long timeout) { 
    io.vertx.reactivex.ext.web.handler.TimeoutHandler ret = io.vertx.reactivex.ext.web.handler.TimeoutHandler.newInstance((io.vertx.ext.web.handler.TimeoutHandler)io.vertx.ext.web.handler.TimeoutHandler.create(timeout));
    return ret;
  }

  /**
   * Create a handler
   * @param timeout the timeout, in ms
   * @param errorCode 
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.TimeoutHandler create(long timeout, int errorCode) { 
    io.vertx.reactivex.ext.web.handler.TimeoutHandler ret = io.vertx.reactivex.ext.web.handler.TimeoutHandler.newInstance((io.vertx.ext.web.handler.TimeoutHandler)io.vertx.ext.web.handler.TimeoutHandler.create(timeout, errorCode));
    return ret;
  }

  /**
   * The default timeout, in ms
   */
  public static final long DEFAULT_TIMEOUT = io.vertx.ext.web.handler.TimeoutHandler.DEFAULT_TIMEOUT;
  /**
   * The default error code
   */
  public static final int DEFAULT_ERRORCODE = io.vertx.ext.web.handler.TimeoutHandler.DEFAULT_ERRORCODE;
  public static TimeoutHandler newInstance(io.vertx.ext.web.handler.TimeoutHandler arg) {
    return arg != null ? new TimeoutHandler(arg) : null;
  }

}
