/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.pgclient;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A pool of PostgreSQL connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.PgPool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.pgclient.PgPool.class)
public class PgPool extends io.vertx.reactivex.sqlclient.Pool {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgPool that = (PgPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PgPool> __TYPE_ARG = new TypeArg<>(    obj -> new PgPool((io.vertx.pgclient.PgPool) obj),
    PgPool::getDelegate
  );

  private final io.vertx.pgclient.PgPool delegate;
  
  public PgPool(io.vertx.pgclient.PgPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PgPool(Object delegate) {
    super((io.vertx.pgclient.PgPool)delegate);
    this.delegate = (io.vertx.pgclient.PgPool)delegate;
  }

  public io.vertx.pgclient.PgPool getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgPool#pool} with a default <code>poolOptions</code>.
   * @return 
   */
  public static io.vertx.reactivex.pgclient.PgPool pool() { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgPool#pool} with <code>connectOptions</code> build from the environment variables.
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.pgclient.PgPool pool(io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgPool#pool} with a default <code>poolOptions</code>.
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.reactivex.pgclient.PgPool pool(String connectionUri) { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgPool#pool} with <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.pgclient.PgPool pool(String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(connectionUri, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgPool#pool} with a default <code>poolOptions</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.reactivex.pgclient.PgPool pool(io.vertx.reactivex.core.Vertx vertx, String connectionUri) { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgPool#pool} with <code>connectOptions</code> build from the environment variables.
   * @param vertx 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.pgclient.PgPool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgPool#pool} with <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.pgclient.PgPool pool(io.vertx.reactivex.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  /**
   * Create a connection pool to the database configured with the given <code>connectOptions</code> and <code>poolOptions</code>.
   * @param connectOptions 
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.pgclient.PgPool pool(io.vertx.pgclient.PgConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(connectOptions, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgPool#pool} with a specific  instance.
   * @param vertx 
   * @param connectOptions 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.pgclient.PgPool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.pgclient.PgPool ret = io.vertx.reactivex.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  public static PgPool newInstance(io.vertx.pgclient.PgPool arg) {
    return arg != null ? new PgPool(arg) : null;
  }

}
